/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.editable;

import de.elpro.ui.fx.cells.editable.internal.CellUtils;
import de.elpro.ui.fx.controls.NumericField;
import java.text.DecimalFormat;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.util.StringConverter;

public class NumericFieldTableCell<S, T extends Number>
extends TableCell<S, T> {
    public static final String STYLE_CLASS = "numeric-cell";
    public static final String STYLE_TABLE_CLASS = "numeric-table-cell";
    private final Class<? extends Number> cls;
    protected NumericField numberField;
    protected final boolean positiveOnly;
    protected final DecimalFormat decimalFormat;
    private boolean escapePressed = false;
    private TablePosition<S, ?> editingCell = null;
    private final StringConverter<Number> converter = new StringConverter<Number>(){

        public String toString(Number object) {
            if (object == null) {
                return null;
            }
            return NumericFieldTableCell.this.decimalFormat.format(object);
        }

        public Number fromString(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            try {
                return NumericFieldTableCell.this.decimalFormat.parse(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
    };

    public NumericFieldTableCell(Class<? extends Number> cls, DecimalFormat decimalFormat) {
        this(cls, decimalFormat, false);
    }

    public NumericFieldTableCell(Class<? extends Number> cls, DecimalFormat decimalFormat, boolean positiveOnly) {
        this.cls = cls;
        this.decimalFormat = decimalFormat;
        this.positiveOnly = positiveOnly;
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS, STYLE_TABLE_CLASS});
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            this.escapePressed = false;
            CellUtils.startEdit(this, this.getNumberField());
            TableView table = this.getTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            this.escapePressed = true;
            return;
        }
        TableView table = this.getTableView();
        TablePosition<S, ?> cell = null;
        if (table != null && (cell = table.getEditingCell()) == null && this.editingCell != null) {
            cell = this.editingCell;
            this.editingCell = null;
            table.edit(cell.getRow(), cell.getTableColumn());
        }
        if (cell != null) {
            this.escapePressed = true;
            super.commitEdit(newValue);
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            this.escapePressed = true;
            NumericField nf = this.getNumberField();
            Number value = nf.getValue();
            Number itemVal = (Number)this.getItem();
            if (value == null && itemVal != null || value != null && itemVal == null || value != null && !value.equals(itemVal)) {
                this.commitEdit((T)value);
            }
        }
        super.cancelEdit();
        this.setText(this.converter.toString((Object)((Number)this.getItem())));
        this.setGraphic(null);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            NumericField nf = this.getNumberField();
            nf.setValue((Number)item);
            this.setGraphic((Node)nf);
        } else {
            if (item != null) {
                this.setText(this.decimalFormat.format(item));
            } else {
                this.setText(null);
            }
            this.setGraphic(null);
        }
    }

    protected NumericField getNumberField() {
        if (this.numberField == null) {
            this.numberField = this.createNumberField();
        }
        return this.numberField;
    }

    protected NumericField createNumberField() {
        NumericField numberField = new NumericField(this.cls, this.decimalFormat);
        numberField.setPositiveOnly(this.positiveOnly);
        numberField.setOnAction(event -> {
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                Number value = numberField.getValue();
                this.commitEdit((T)value);
                this.requestFocus();
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
            this.requestFocus();
        });
        numberField.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        numberField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        numberField.focusedProperty().addListener((o, ov, nv) -> {
            if (ov.booleanValue() && !nv.booleanValue()) {
                this.commitEdit((T)numberField.getValue());
            }
        });
        return numberField;
    }
}

