/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.editable;

import de.elpro.ui.fx.cells.editable.internal.CellUtils;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.util.StringConverter;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;

public class TextFieldTableCell<S, T>
extends TableCell<S, T> {
    protected TextField textField;
    private boolean escapePressed = false;
    private TablePosition<S, ?> editingCell = null;
    private final StringConverter<T> converter;
    private final Validator validator;

    public TextFieldTableCell(StringConverter<T> converter) {
        this(converter, null);
    }

    public TextFieldTableCell(StringConverter<T> converter, Validator validator) {
        this.converter = converter;
        this.validator = validator;
    }

    protected TextField getTextField() {
        if (this.textField == null) {
            this.textField = this.createTextField();
        }
        return this.textField;
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            this.escapePressed = false;
            this.getGraphic();
            CellUtils.startEdit(this, this.converter, this.getTextField());
            TableView table = this.getTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            this.escapePressed = true;
            return;
        }
        TableView table = this.getTableView();
        TablePosition<S, ?> cell = null;
        if (table != null && (cell = table.getEditingCell()) == null && this.editingCell != null) {
            cell = this.editingCell;
            this.editingCell = null;
            table.edit(cell.getRow(), cell.getTableColumn());
        }
        if (cell != null) {
            this.escapePressed = true;
            super.commitEdit(newValue);
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            this.escapePressed = true;
            TextField textField = this.getTextField();
            textField.commitValue();
            Object value = this.converter.fromString(textField.getText());
            Object itemVal = this.getItem();
            if (value == null && itemVal != null || value != null && itemVal == null || value != null && !value.equals(itemVal)) {
                this.commitEdit(value);
            }
        } else {
            this.textField.setText(this.converter.toString(this.getItem()));
        }
        super.cancelEdit();
        this.setText(this.converter.toString(this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            TextField nf = this.getTextField();
            nf.setText(this.converter.toString(item));
            this.setGraphic((Node)nf);
        } else {
            if (item != null) {
                this.setText(this.converter.toString(item));
            } else {
                this.setText(null);
            }
            this.setGraphic(null);
        }
    }

    protected TextField createTextField() {
        TextField textField = new TextField();
        textField.setOnAction(event -> {
            if (this.converter == null) {
                throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
            }
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                String value = textField.getText();
                this.commitEdit(this.converter.fromString(value));
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
            this.requestFocus();
        });
        textField.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        textField.focusedProperty().addListener((o, ov, nv) -> {
            if (ov.booleanValue() && !nv.booleanValue()) {
                try {
                    Object value = this.converter.fromString(textField.getText());
                    this.commitEdit(value);
                }
                catch (Exception exception) {
                    this.escapePressed = true;
                    this.cancelEdit();
                }
            }
        });
        if (this.validator != null) {
            ValidationUtils.install((Node)this, (ObservableValue)textField.textProperty(), (Validator)this.validator, (ValidationMode)ValidationMode.ON_FLY);
        }
        return textField;
    }
}

