/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.uimodel;

import de.elpro.ui.model.UILabeledElement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.control.ListCell;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Callback;

public class UIModelListCell<T extends UILabeledElement>
extends ListCell<T> {
    private final List<String> defaultStyleClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());
    private final Callback<T, String> labelCallback;
    private final Font defaultFont = this.getFont();

    public UIModelListCell() {
        this.labelCallback = null;
    }

    public UIModelListCell(Callback<T, String> labelCallback) {
        this.labelCallback = labelCallback;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
            this.setStyleClass(new String[0]);
        } else {
            this.setGraphic(item.getGraphic());
            if (this.labelCallback == null) {
                this.textProperty().bind(item.textProperty());
            } else {
                this.textProperty().unbind();
                this.setText((String)this.labelCallback.call(item));
            }
            this.setTextFill(item.getTextFill());
            this.setFont(this.getFont(item.getFontWeight()));
            this.setStyleClass(item.isEnabled() ? "enabled" : "disabled");
        }
    }

    public Font getFont(FontWeight fontWeight) {
        return Font.font((String)this.defaultFont.getFamily(), (FontWeight)fontWeight, (double)this.defaultFont.getSize());
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultStyleClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }
}

