/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.uimodel;

import de.elpro.ui.fx.cells.AdjustCellListener;
import de.elpro.ui.model.UILabeledElement;
import de.elpro.ui.model.UnidirectionalStringConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class UIModelTableCell<S, T extends UILabeledElement>
extends TableCell<S, T> {
    private final UnidirectionalStringConverter<T> stringConverter;
    private final boolean showLabel;
    private final AdjustCellListener<T> onAdjustCell;
    private final Font defaultFont = this.getFont();
    private final List<String> defaultStyleClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());

    public UIModelTableCell() {
        this(true, null, new String[0]);
    }

    public UIModelTableCell(String defaultStyleClasses) {
        this(true, null, defaultStyleClasses);
    }

    public UIModelTableCell(UnidirectionalStringConverter<T> stringConveter) {
        this(stringConveter, null, new String[0]);
    }

    public UIModelTableCell(AdjustCellListener<T> onAdjustCell, String ... defaultStyleClasses) {
        this(null, onAdjustCell, new String[0]);
    }

    public UIModelTableCell(boolean showLablel, AdjustCellListener<T> onAdjustCell, String ... defaultStyleClasses) {
        this.defaultStyleClasses.addAll(Arrays.asList(defaultStyleClasses));
        this.stringConverter = null;
        this.showLabel = showLablel;
        this.onAdjustCell = null;
    }

    public UIModelTableCell(boolean showLablel) {
        this(true, null, new String[0]);
    }

    public UIModelTableCell(UnidirectionalStringConverter<T> stringConveter, AdjustCellListener<T> onAdjustCell, String ... defaultStyleClasses) {
        this.defaultStyleClasses.addAll(Arrays.asList(defaultStyleClasses));
        this.stringConverter = stringConveter;
        this.showLabel = true;
        this.onAdjustCell = onAdjustCell;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (this.onAdjustCell != null) {
            this.onAdjustCell.adjustCell((Cell<T>)this, item);
        }
        if (empty || item == null) {
            this.setGraphic(null);
            this.textProperty().unbind();
            this.setText(null);
            this.setStyleClass(new String[0]);
        } else {
            this.setGraphic(item.getGraphic());
            if (this.showLabel) {
                if (this.stringConverter == null) {
                    this.textProperty().bind(item.textProperty());
                } else {
                    this.setText(this.stringConverter.toString(item));
                }
                this.setTextFill(item.getTextFill());
                this.setFont(this.getFont(item.getFontWeight()));
            }
            this.setStyleClass(item.isEnabled() ? "enabled" : "disabled");
        }
    }

    public Font getFont(FontWeight fontWeight) {
        return Font.font((String)this.defaultFont.getFamily(), (FontWeight)fontWeight, (double)this.defaultFont.getSize());
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultStyleClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }
}

