/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.cells.uimodel.dnd;

import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UILabeledElement;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class DnDUIModelTableCell<S extends IdObject, T extends UILabeledElement>
extends UIModelTableCell<S, T> {
    public DnDUIModelTableCell() {
        DnDUIModelTableCell thisCell = this;
        this.setOnDragDetected(event -> {
            IdObject thisItem = (IdObject)this.getTableRow().getItem();
            if (thisItem == null) {
                return;
            }
            Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            ClipboardContent content = new ClipboardContent();
            content.putString(thisItem.getId() != null ? thisItem.getFullId() : thisItem.getAltId());
            dragboard.setContent((Map)content);
            event.consume();
        });
        this.setOnDragOver(event -> {
            if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.setOnDragEntered(event -> {
            if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                this.setOpacity(0.3);
            }
        });
        this.setOnDragExited(event -> {
            if (event.getGestureSource() != thisCell && event.getDragboard().hasString()) {
                this.setOpacity(1.0);
            }
        });
        this.setOnDragDropped(event -> {
            IdObject thisItem = (IdObject)this.getTableRow().getItem();
            if (thisItem == null) {
                return;
            }
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString()) {
                ObservableList items = this.getTableView().getItems();
                int draggedIdx = -1;
                ClassLoader classLoader = thisItem.getClass().getClassLoader();
                IdObject draggedItemId = IdObject.getObjectByFullId((ClassLoader)classLoader, (String)db.getString());
                IdObject draggedItem = null;
                for (IdObject item : items) {
                    if ((draggedItemId == null || !draggedItemId.equals(item)) && !item.getAltId().equals(db.getString())) continue;
                    draggedItem = item;
                    draggedIdx = items.indexOf((Object)item);
                }
                if (draggedIdx == -1) {
                    return;
                }
                int thisIdx = items.indexOf((Object)thisItem);
                items.remove(draggedIdx);
                items.add(thisIdx, (Object)draggedItem);
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        this.setOnDragDone(Event::consume);
    }
}

