/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;

public class ClearableColorPicker
extends ColorPicker {
    private BooleanProperty _clearbuttonVisibleProperty;
    private Decorator<Button> _clearButtonDecorator;

    public BooleanProperty clearButtonVisibleProperty() {
        if (this._clearbuttonVisibleProperty == null) {
            this._clearbuttonVisibleProperty = new SimpleBooleanProperty((Object)this, "clearButtonVisible"){

                protected void invalidated() {
                    super.invalidated();
                    if (this.get()) {
                        ClearableColorPicker.this.showClearButton();
                    } else {
                        ClearableColorPicker.this.hideClearButton();
                    }
                }
            };
        }
        return this._clearbuttonVisibleProperty;
    }

    public boolean isClearButtonVisible() {
        return this.clearButtonVisibleProperty().get();
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.clearButtonVisibleProperty().set(clearButtonVisible);
    }

    private void showClearButton() {
        if (this._clearButtonDecorator == null) {
            this._clearButtonDecorator = (Decorator)PredefinedDecorators.getInstance().getClearButtonDecoratorSupplier().get();
            ((Button)this._clearButtonDecorator.getNode()).disableProperty().bind((ObservableValue)this.disabledProperty());
            ((Button)this._clearButtonDecorator.getNode()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (!ClearableColorPicker.this.isDisabled()) {
                        ClearableColorPicker.this.setValue(null);
                    }
                }
            });
        }
        DecorationUtils.install((Node)this, this._clearButtonDecorator);
    }

    private void hideClearButton() {
        if (this._clearButtonDecorator != null) {
            DecorationUtils.uninstall((Node)this, this._clearButtonDecorator);
        }
    }
}

