/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.control.CheckBox;

public class IntermediateCheckBox
extends CheckBox {
    private boolean updateValue = false;
    private final Property<Boolean> value = new SimpleObjectProperty((Object)false);
    private final InvalidationListener il = o -> {
        if (this.updateValue) {
            return;
        }
        Boolean compositeValue = this.getCompositeValue();
        if (this.value.getValue() == null) {
            if (compositeValue != null) {
                this.value.setValue((Object)compositeValue);
            }
        } else if (!((Boolean)this.value.getValue()).equals(compositeValue)) {
            this.value.setValue((Object)compositeValue);
        }
    };

    public IntermediateCheckBox() {
        this(null);
    }

    public IntermediateCheckBox(String txt) {
        super(txt);
        this.setAllowIndeterminate(true);
        this.selectedProperty().addListener(this.il);
        this.indeterminateProperty().addListener(this.il);
        this.value.addListener((o, ov, nv) -> {
            try {
                this.updateValue = true;
                if (nv == null) {
                    this.setSelected(false);
                    this.setIndeterminate(true);
                } else if (nv.booleanValue()) {
                    this.setIndeterminate(false);
                    this.setSelected(true);
                } else {
                    this.setSelected(false);
                    this.setIndeterminate(false);
                }
            }
            finally {
                this.updateValue = false;
            }
        });
    }

    public Boolean getCompositeValue() {
        if (this.isIndeterminate()) {
            return null;
        }
        if (this.isSelected()) {
            return true;
        }
        return false;
    }

    public void setCompositeValue(Boolean value) {
        this.compositeValueProperty().setValue((Object)value);
    }

    public Property<Boolean> compositeValueProperty() {
        return this.value;
    }

    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.setIndeterminate(false);
            this.fireEvent((Event)new ActionEvent());
        }
    }
}

