/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls;

import de.elpro.ui.fx.utils.FXUtils;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.CompoundValidationDecoration;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.StyleClassValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class NumericField
extends TextField {
    private static ValidationSupport validationSupport = new ValidationSupport();
    private final NumericValidator value;
    private DecimalFormat format;
    private boolean positiveOnly;
    private boolean formating;
    private Class<? extends Number> cls;
    private final Label suffixLabel;
    private final AnchorPane suffixPane;
    private final ObjectProperty<SuffixOrientation> suffixOrientation;

    public NumericField(Class<? extends Number> cls, String pattern) {
        this(cls, pattern, null);
    }

    public NumericField(Class<? extends Number> cls, DecimalFormat format) {
        this(cls, format, null);
    }

    public NumericField(Class<? extends Number> cls, String pattern, List<Validator<Number>> validators) {
        this(cls, new DecimalFormat(pattern), validators);
    }

    public NumericField(Class<? extends Number> cls, DecimalFormat format, List<Validator<Number>> validators) {
        validationSupport.setValidationDecorator((ValidationDecoration)new CompoundValidationDecoration(new ValidationDecoration[]{new GraphicValidationDecoration(), new StyleClassValidationDecoration()}));
        this.positiveOnly = false;
        this.formating = false;
        this.suffixLabel = new Label();
        this.suffixPane = new AnchorPane(new Node[]{this.suffixLabel});
        this.suffixOrientation = new SimpleObjectProperty((Object)SuffixOrientation.ValueFloating);
        this.getStyleClass().add((Object)"numeric-field");
        this.suffixLabel.getStyleClass().add((Object)"suffix-label");
        this.cls = cls;
        this.value = cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == BigInteger.class ? new LongValidator(this, !cls.isPrimitive()) : new DoubleValidator(this, !cls.isPrimitive());
        this.setFormat(format);
        this.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (NumericField.this.formating) {
                    return;
                }
                String text = NumericField.this.getText();
                if (!NumericField.this.positiveOnly && "-".equals(text)) {
                    return;
                }
                if (text != null && (text.toLowerCase().endsWith("e") || text.toLowerCase().endsWith("e-"))) {
                    return;
                }
                Number n = NumericField.this.value.toNumber(NumericField.this.getText());
                NumericField.this.value.setValue(n);
            }
        });
        if (validators != null) {
            for (Validator<Number> validator : validators) {
                validationSupport.registerValidator((Control)this, validator);
            }
        }
        this.focusedProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                this.formatText();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.formatText();
                this.positionCaret(this.getText() != null ? this.getText().length() : 0);
            }
        });
    }

    public void setShowAllFractionDigits(boolean showAllFractionDigits) {
        this.format.setMaximumFractionDigits(showAllFractionDigits ? 340 : this.format.getMinimumFractionDigits());
        this.formatText();
    }

    protected Skin<?> createDefaultSkin() {
        Skin skin = super.createDefaultSkin();
        this.getChildren().add((Object)this.suffixPane);
        Pane pane = FXUtils.findChild((Node)this, Pane.class);
        Text text = pane != null ? FXUtils.findChild((Node)pane, Text.class) : null;
        if (text != null) {
            Runnable recomuteAnchor = () -> {
                SuffixOrientation orientation = this.getSuffixOrientation();
                if (orientation == null) {
                    orientation = SuffixOrientation.ValueFloating;
                }
                AnchorPane.clearConstraints((Node)this.suffixLabel);
                if (orientation == SuffixOrientation.ValueFloating) {
                    double textRichtEdge = text.getX() + text.getLayoutBounds().getWidth();
                    double maxValue = this.getWidth() - 5.0 - this.suffixLabel.getWidth();
                    double leftAnchor = Math.max(0.0, Math.min(textRichtEdge + 5.0, maxValue));
                    AnchorPane.setLeftAnchor((Node)this.suffixLabel, (Double)leftAnchor);
                } else {
                    AnchorPane.setRightAnchor((Node)this.suffixLabel, (Double)0.0);
                }
            };
            text.layoutBoundsProperty().addListener(il -> recomuteAnchor.run());
            this.widthProperty().addListener(il -> recomuteAnchor.run());
            this.suffixOrientationProperty().addListener(il -> recomuteAnchor.run());
        } else {
            AnchorPane.setRightAnchor((Node)this.suffixLabel, (Double)5.0);
        }
        return skin;
    }

    public String getSuffixText() {
        return this.suffixLabel.getText();
    }

    public void setSuffixText(String suffix) {
        this.suffixLabel.setText(suffix);
    }

    public final ObjectProperty<SuffixOrientation> suffixOrientationProperty() {
        return this.suffixOrientation;
    }

    public final SuffixOrientation getSuffixOrientation() {
        return (SuffixOrientation)((Object)this.suffixOrientationProperty().get());
    }

    public final void setSuffixOrientation(SuffixOrientation suffixOrientation) {
        this.suffixOrientationProperty().set((Object)suffixOrientation);
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat format) {
        this.format = (DecimalFormat)format.clone();
        String suffixText = this.format.getPositiveSuffix();
        if (suffixText != null && !suffixText.equals(this.format.getNegativeSuffix())) {
            suffixText = null;
        }
        this.format.setPositiveSuffix("");
        this.format.setNegativeSuffix("");
        this.format.setNegativePrefix("-");
        this.formatText();
    }

    public boolean isPositiveOnly() {
        return this.positiveOnly;
    }

    public void setPositiveOnly(boolean positiveOnly) {
        this.positiveOnly = positiveOnly;
    }

    public final ObservableValue<Number> valueProperty() {
        return this.value;
    }

    public Number getValue() {
        return (Number)this.value.getValue();
    }

    public void setValue(Number value) {
        this.value.setValue(value);
        this.formatText();
    }

    protected void formatText() {
        int caretPosition = this.getCaretPosition();
        this.formating = true;
        Number value = (Number)this.value.getValue();
        if (value == null) {
            this.setText(null);
        } else {
            String text = this.format != null ? this.format.format(value) : value.toString();
            this.setText(text);
        }
        if (this.getText() != null) {
            this.positionCaret(Math.min(caretPosition, this.getText().length()));
        }
        this.formating = false;
    }

    public void replaceText(int start, int end, String text) {
        if (this.replaceValid(start, end, text).booleanValue()) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        IndexRange range = this.getSelection();
        if (this.replaceValid(range.getStart(), range.getEnd(), text).booleanValue()) {
            super.replaceSelection(text);
        }
    }

    private Boolean replaceValid(int start, int end, String fragment) {
        try {
            String newText;
            if (start == 0 && "-".equals(fragment)) {
                return !this.positiveOnly;
            }
            String oldText = this.getText();
            if (oldText == null) {
                oldText = "";
            }
            if ((newText = String.valueOf(oldText.substring(0, start)) + fragment + oldText.substring(end)).isEmpty()) {
                return true;
            }
            if (!this.positiveOnly && "-".equals(newText)) {
                return true;
            }
            if ((newText.toLowerCase().endsWith("e") || newText.toLowerCase().endsWith("e-")) && newText.chars().filter(c -> c == 101).count() == 1L) {
                return true;
            }
            this.value.toNumber(newText.replace('e', 'E'));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static NumericField createDoubleField(DecimalFormat format, DoubleProperty property) {
        NumericField numericEditor = new NumericField(Double.TYPE, format);
        numericEditor.setValue(property.get());
        numericEditor.focusedProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                property.set(numericEditor.getValue().doubleValue());
            }
            numericEditor.setShowAllFractionDigits((boolean)nv);
        });
        numericEditor.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                property.set(numericEditor.getValue().doubleValue());
                numericEditor.formatText();
            }
        });
        return numericEditor;
    }

    public static NumericField createNullableDoubleField(DecimalFormat format, ObjectProperty<Double> property) {
        NumericField numericEditor = new NumericField(Double.class, format);
        numericEditor.setValue((Number)property.get());
        numericEditor.focusedProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                if (numericEditor.getValue() != null) {
                    double newValue = numericEditor.getValue().doubleValue();
                    if (property.get() != null && ((Double)property.get()).equals(newValue)) {
                        numericEditor.setShowAllFractionDigits(false);
                        return;
                    }
                    property.set((Object)newValue);
                } else {
                    property.set(null);
                }
            }
            numericEditor.setShowAllFractionDigits((boolean)nv);
        });
        numericEditor.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                Number value = numericEditor.getValue();
                if (value != null) {
                    property.set((Object)value.doubleValue());
                } else {
                    property.set(null);
                }
                numericEditor.formatText();
            }
        });
        property.addListener(o -> numericEditor.setValue((Number)property.get()));
        return numericEditor;
    }

    public Number parseCompleteString(String input) {
        input = input.replace('e', 'E');
        ParsePosition pp = new ParsePosition(0);
        Number result = this.format.parse(input, pp);
        if (pp.getIndex() == input.length()) {
            return result;
        }
        throw new NumberFormatException();
    }

    private Number castNumber(Number value) {
        if (this.cls == Byte.TYPE || this.cls == Byte.class) {
            return value.byteValue();
        }
        if (this.cls == Short.TYPE || this.cls == Short.class) {
            return value.shortValue();
        }
        if (this.cls == Integer.TYPE || this.cls == Integer.class) {
            return value.intValue();
        }
        if (this.cls == Long.TYPE || this.cls == Long.class || this.cls == BigInteger.class) {
            return value.longValue();
        }
        if (this.cls == Float.TYPE || this.cls == Float.class) {
            return Float.valueOf(value.floatValue());
        }
        if (this.cls == Double.TYPE || this.cls == Double.class) {
            return value.doubleValue();
        }
        throw new NumberFormatException();
    }

    private class DoubleValidator
    extends SimpleObjectProperty<Number>
    implements NumericValidator {
        private boolean nullable;

        public DoubleValidator(NumericField field, boolean nullable) {
            super((Object)field, "value");
            this.nullable = nullable;
        }

        @Override
        public Number toNumber(String s) {
            if (s == null || s.trim().isEmpty()) {
                if (this.nullable) {
                    return null;
                }
                return 0;
            }
            String d = s.trim();
            if (d.endsWith("\u00a0")) {
                d = d.substring(0, d.length() - 1);
            }
            if (d.endsWith("f") || d.endsWith("d") || d.endsWith("F") || d.endsWith("D")) {
                throw new NumberFormatException("There should be no alpha symbols");
            }
            if (d.endsWith(".")) {
                d = d.substring(0, d.length() - 1);
            }
            if (NumericField.this.format == null) {
                return new Double(d);
            }
            Number dval = NumericField.this.parseCompleteString(d);
            return NumericField.this.castNumber(dval);
        }
    }

    private class LongValidator
    extends SimpleObjectProperty<Number>
    implements NumericValidator {
        private boolean nullable;

        public LongValidator(NumericField field, boolean nullable) {
            super((Object)field, "value");
            this.nullable = nullable;
        }

        @Override
        public Number toNumber(String s) {
            if (s == null || s.trim().isEmpty()) {
                if (this.nullable) {
                    return null;
                }
                return 0;
            }
            String d = s.trim();
            if (d.endsWith("\u00a0")) {
                d = d.substring(0, d.length() - 1);
            }
            if (NumericField.this.format == null) {
                return new Long(d);
            }
            Number dval = NumericField.this.parseCompleteString(d);
            return NumericField.this.castNumber(dval);
        }
    }

    private static interface NumericValidator
    extends ObservableValue<Number> {
        public void setValue(Number var1);

        public Number toNumber(String var1);
    }

    public static enum SuffixOrientation {
        ValueFloating,
        Right;

    }
}

