/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.controls.skins;

import de.elpro.ui.fx.controls.TimespanPicker;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class TimespanPickerSkin
extends SkinBase<TimespanPicker> {
    private Collection<TimestampRect> rectangles = new LinkedList<TimestampRect>();
    private final HBox pane = new HBox(2.0){

        public boolean isResizable() {
            return true;
        }

        public void resize(double width, double height) {
            super.setWidth(width);
            super.setHeight(height);
            double ratio = width / (double)TimespanPickerSkin.this.rectangles.stream().mapToLong(tr -> tr.millis).sum();
            TimespanPickerSkin.this.rectangles.stream().forEach(tr -> tr.setPrefWidth(ratio * (double)tr.millis));
        }
    };

    public TimespanPickerSkin(TimespanPicker control) {
        super((Control)control);
        control.getTimespans().addListener(il -> this.rebuildTimestampRectangles());
        control.fromProperty().addListener(il -> this.rebuildTimestampRectangles());
        control.toProperty().addListener(il -> this.rebuildTimestampRectangles());
        this.rebuildTimestampRectangles();
        this.getChildren().add((Object)this.pane);
    }

    public void rebuildTimestampRectangles() {
        this.rectangles.clear();
        Long drawFrom = ((TimespanPicker)this.getSkinnable()).getFrom() != null ? Long.valueOf(((TimespanPicker)this.getSkinnable()).getFrom().toInstant().toEpochMilli()) : null;
        Long drawTo = ((TimespanPicker)this.getSkinnable()).getTo() != null ? Long.valueOf(((TimespanPicker)this.getSkinnable()).getTo().toInstant().toEpochMilli()) : null;
        List sortedTimespans = ((TimespanPicker)this.getSkinnable()).getTimespans().stream().sorted((t1, t2) -> t1.getFrom().compareTo(t2.getFrom())).collect(Collectors.toList());
        Long lastTo = null;
        for (TimespanPicker.Timespan ts : sortedTimespans) {
            boolean isLastIncomplete;
            long from = ts.getFrom().toInstant().toEpochMilli();
            long to = ts.getTo().toInstant().toEpochMilli();
            if (drawFrom != null && to <= drawFrom) continue;
            if (drawTo != null && from >= drawTo) break;
            boolean isFirstIncomplete = drawFrom != null && from < drawFrom;
            boolean bl = isLastIncomplete = drawTo != null && drawTo < to;
            if (lastTo == null) {
                if (drawFrom != null && from < drawFrom) {
                    this.rectangles.add(new TimestampRect(from - drawFrom, true, false, ((TimespanPicker)this.getSkinnable()).getColorGenerator().getEmptyColor(), null, true));
                }
                lastTo = isFirstIncomplete ? drawFrom : from;
            } else if (lastTo < from) {
                this.rectangles.add(new TimestampRect(from - lastTo, false, false, ((TimespanPicker)this.getSkinnable()).getColorGenerator().getEmptyColor(), null, true));
                lastTo = from;
            }
            this.rectangles.add(new TimestampRect(to - lastTo, isFirstIncomplete, isLastIncomplete, ((TimespanPicker)this.getSkinnable()).getColorGenerator().getNextColor(ts), ts, false));
            lastTo = to;
        }
        this.pane.getChildren().setAll(this.rectangles);
    }

    private class TimestampRect
    extends BorderPane {
        final long millis;
        final boolean beginOpen;
        final boolean endOpen;
        final Background background;
        final Background hoverBackground;
        Label label;

        public TimestampRect(long millis, boolean beginOpen, boolean endOpen, Color fill, TimespanPicker.Timespan timespan, boolean empty) {
            this.millis = millis;
            this.beginOpen = beginOpen;
            this.endOpen = endOpen;
            BorderPane innerPart = new BorderPane();
            BackgroundFill[] backgroundFils = new BackgroundFill[]{new BackgroundFill((Paint)(empty ? Color.WHITE : fill), CornerRadii.EMPTY, new Insets(0.0))};
            BackgroundImage[] backgroundImages = new BackgroundImage[]{new BackgroundImage(new Image(((Object)((Object)this)).getClass().getResource("empty_timespan.png").toString()), BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT)};
            this.background = new Background(backgroundFils, (BackgroundImage[])(empty ? backgroundImages : null));
            this.hoverBackground = new Background(new BackgroundFill[]{new BackgroundFill((Paint)fill.deriveColor(1.0, 1.0, 0.9, 1.0), CornerRadii.EMPTY, new Insets(0.0))});
            if (timespan != null && timespan.getName() != null) {
                this.label = new Label(timespan.getName());
                this.label.setStyle("-fx-text-fill: white; -fx-font-weight: bold;");
                innerPart.setCenter((Node)this.label);
            }
            if (timespan != null) {
                this.setCursor(Cursor.HAND);
                innerPart.setOnMouseEntered(e -> innerPart.setBackground(this.hoverBackground));
                innerPart.setOnMouseExited(e -> innerPart.setBackground(this.background));
                innerPart.setBackground(this.background);
                this.setOnMouseClicked(e -> {
                    if (e.getButton() == MouseButton.PRIMARY && ((TimespanPicker)TimespanPickerSkin.this.getSkinnable()).getOnTimespanClicked() != null) {
                        ((TimespanPicker)TimespanPickerSkin.this.getSkinnable()).getOnTimespanClicked().accept(timespan);
                    }
                });
            }
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)fill.darker(), CornerRadii.EMPTY, new Insets(0.0))}));
            innerPart.setBackground(this.background);
            BorderPane.setMargin((Node)innerPart, (Insets)new Insets(2.0));
            this.setCenter((Node)innerPart);
        }
    }
}

