/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.dialogs;

import de.elpro.ui.fx.controls.CustomColorPicker;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class ColorPickerDialog
extends Dialog<Color> {
    private CustomColorPicker customColorPicker = new CustomColorPicker();
    private TextField color = new TextField();

    public ColorPickerDialog(Window window, Color currentColor) {
        this.customColorPicker.setCurrentColor(currentColor != null ? currentColor : Color.BLACK);
        this.initOwner(window);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        VBox.setVgrow((Node)this.customColorPicker, (Priority)Priority.ALWAYS);
        this.getDialogPane().setContent((Node)new VBox(new Node[]{this.customColorPicker, this.color}));
        this.color.textProperty().bindBidirectional(this.customColorPicker.customColorProperty(), (StringConverter)new StringConverter<Color>(){

            public String toString(Color object) {
                if (object == null) {
                    return null;
                }
                return object.toString();
            }

            public Color fromString(String string) {
                if (string == null) {
                    return null;
                }
                try {
                    return (Color)Paint.valueOf((String)string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        this.setResultConverter(bt -> {
            if (bt == ButtonType.OK) {
                return this.customColorPicker.getCustomColor();
            }
            return currentColor;
        });
    }
}

