/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.e4;

import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.e4.PersistenceJob;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.concurrent.Worker;

public class PersistenceWorker {
    private final ProgressIndicatorPane progressIndicator;
    private volatile boolean canPersist = true;

    public PersistenceWorker(ProgressIndicatorPane progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public void persist(final PersistenceJob onSave, Runnable onSuccess, Consumer<Exception> onError) {
        if (!this.canPersist) {
            return;
        }
        CallableTask<Exception> task = new CallableTask<Exception>(){

            public Exception call() throws Exception {
                PersistenceWorker.this.canPersist = false;
                try {
                    onSave.run();
                }
                catch (Exception exc) {
                    return exc;
                }
                return null;
            }
        };
        TaskUtils.executeUITask(this.progressIndicator, task).consumeResult((s, exc) -> {
            if (s == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    if (exc == null) {
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    } else if (onError != null) {
                        onError.accept((Exception)exc);
                    }
                });
            }
            this.canPersist = true;
        });
    }
}

