/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet;

import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.model.ComparableEnum;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.value.ObservableValue;

public class EnumPropertyItem<T extends Enum<?>>
extends ChoicePropertyItem<T> {
    public EnumPropertyItem(String name, Class<T> clazz, ObservableValue<T> valueProperty) {
        this(null, name, clazz, valueProperty);
    }

    public EnumPropertyItem(String category, String name, Class<T> clazz, ObservableValue<T> valueProperty) {
        this(category, name, (String)null, clazz, valueProperty);
    }

    public EnumPropertyItem(String category, String name, String description, Class<T> clazz, ObservableValue<T> valueProperty) {
        super(category, name, description, valueProperty, EnumPropertyItem.getEnumConstants(clazz));
    }

    public static <T extends Enum<?>> Collection<T> getEnumConstants(Class<T> clazz) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        if (ComparableEnum.class.isAssignableFrom(clazz)) {
            ComparableEnum[] comparableConstants = (ComparableEnum[])constants;
            Arrays.sort(comparableConstants, ComparableEnum.COMPARATOR);
        }
        return Arrays.asList(constants);
    }
}

