/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet;

import de.elpro.ui.controlsfx.propertysheet.FetchTextCallback;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.propertysheet.editors.MultChoicesPropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.controlsfx.property.editor.PropertyEditor;

public class MultChoicesPropertyItem<T>
extends PropertyItem<Collection<T>> {
    private final SimpleObjectProperty<Collection<T>> choices = new SimpleObjectProperty();
    private FetchTextCallback<T> choiceTextCallback = null;

    public MultChoicesPropertyItem(String name, Collection<T> values, Collection<? extends T> choices) {
        this(null, name, values, choices);
    }

    public MultChoicesPropertyItem(String category, String name, Collection<T> values) {
        this(category, name, null, values, values);
    }

    public MultChoicesPropertyItem(String category, String name, String description, Collection<T> values) {
        this(category, name, description, values, values);
        this.setReadOnly(true);
    }

    public MultChoicesPropertyItem(String category, String name, Collection<T> values, Collection<? extends T> choices) {
        this(category, name, null, values, choices);
    }

    public MultChoicesPropertyItem(String category, String name, String description, Collection<T> values, Collection<? extends T> choices) {
        super(category, name, description, new MCObjectProperty<Collection<T>>(values));
        this.setChoises(choices);
    }

    public Collection<T> getChoices() {
        return (Collection)this.choices.get();
    }

    public void setChoises(Collection<? extends T> choices) {
        if (choices == null) {
            this.choices.set(new ArrayList());
        } else {
            this.choices.set(new ArrayList<T>(choices));
        }
    }

    public ObjectProperty<Collection<T>> choicesProperty() {
        return this.choices;
    }

    public void setValue(Object arg0) {
        if (arg0 instanceof Collection) {
            Collection newVals = (Collection)arg0;
            Collection oldVals = (Collection)this.valueProperty().getValue();
            oldVals.clear();
            for (Object newVal : newVals) {
                oldVals.add(newVal);
            }
            this.setHasChanges(true);
            ((MCObjectProperty)this.valueProperty()).fireValueChangedEvent();
        }
    }

    public Class<?> getType() {
        return null;
    }

    public Optional<Class<? extends PropertyEditor<?>>> getPropertyEditorClass() {
        return Optional.of(MultChoicesPropertyEditor.class);
    }

    public void setTextCallback(FetchTextCallback<T> callback) {
        this.choiceTextCallback = callback;
    }

    public String getValueText(Object o) {
        if (o == PropertyItem.NULL_OBJECT) {
            return null;
        }
        if (this.choiceTextCallback != null) {
            return this.choiceTextCallback.getText(o);
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private static final class MCObjectProperty<X>
    extends SimpleObjectProperty<X> {
        public MCObjectProperty(X initialValue) {
            super(initialValue);
        }

        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

