/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.fx.propertysheet.ByteArrayFromFilePropertyItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import org.apache.commons.io.IOUtils;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public class ByteArrayFromFilePropertyEditor
implements PropertyEditor<byte[]> {
    private final ByteArrayFromFilePropertyItem propertyItem;
    private final Node editor;
    private final TextField text;
    private File initialDirectory;
    private String initialFilename;

    public ByteArrayFromFilePropertyEditor(PropertySheet.Item item) {
        this.propertyItem = (ByteArrayFromFilePropertyItem)item;
        this.text = new TextField();
        this.text.setEditable(false);
        if (this.propertyItem.getValue() != null) {
            this.text.setText(this.propertyItem.getConverter().toString((Object)((byte[])item.getValue())));
        }
        HBox.setHgrow((Node)this.text, (Priority)Priority.ALWAYS);
        Button browseBtn = new Button("\u2026");
        browseBtn.disableProperty().bind((ObservableValue)this.propertyItem.readOnlyProperty());
        HBox box = new HBox(5.0, new Node[]{this.text, browseBtn});
        this.propertyItem.valueProperty().addListener((o, ov, nv) -> {
            this.setValue((byte[])nv);
            this.propertyItem.forceValidate();
        });
        this.initialDirectory = this.propertyItem.getInitialDirectory();
        this.initialFilename = this.propertyItem.getInitialFilename();
        browseBtn.setOnAction(event -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter[] extensionFilterArray = this.propertyItem.getExtensionFilters();
            int n = extensionFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileChooser.ExtensionFilter filter = extensionFilterArray[n2];
                fileChooser.getExtensionFilters().add((Object)filter);
                ++n2;
            }
            fileChooser.setInitialDirectory(this.initialDirectory);
            fileChooser.setInitialFileName(this.initialFilename);
            File file = fileChooser.showOpenDialog(browseBtn.getScene().getWindow());
            if (file != null) {
                try {
                    this.propertyItem.setValue(IOUtils.toByteArray((InputStream)new FileInputStream(file)));
                }
                catch (Exception exception) {}
            }
        });
        this.editor = box;
    }

    public Node getEditor() {
        return this.editor;
    }

    public byte[] getValue() {
        return null;
    }

    public void setValue(byte[] bytes) {
        this.text.setText(bytes != null ? this.propertyItem.getConverter().toString((Object)bytes) : null);
    }
}

