/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.formats.TimeFormatType;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class DatePickerPropertyEditor
extends AbstractPropertyEditor<LocalDate, DatePicker> {
    private static final StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){

        public String toString(LocalDate object) {
            if (object == null) {
                return null;
            }
            return TimeFormatType.Date.format((TemporalAccessor)object);
        }

        public LocalDate fromString(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            try {
                return LocalDate.parse(string, TimeFormatType.Date.getFormatter());
            }
            catch (Exception exception) {
                return null;
            }
        }
    };

    public DatePickerPropertyEditor(PropertySheet.Item property) {
        super(property, (Node)DatePickerPropertyEditor.createPicker());
        if (property instanceof PropertyItem) {
            PropertyItem propertyItem = (PropertyItem)property;
            ((DatePicker)this.getEditor()).setPromptText(propertyItem.getPromptText());
        }
    }

    protected ObservableValue<LocalDate> getObservableValue() {
        return ((DatePicker)this.getEditor()).valueProperty();
    }

    public void setValue(LocalDate value) {
        ((DatePicker)this.getEditor()).setValue((Object)value);
    }

    private static DatePicker createPicker() {
        DatePicker datePicker = new DatePicker();
        datePicker.setConverter(converter);
        return datePicker;
    }
}

