/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.fx.propertysheet.FileTextPropertyItem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.decoration.PredefinedDecorators;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class FileTextPropertyEditor
extends AbstractPropertyEditor<String, FileEditor> {
    public FileTextPropertyEditor(PropertySheet.Item item) {
        super(item, (Node)new FileEditor(), false);
        FileTextPropertyItem pageItem = (FileTextPropertyItem)item;
        FileEditor editor = (FileEditor)this.getEditor();
        ((FileEditor)this.getEditor()).browse.setOnAction(e -> {
            File file;
            FileChooser fileChooser = new FileChooser();
            if (pageItem.getExtensionFilters() != null) {
                for (FileChooser.ExtensionFilter filter : pageItem.getExtensionFilters()) {
                    fileChooser.getExtensionFilters().add((Object)filter);
                }
            }
            if ((file = fileChooser.showOpenDialog(fileEditor.browse.getScene().getWindow())) != null) {
                try {
                    Path path = Paths.get(file.getPath(), new String[0]);
                    byte[] bytes = Files.readAllBytes(path);
                    pageItem.setValue(new String(bytes, StandardCharsets.UTF_8));
                }
                catch (IOException iOException) {
                    pageItem.setValue(null);
                }
            }
        });
    }

    protected StringProperty getObservableValue() {
        return ((FileEditor)this.getEditor()).fileContent;
    }

    public void setValue(String value) {
        ((FileEditor)this.getEditor()).fileContent.set(value);
    }

    static class FileEditor
    extends HBox {
        private BooleanProperty _clearbuttonVisibleProperty;
        private Decorator<Button> _clearButtonDecorator;
        private final SimpleStringProperty fileContent = new SimpleStringProperty();
        private final TextField svgText = new TextField();
        private final Button browse = new Button("Browse ...");

        public BooleanProperty clearButtonVisibleProperty() {
            if (this._clearbuttonVisibleProperty == null) {
                this._clearbuttonVisibleProperty = new SimpleBooleanProperty((Object)this, "clearButtonVisible"){

                    protected void invalidated() {
                        super.invalidated();
                        if (this.get()) {
                            this.showClearButton();
                        } else {
                            this.hideClearButton();
                        }
                    }
                };
            }
            return this._clearbuttonVisibleProperty;
        }

        public boolean isClearButtonVisible() {
            return this.clearButtonVisibleProperty().get();
        }

        public void setClearButtonVisible(boolean clearButtonVisible) {
            this.clearButtonVisibleProperty().set(clearButtonVisible);
        }

        private void showClearButton() {
            if (this._clearButtonDecorator == null) {
                this._clearButtonDecorator = (Decorator)PredefinedDecorators.getInstance().getClearButtonDecoratorSupplier().get();
                ((Button)this._clearButtonDecorator.getNode()).disableProperty().bind((ObservableValue)this.disabledProperty());
                ((Button)this._clearButtonDecorator.getNode()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        if (!this.isDisabled()) {
                            svgText.setText(null);
                        }
                    }
                });
            }
            DecorationUtils.install((Node)this.svgText, this._clearButtonDecorator);
        }

        private void hideClearButton() {
            if (this._clearButtonDecorator != null) {
                DecorationUtils.uninstall((Node)this.svgText, this._clearButtonDecorator);
            }
        }

        public FileEditor() {
            super(5.0);
            this.svgText.setMaxWidth(Double.MAX_VALUE);
            this.svgText.setEditable(false);
            this.svgText.textProperty().bind((ObservableValue)this.fileContent);
            HBox.setHgrow((Node)this.svgText, (Priority)Priority.ALWAYS);
            this.showClearButton();
            this.getChildren().addAll((Object[])new Node[]{this.svgText, this.browse});
        }
    }
}

