/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.propertysheet.editors;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.formats.TimeFormatType;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.AbstractPropertyEditor;

public class LocalDatePropertyEditor
extends AbstractPropertyEditor<LocalDate, DatePicker> {
    private TimeFormatType format = TimeFormatType.Date;

    public LocalDatePropertyEditor(PropertySheet.Item property) {
        super(property, (Node)new DatePicker(), false);
        ((DatePicker)this.getEditor()).setConverter((StringConverter)new InternalConverter());
        if (property instanceof PropertyItem) {
            PropertyItem propertyItem = (PropertyItem)property;
            ((DatePicker)this.getEditor()).setPromptText(propertyItem.getPromptText());
            ((DatePicker)this.getEditor()).editableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)propertyItem.readOnlyProperty()));
        } else {
            ((DatePicker)this.getEditor()).setEditable(property.isEditable());
        }
    }

    protected ObservableValue<LocalDate> getObservableValue() {
        return ((DatePicker)this.getEditor()).valueProperty();
    }

    public void setValue(LocalDate value) {
        ((DatePicker)this.getEditor()).setValue((Object)value);
    }

    private class InternalConverter
    extends StringConverter<LocalDate> {
        private InternalConverter() {
        }

        public String toString(LocalDate object) {
            LocalDate value = (LocalDate)LocalDatePropertyEditor.this.getValue();
            return value != null ? LocalDatePropertyEditor.this.format.format((TemporalAccessor)value) : "";
        }

        public LocalDate fromString(String value) {
            if (value == null) {
                return null;
            }
            return LocalDate.parse(value, LocalDatePropertyEditor.this.format.getFormatter());
        }
    }
}

