/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumnBase;

public class ColumnsPersistedState
implements Serializable {
    private static final long serialVersionUID = -8251672861616291985L;
    private final LinkedHashMap<ColumnState, ColumnsPersistedState> columns = new LinkedHashMap();

    public <T extends TableColumnBase<?, ?>> void persistColumns(ObservableList<T> columns) {
        for (TableColumnBase column : columns) {
            ColumnState state = new ColumnState();
            state.id = column.getId();
            state.width = column.getWidth();
            state.visible = column.isVisible();
            ColumnsPersistedState substate = null;
            if (!column.getColumns().isEmpty()) {
                substate = new ColumnsPersistedState();
                substate.persistColumns(column.getColumns());
            }
            this.columns.put(state, substate);
        }
    }

    public <T extends TableColumnBase<?, ?>> void restoreColumnsState(ObservableList<T> columns) {
        LinkedHashMap<String, ColumnState> cs = new LinkedHashMap<String, ColumnState>();
        final LinkedList<String> ids = new LinkedList<String>();
        for (ColumnState state : this.columns.keySet()) {
            cs.put(state.id, state);
            ids.add(state.id);
        }
        columns.sort(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (ids.contains(o1.getId()) && ids.contains(o2.getId())) {
                    return Integer.compare(ids.indexOf(o1.getId()), ids.indexOf(o2.getId()));
                }
                return 0;
            }
        });
        for (TableColumnBase column : columns) {
            ColumnState state = (ColumnState)cs.get(column.getId());
            if (state == null) continue;
            ColumnsPersistedState cps = this.columns.get(state);
            if (cps != null && !column.getColumns().isEmpty()) {
                cps.restoreColumnsState(column.getColumns());
            }
            column.setPrefWidth(state.width);
            column.setVisible(state.visible);
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] binary = baos.toByteArray();
        String text = Base64.getEncoder().encodeToString(binary);
        return text;
    }

    public static ColumnsPersistedState parse(String str) {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(str));
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            ois.close();
            bais.close();
            return (ColumnsPersistedState)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class ColumnState
    implements Serializable {
        private static final long serialVersionUID = 6779301656338195420L;
        String id;
        double width;
        boolean visible = true;

        private ColumnState() {
        }
    }
}

