/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.utils;

import java.util.Comparator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumnBase;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class FXUtilsColumnPersister {
    private static final String DEFAULT_WIDTH = "defaultWight";
    private static final String VISIBILITY = "visible";
    private static final String ORDER = "order";

    public static <T extends TableColumnBase<?, ?>> void persistColumnsState(String persisterKey, ObservableList<T> rootColumns) throws BackingStoreException {
        FXUtilsColumnPersister.persistColumnRecurcive(persisterKey, null, rootColumns);
    }

    private static <T extends TableColumnBase<?, ?>> void persistColumnRecurcive(String persisterKey, String rootColumnId, ObservableList<T> rootColumns) throws BackingStoreException {
        String columnOrder = "";
        for (TableColumnBase column : rootColumns) {
            columnOrder = String.valueOf(columnOrder) + column.getId() + "#";
            if (!column.getColumns().isEmpty()) {
                FXUtilsColumnPersister.persistColumnRecurcive(persisterKey, column.getId(), column.getColumns());
            }
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("ColumnPersistedState#" + persisterKey + "#" + column.getId());
            preferences.putDouble(DEFAULT_WIDTH, column.getWidth());
            preferences.putBoolean(VISIBILITY, column.isVisible());
            preferences.flush();
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("ColumnOrderPersistedState#" + (rootColumnId != null ? String.valueOf(rootColumnId) + "#" : "") + persisterKey);
        preferences.put(ORDER, columnOrder);
        preferences.flush();
    }

    public static <T extends TableColumnBase<?, ?>> void loadColumnsState(String persisterKey, ObservableList<T> rootColumns) {
        FXUtilsColumnPersister.loadColumnRecurcive(persisterKey, null, rootColumns);
    }

    private static <T extends TableColumnBase<?, ?>> void loadColumnRecurcive(String persisterKey, String rootColumnId, ObservableList<T> rootColumns) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("ColumnOrderPersistedState#" + (rootColumnId != null ? String.valueOf(rootColumnId) + "#" : "") + persisterKey);
        final String columnOrder = preferences.get(ORDER, null);
        if (columnOrder != null) {
            FXCollections.sort(rootColumns, (Comparator)new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return Integer.compare(columnOrder.indexOf(String.valueOf(o1.getId()) + "#"), columnOrder.indexOf(String.valueOf(o2.getId()) + "#"));
                }
            });
        }
        for (TableColumnBase column : rootColumns) {
            if (!column.getColumns().isEmpty()) {
                FXUtilsColumnPersister.loadColumnRecurcive(persisterKey, column.getId(), column.getColumns());
            }
            preferences = InstanceScope.INSTANCE.getNode("ColumnPersistedState#" + persisterKey + "#" + column.getId());
            column.setPrefWidth(preferences.getDouble(DEFAULT_WIDTH, column.getPrefWidth()));
            column.setVisible(preferences.getBoolean(VISIBILITY, column.isVisible()));
        }
    }
}

