/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.fx.validator;

import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.Messages;
import javafx.event.EventType;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationObject;
import jidefx.scene.control.validation.Validator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public class Validators {
    public static final String DEFAULT_EMPTY_MESSAGE = Messages.validator_Validators_cannot_be_empty;
    public static final Validator OK = Validators.createValidator((o, ov, nv) -> true, null);
    public static final char[] BLANK_CHARACTERS = new char[]{' ', '\r', '\n'};

    public static Validator createNotEmptyValidator() {
        return Validators.createNotEmptyValidator(DEFAULT_EMPTY_MESSAGE);
    }

    public static Validator createNotEmptyValidator(String message) {
        return Validators.createNotEmptyValidator(message, (EventType<ValidationEvent>)ValidationEvent.VALIDATION_ERROR);
    }

    public static Validator createNotEmptyValidator(final String message, final EventType<ValidationEvent> severity) {
        return new Validator(){

            public ValidationEvent call(ValidationObject param) {
                String newStr;
                Object newValue = param.getNewValue();
                if (newValue == null || newValue == PropertyItem.NULL_OBJECT) {
                    return new ValidationEvent(severity, 0, message);
                }
                if (newValue instanceof String && (newStr = (String)newValue).isEmpty()) {
                    return new ValidationEvent(severity, 0, message);
                }
                return ValidationEvent.OK;
            }
        };
    }

    public static Validator createNoBlankCharacterValidator(String message) {
        return Validators.createNoBlankCharacterValidator(message, (EventType<ValidationEvent>)ValidationEvent.VALIDATION_ERROR);
    }

    public static Validator createNoBlankCharacterValidator(final String message, final EventType<ValidationEvent> severity) {
        return new Validator(){

            public ValidationEvent call(ValidationObject param) {
                Object newValue = param.getNewValue();
                if (newValue != null && newValue != PropertyItem.NULL_OBJECT && newValue instanceof String) {
                    String str = (String)newValue;
                    if (str.isEmpty()) {
                        return ValidationEvent.OK;
                    }
                    int i = 0;
                    while (i < BLANK_CHARACTERS.length) {
                        if (str.indexOf(BLANK_CHARACTERS[i]) >= 0) {
                            return new ValidationEvent(severity, 0, message);
                        }
                        ++i;
                    }
                }
                return ValidationEvent.OK;
            }
        };
    }

    public static Validator createIPv4Validator(final String message) {
        return new Validator(){
            private InetAddressValidator inetValidator = new InetAddressValidator();

            public ValidationEvent call(ValidationObject param) {
                String text = (String)param.getNewValue();
                if (text == null || text.isEmpty()) {
                    return ValidationEvent.OK;
                }
                if (!this.inetValidator.isValid(text)) {
                    return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, message);
                }
                return ValidationEvent.OK;
            }
        };
    }

    public static Validator createEmailValidator(String message) {
        return Validators.createEmailValidator(message, (EventType<ValidationEvent>)ValidationEvent.VALIDATION_ERROR);
    }

    public static Validator createEmailValidator(final String message, final EventType<ValidationEvent> severity) {
        return new Validator(){
            private EmailValidator emailValidator = EmailValidator.getInstance();

            public ValidationEvent call(ValidationObject param) {
                String text = (String)param.getNewValue();
                if (text == null || text.isEmpty()) {
                    return ValidationEvent.OK;
                }
                if (!this.emailValidator.isValid(text)) {
                    return new ValidationEvent(severity, 0, message);
                }
                return ValidationEvent.OK;
            }
        };
    }

    public static Validator combine(final Validator ... validators) {
        return new Validator(){

            public ValidationEvent call(ValidationObject param) {
                Validator[] validatorArray = validators;
                int n = validators.length;
                int n2 = 0;
                while (n2 < n) {
                    Validator validator = validatorArray[n2];
                    ValidationEvent validationEvent = (ValidationEvent)validator.call((Object)param);
                    if (validationEvent != ValidationEvent.OK) {
                        return validationEvent;
                    }
                    ++n2;
                }
                return ValidationEvent.OK;
            }
        };
    }

    public static <T> Validator createValidator(ValidatorPredicate<T> predicate, String message) {
        return Validators.createValidator(predicate, (EventType<ValidationEvent>)ValidationEvent.VALIDATION_ERROR, message);
    }

    public static <T> Validator createValidator(final ValidatorPredicate<T> predicate, final EventType<ValidationEvent> severity, final String message) {
        return new Validator(){

            public ValidationEvent call(ValidationObject param) {
                Object oldValue = param.getOldValue() == PropertyItem.NULL_OBJECT ? null : param.getOldValue();
                Object newValue = param.getNewValue() == PropertyItem.NULL_OBJECT ? null : param.getNewValue();
                boolean isValid = predicate.validate(param.getSource(), oldValue, newValue);
                return isValid ? ValidationEvent.OK : new ValidationEvent(severity, 0, message);
            }
        };
    }

    public static interface ValidatorPredicate<T> {
        public boolean validate(Object var1, T var2, T var3);
    }
}

