/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.handlers.toolbar;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class CloseAllSavedHandler {
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;

    @CanExecute
    public boolean canExecute(EPartService partService, MApplication app) {
        List partStacks = this.modelService.findElements((MApplicationElement)app, MPartStack.class, 10, e -> e.getTags().contains("editors"));
        for (MPartStack partStack : partStacks) {
            for (MStackElement element : partStack.getChildren()) {
                MPart part;
                if (!(element instanceof MPart) || (part = (MPart)element).isDirty() || !part.isCloseable()) continue;
                return true;
            }
        }
        return false;
    }

    @Execute
    public void execute(EPartService partService, EModelService modelService, MApplication app) {
        List partStacks = modelService.findElements((MApplicationElement)app, MPartStack.class, 10, e -> e.getTags().contains("editors"));
        for (MPartStack partStack : partStacks) {
            LinkedList<MPart> partsToClose = new LinkedList<MPart>();
            for (MStackElement element : partStack.getChildren()) {
                MPart part;
                if (!(element instanceof MPart) || (part = (MPart)element).isDirty() || !part.isCloseable()) continue;
                partsToClose.add(part);
            }
            for (MPart part : partsToClose) {
                partService.hidePart(part, true);
            }
        }
    }
}

