/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class TextUtils {
    public static String getFirstLine(String text, int maxLengh) {
        if (text == null) {
            return null;
        }
        String firstLine = text.split("\r")[0].split("\n")[0];
        if (firstLine.length() > maxLengh) {
            firstLine = String.valueOf(firstLine.substring(0, Math.min(firstLine.length(), maxLengh) - 1)) + "\u2026";
        }
        return firstLine;
    }

    public static <T> String concatItems(Collection<T> items, String separator, Function<T, String> converter) {
        return TextUtils.concatItems(items, separator, converter, Integer.MAX_VALUE);
    }

    public static <T> String concatItems(Collection<T> items, String separator, Function<T, String> converter, int maxItems) {
        String str = "";
        Iterator<T> iterator = items.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (++i > maxItems) {
                str = String.valueOf(str) + " \u2026";
                break;
            }
            T item = iterator.next();
            str = String.valueOf(str) + converter.apply(item);
            if (!iterator.hasNext()) continue;
            str = String.valueOf(str) + separator;
        }
        return str;
    }
}

