/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.utils.e4;

import de.elpro.ui.di.CanRefresh;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.di.internal.DiHelper;
import de.elpro.ui.model.UILabeledElement;
import de.elpro.ui.utils.e4.NamedContextValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PartUtils {
    public static final String CONTEXT_UNBOUND_TAG = "ContextUnbound";
    public static final String DEFAULT_TARGET_PARTSTACK_ID = "org.eclipse.e4.primaryDataStack";
    public static final String PINNED_PART_PROPERTY_KEY = "elpro.fx.part.pinned";

    public static MPart showPart(String partDescriptorId, MApplication app, Object ... contextObjects) {
        return PartUtils.showOrReplacePartWithNamedContext(DEFAULT_TARGET_PARTSTACK_ID, partDescriptorId, app, false, null, contextObjects);
    }

    public static MPart showPartWithNamedContext(String partDescriptorId, MApplication app, Object namedKey, Object contextObject) {
        return PartUtils.showOrReplacePartWithNamedContext(DEFAULT_TARGET_PARTSTACK_ID, partDescriptorId, app, false, new NamedContextValue<Object, Object>(namedKey, contextObject));
    }

    public static MPart showPart(String targetPartStackId, String partDescriptorId, MApplication app, Object ... contextObjects) {
        return PartUtils.showOrReplacePartWithNamedContext(targetPartStackId, partDescriptorId, app, false, null, contextObjects);
    }

    public static MPart showOrReplacePart(String targetPartStackId, String partDescriptorId, MApplication app, boolean replaceLastUndirty, Object ... contextObjects) {
        return PartUtils.showOrReplacePartWithNamedContext(targetPartStackId, partDescriptorId, app, replaceLastUndirty, null, contextObjects);
    }

    public static MPart showPartWithNamedContext(String targetPartStackId, String partDescriptorId, MApplication app, Object namedKey, Object contextObject) {
        return PartUtils.showOrReplacePartWithNamedContext(targetPartStackId, partDescriptorId, app, false, new Object[]{namedKey}, new Object[]{contextObject});
    }

    public static MPart showOrReplacePartWithNamedContext(String targetPartStackId, String partDescriptorId, MApplication app, boolean replaceLastUndirty, NamedContextValue<?, ?> ... namedContextValues) {
        Object[] namedKeys = new Object[namedContextValues.length];
        Object[] contextObjects = new Object[namedContextValues.length];
        int i = 0;
        while (i < namedContextValues.length) {
            namedKeys[i] = namedContextValues[i].getKey();
            contextObjects[i] = namedContextValues[i].getValue();
            ++i;
        }
        return PartUtils.showOrReplacePartWithNamedContext(targetPartStackId, partDescriptorId, app, replaceLastUndirty, namedKeys, contextObjects);
    }

    public static MPart showOrReplacePartWithNamedContext(String targetPartStackId, String partDescriptorId, MApplication app, boolean replaceUndirty, Object[] namedKeys, Object[] contextObjects) {
        IEclipseContext appContext = app.getContext();
        EModelService modelService = (EModelService)appContext.get(EModelService.class);
        EPartService partService = (EPartService)appContext.get(EPartService.class);
        MUIElement uiElement = modelService.find(targetPartStackId, (MUIElement)app);
        if (uiElement != null && uiElement instanceof MPartStack) {
            MPart oldPart;
            MPartStack partStack = (MPartStack)uiElement;
            if (!partStack.isVisible()) {
                partStack.setVisible(true);
            }
            if ((oldPart = PartUtils.findPartWithNamedContext(partDescriptorId, app, namedKeys, contextObjects)) != null) {
                partService.showPart(oldPart, EPartService.PartState.ACTIVATE);
                return oldPart;
            }
            MPart part = partService.createPart(partDescriptorId);
            if (part == null) {
                throw new IllegalArgumentException(String.format("Part Descriptor with id %s not found", partDescriptorId));
            }
            part.getTags().add("removeOnHide");
            Object contextObject = null;
            if (contextObjects.length > 0) {
                UILabeledElement labeledContextObject;
                contextObject = contextObjects[0];
                if (part.getLabel() == null || part.getLabel().isEmpty()) {
                    try {
                        part.setLabel(contextObject.toString());
                    }
                    catch (Exception exception) {}
                }
                if ((part.getIconURI() == null || part.getIconURI().isEmpty()) && contextObject instanceof UILabeledElement && (labeledContextObject = (UILabeledElement)contextObject).getIconUri() != null) {
                    part.setIconURI(labeledContextObject.getIconUri());
                }
            }
            PartUtils.putContextObjects(part, appContext, namedKeys, contextObjects);
            if (replaceUndirty) {
                partStack.getChildren().add(0, part);
            } else {
                partStack.getChildren().add(part);
            }
            partService.showPart(part, EPartService.PartState.ACTIVATE);
            if (replaceUndirty) {
                List<MStackElement> oldElements = partStack.getChildren().stream().filter(e -> e instanceof MPart && e != part && !((MPart)e).isDirty() && !Boolean.parseBoolean(e.getPersistedState().getOrDefault(PINNED_PART_PROPERTY_KEY, "false"))).collect(Collectors.toList());
                oldElements.forEach(p -> partService.hidePart((MPart)p, true));
            }
            return part;
        }
        return null;
    }

    public static MPart addPart(String targetPartStackId, String partDescriptorId, MApplication app, Object ... contextObjects) {
        return PartUtils.addPart(targetPartStackId, partDescriptorId, app, null, contextObjects);
    }

    public static MPart addPart(String targetPartStackId, String partDescriptorId, MApplication app, Object[] namedKeys, Object[] contextObjects) {
        IEclipseContext appContext = app.getContext();
        EModelService modelService = (EModelService)appContext.get(EModelService.class);
        EPartService partService = (EPartService)appContext.get(EPartService.class);
        MUIElement uiElement = modelService.find(targetPartStackId, (MUIElement)app);
        if (uiElement != null && uiElement instanceof MPartStack) {
            MPartStack partStack = (MPartStack)uiElement;
            MPart part = partService.createPart(partDescriptorId);
            if (part == null) {
                throw new IllegalArgumentException(String.format("Part Descriptor with id %s not found", partDescriptorId));
            }
            part.getTags().add("removeOnHide");
            Object contextObject = null;
            if (contextObjects.length > 0) {
                UILabeledElement labeledContextObject;
                contextObject = contextObjects[0];
                if (part.getLabel() == null || part.getLabel().isEmpty()) {
                    try {
                        part.setLabel(contextObject.toString());
                    }
                    catch (Exception exception) {}
                }
                if ((part.getIconURI() == null || part.getIconURI().isEmpty()) && contextObject instanceof UILabeledElement && (labeledContextObject = (UILabeledElement)contextObject).getIconUri() != null) {
                    part.setIconURI(labeledContextObject.getIconUri());
                }
            }
            PartUtils.putContextObjects(part, appContext, namedKeys, contextObjects);
            partStack.getChildren().add(part);
            return part;
        }
        return null;
    }

    private static void putContextObjects(final MPart part, IEclipseContext appContext, final Object[] namedKeys, final Object[] contextObjects) {
        if (contextObjects.length > 0) {
            final IEventBroker eventBroker = (IEventBroker)appContext.get(IEventBroker.class);
            eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", new EventHandler(){

                public void handleEvent(Event event) {
                    try {
                        IEclipseContext eclipseContext;
                        MPart contextPart;
                        Object origin = event.getProperty("ChangedElement");
                        Object context = event.getProperty("NewValue");
                        if (origin instanceof MHandlerContainer && "SET".equals(event.getProperty("EventType")) && context instanceof IEclipseContext && (contextPart = (MPart)(eclipseContext = (IEclipseContext)context).get(MPart.class)) == part) {
                            int i = 0;
                            while (i < contextObjects.length) {
                                Object contextObject = contextObjects[i];
                                if (namedKeys != null) {
                                    Object namedKey = namedKeys[i];
                                    if (namedKey == null) {
                                        eclipseContext.set(contextObject.getClass().getName(), contextObject);
                                    } else if (namedKey instanceof Class) {
                                        eclipseContext.set(((Class)namedKey).getName(), contextObject);
                                    } else {
                                        eclipseContext.set(namedKey.toString(), contextObject);
                                    }
                                } else {
                                    eclipseContext.set(contextObject.getClass().getName(), contextObject);
                                }
                                ++i;
                            }
                            eventBroker.unsubscribe((EventHandler)this);
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        eventBroker.unsubscribe((EventHandler)this);
                    }
                }
            });
        }
    }

    public static MPart findPart(String partDescriptorId, MApplication app, Object ... contextObjects) {
        return PartUtils.findPartWithNamedContext(partDescriptorId, app, null, contextObjects);
    }

    public static MPart findPartWithNamedContext(String partDescriptorId, MApplication app, Object[] namedKeys, Object[] contextObjects) {
        IEclipseContext context = app.getContext();
        EModelService modelService = (EModelService)context.get(EModelService.class);
        for (MPart part : modelService.findElements((MUIElement)app, partDescriptorId, MPart.class, new LinkedList())) {
            if (part.getTags().contains(CONTEXT_UNBOUND_TAG) || part.getParent() == null || part.getContext() == null) continue;
            if (namedKeys == null && contextObjects.length == 0) {
                return part;
            }
            boolean contextMatches = true;
            int i = 0;
            while (i < contextObjects.length) {
                Object namedKey;
                Object contextObject = contextObjects[i];
                if (contextObject == null) {
                    return part;
                }
                Object object = namedKey = namedKeys != null ? namedKeys[i] : null;
                if (!PartUtils.checkContext(part.getContext(), namedKey, contextObject)) {
                    contextMatches = false;
                    break;
                }
                ++i;
            }
            if (!contextMatches) continue;
            return part;
        }
        return null;
    }

    public static MPart closePart(String partDescriptorId, MApplication app, Object ... contextObjects) {
        MPart part = PartUtils.findPartWithNamedContext(partDescriptorId, app, null, contextObjects);
        if (part != null && part.getParent() != null) {
            part.getParent().getChildren().remove(part);
        }
        return part;
    }

    private static boolean checkContext(IEclipseContext context, Object namedKey, Object contextObject) {
        if (namedKey instanceof Class && context.containsKey(((Class)namedKey).getName()) && context.get(((Class)namedKey).getName()).equals(contextObject)) {
            return true;
        }
        if (namedKey instanceof String && context.containsKey((String)namedKey) && context.get((String)namedKey).equals(contextObject)) {
            return true;
        }
        return context.containsKey(contextObject.getClass().getName()) && context.get(contextObject.getClass().getName()).equals(contextObject);
    }

    public static <T> void refreshParts(EPartService partService, T object) {
        for (MPart part : partService.getParts()) {
            try {
                PartUtils.refreshPart(part, object);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> void refreshPart(MPart part, T object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o = part.getObject();
        if (o == null) {
            return;
        }
        if (!PartUtils.canRefreshPart(part, object)) {
            return;
        }
        List<Method> methods = DiHelper.getAnnotatedMethod(o.getClass(), Refresh.class);
        for (Method method : methods) {
            Refresh annotation = method.getAnnotation(Refresh.class);
            if (object == null && method.getParameters().length == 0) {
                method.invoke(o, new Object[0]);
                continue;
            }
            if (Arrays.asList(annotation.refreshClasses()).contains(object)) {
                method.invoke(o, new Object[0]);
                continue;
            }
            if (object == null || method.getParameters().length != 1 || method.getParameters()[0].getType() != object.getClass()) continue;
            method.invoke(o, object);
        }
    }

    public static <T> void refreshPart(EPartService partService, String id) {
        MPart part = partService.findPart(id);
        if (part != null) {
            try {
                PartUtils.refreshPart(part, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> boolean canRefreshPart(MPart part, T object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (part == null) {
            return false;
        }
        Object o = part.getObject();
        if (o == null) {
            return false;
        }
        List<Method> refreshMethods = DiHelper.getAnnotatedMethod(o.getClass(), Refresh.class);
        for (Method refreshMethod : refreshMethods) {
            List<Method> methods;
            if (refreshMethod.getParameters().length == 0 && object == null) {
                methods = DiHelper.getAnnotatedMethod(o.getClass(), CanRefresh.class);
                if (methods.isEmpty()) {
                    return true;
                }
                for (Method method : methods) {
                    if (object != null || method.getParameters().length != 0 || !method.invoke(o, new Object[0]).equals(Boolean.TRUE)) continue;
                    return true;
                }
                continue;
            }
            if (refreshMethod.getParameters().length == 0 && object instanceof Class) {
                Refresh annotation = refreshMethod.getAnnotation(Refresh.class);
                if (!Arrays.asList(annotation.refreshClasses()).contains(object)) continue;
                return true;
            }
            if (refreshMethod.getParameters().length != 1 || object == null || refreshMethod.getParameters()[0].getType() != object.getClass()) continue;
            methods = DiHelper.getAnnotatedMethod(o.getClass(), CanRefresh.class);
            if (methods.isEmpty()) {
                return true;
            }
            for (Method method : methods) {
                if (method.getParameters().length != 1 || !method.invoke(o, object).equals(Boolean.TRUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static MMenuElement copyMenuElement(MMenuElement menuElement, EModelService modelService) {
        if (menuElement instanceof MDirectMenuItem) {
            MDirectMenuItem dme = (MDirectMenuItem)menuElement;
            MDirectMenuItem item = (MDirectMenuItem)modelService.createModelElement(MDirectMenuItem.class);
            item.setLabel(dme.getLabel());
            item.setIconURI(dme.getIconURI());
            item.setContributorURI(dme.getContributorURI());
            item.setContributionURI(dme.getContributionURI());
            return item;
        }
        if (menuElement instanceof MMenu) {
            MMenu mm = (MMenu)menuElement;
            MMenu item = (MMenu)modelService.createModelElement(MMenu.class);
            item.setLabel(mm.getLabel());
            item.setIconURI(mm.getIconURI());
            for (MMenuElement child : mm.getChildren()) {
                MMenuElement copy = PartUtils.copyMenuElement(child, modelService);
                if (copy == null) continue;
                item.getChildren().add(PartUtils.copyMenuElement(child, modelService));
            }
            return item;
        }
        if (menuElement instanceof MMenuSeparator) {
            return (MMenuElement)modelService.createModelElement(MMenuSeparator.class);
        }
        if (menuElement instanceof MHandledMenuItem) {
            MHandledMenuItem hmi = (MHandledMenuItem)menuElement;
            MHandledMenuItem item = (MHandledMenuItem)modelService.createModelElement(MHandledMenuItem.class);
            item.setLabel(hmi.getLabel());
            item.setIconURI(hmi.getIconURI());
            item.setContributorURI(hmi.getContributorURI());
            item.setCommand(hmi.getCommand());
            return item;
        }
        return null;
    }

    public static Object getContributionObject(IEclipseContext context, MContribution contribution) {
        Object rv = contribution.getObject();
        if (rv == null) {
            if (contribution.getContributionURI() == null) {
                return null;
            }
            IContributionFactory cf = (IContributionFactory)context.get(IContributionFactory.class.getName());
            rv = cf.create(contribution.getContributionURI(), context);
            contribution.setObject(rv);
        }
        return rv;
    }
}

