/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosButton;
import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.MacosToggleButtonBarSeparator;
import eu.hansolo.applefx.event.MacEvt;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

public class MacosAddRemoveButton
extends HBox
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private final MacEvt addEvt = new MacEvt(this, MacEvt.ADD);
    private final MacEvt removeEvt = new MacEvt(this, MacEvt.REMOVE);
    private Map<EvtType, List<EvtObserver<MacEvt>>> observers;
    private boolean _dark;
    private BooleanProperty dark;
    private Region plusIcon;
    private Region minusIcon;
    private MacosButton addButton;
    private MacosButton removeButton;

    public MacosAddRemoveButton() {
        this.init();
        this.registerListeners();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-add-remove-button");
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<MacEvt>>>();
        this._dark = Helper.isDarkMode();
        this.plusIcon = new Region();
        this.plusIcon.getStyleClass().setAll((Object[])new String[]{"macos-add-remove-button", "macos-plus-icon"});
        this.addButton = new MacosButton();
        this.addButton.setGraphic((Node)this.plusIcon);
        this.addButton.getStyleClass().addAll((Object[])new String[]{"macos-add-remove-button", "macos-add-button"});
        MacosToggleButtonBarSeparator separator = new MacosToggleButtonBarSeparator();
        this.minusIcon = new Region();
        this.minusIcon.getStyleClass().setAll((Object[])new String[]{"macos-add-remove-button", "macos-minus-icon"});
        this.removeButton = new MacosButton();
        this.removeButton.setGraphic((Node)this.minusIcon);
        this.removeButton.getStyleClass().addAll((Object[])new String[]{"macos-add-remove-button", "macos-remove-button"});
        this.setSpacing(0.0);
        this.getChildren().setAll((Object[])new Node[]{this.addButton, separator, this.removeButton});
    }

    private void registerListeners() {
        this.addButton.setOnAction(e -> this.fireMacEvt(this.addEvt));
        this.removeButton.setOnAction(e -> this.fireMacEvt(this.removeEvt));
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
            this.plusIcon.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
            this.addButton.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
            this.minusIcon.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
            this.removeButton.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosAddRemoveButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosAddRemoveButton.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public boolean isAddDisable() {
        return this.addButton.isDisable();
    }

    public void setAddDisable(boolean disable) {
        this.addButton.setDisable(disable);
    }

    public BooleanProperty addDisableProperty() {
        return this.addButton.disableProperty();
    }

    public boolean isRemoveDisable() {
        return this.removeButton.isDisable();
    }

    public void setRemoveDisable(boolean disable) {
        this.removeButton.setDisable(disable);
    }

    public BooleanProperty removeDisableProperty() {
        return this.removeButton.disableProperty();
    }

    public void addMacEvtObserver(EvtType type, EvtObserver<MacEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeMacEvtObserver(EvtType type, EvtObserver<MacEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllMacEvtObservers() {
        this.observers.clear();
    }

    public void fireMacEvt(MacEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MacEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(MacEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

