/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class MacosButton
extends Button
implements MacosControlWithAccentColor {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private static final PseudoClass DEFAULT_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"def");
    private boolean _dark;
    private BooleanProperty dark;
    private boolean _def;
    private BooleanProperty def;
    private MacosAccentColor _accentColor;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosButton() {
        this.init(false);
    }

    public MacosButton(String text) {
        super(text);
        this.init(false);
    }

    public MacosButton(String text, boolean isDefault) {
        super(text);
        this.init(true);
    }

    public MacosButton(String text, Node graphic, boolean isDefault) {
        super(text, graphic);
        this.init(isDefault);
    }

    private void init(boolean isDefault) {
        this.getStyleClass().add((Object)"macos-button");
        this._dark = Helper.isDarkMode();
        this._def = isDefault;
        this._accentColor = Helper.getMacosAccentColor();
        this.pseudoClassStateChanged(DEFAULT_PSEUDO_CLASS, isDefault);
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosButton.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public final boolean isDefault() {
        return this.def == null ? this._def : this.def.get();
    }

    public final void setDefault(boolean def) {
        if (this.def == null) {
            this._def = def;
            this.pseudoClassStateChanged(DEFAULT_PSEUDO_CLASS, def);
        } else {
            this.def.set(def);
        }
    }

    public final BooleanProperty defaultProperty() {
        if (this.def == null) {
            this.def = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosButton.this.pseudoClassStateChanged(DEFAULT_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosButton.this;
                }

                public String getName() {
                    return "default";
                }
            };
        }
        return this.def;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return this.accentColor == null ? this._accentColor : (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        if (this.accentColor == null) {
            this._accentColor = accentColor;
            Platform.runLater(() -> this.setStyle(this.isDark() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" : "-accent-color: " + accentColor.getAquaStyleClass() + ";"));
        } else {
            this.accentColor.set((Object)accentColor);
        }
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        if (this.accentColor == null) {
            this.accentColor = new ObjectPropertyBase<MacosAccentColor>(this._accentColor){

                protected void invalidated() {
                    Platform.runLater(() -> MacosButton.this.setStyle(MacosButton.this.isDark() ? "-accent-color-dark: " + ((MacosAccentColor)((Object)((Object)this.get()))).getDarkStyleClass() + ";" : "-accent-color: " + ((MacosAccentColor)((Object)((Object)this.get()))).getAquaStyleClass() + ";"));
                }

                public Object getBean() {
                    return MacosButton.this;
                }

                public String getName() {
                    return "accentColor";
                }
            };
            this._accentColor = null;
        }
        return this.accentColor;
    }

    public String getUserAgentStylesheet() {
        return MacosButton.class.getResource("apple.css").toExternalForm();
    }
}

