/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosCheckBoxSwitchSkin;
import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.MacosRadioButton;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import eu.hansolo.applefx.tools.MacosSystemColor;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class MacosCheckBoxSwitch
extends CheckBox
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private static final PseudoClass WINDOW_FOCUS_LOST_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"window-focus-lost");
    private static final StyleablePropertyFactory<MacosCheckBoxSwitch> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private BooleanBinding showing;
    private StyleableProperty<Color> bkgColor;
    private BooleanProperty dark;
    private BooleanProperty windowFocusLost;
    private ObjectProperty<MacosAccentColor> accentColor;
    private BooleanProperty showDescriptions;

    public MacosCheckBoxSwitch() {
        this(Helper.getMacosAccentColor(), Helper.isDarkMode());
    }

    public MacosCheckBoxSwitch(String text) {
        this(Helper.getMacosAccentColor(), Helper.isDarkMode(), text);
    }

    public MacosCheckBoxSwitch(MacosAccentColor accentColor) {
        this(accentColor, Helper.isDarkMode());
    }

    public MacosCheckBoxSwitch(boolean darkMode) {
        this(Helper.getMacosAccentColor(), darkMode);
    }

    public MacosCheckBoxSwitch(MacosAccentColor accentColor, boolean darkMode) {
        this(accentColor, darkMode, "");
    }

    public MacosCheckBoxSwitch(MacosAccentColor accentColor, boolean darkMode, String text) {
        this.init(accentColor, darkMode);
    }

    private void init(final MacosAccentColor accentColor, boolean darkMode) {
        this.getStyleClass().setAll((Object[])new String[]{"macos-checkbox-switch"});
        this.dark = new BooleanPropertyBase(darkMode){

            protected void invalidated() {
                MacosCheckBoxSwitch.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                if (MacosCheckBoxSwitch.this.isSelected()) {
                    if (MacosCheckBoxSwitch.this.getWindowFocusLost()) {
                        MacosCheckBoxSwitch.this.setBkgColor(this.get() ? Color.rgb((int)106, (int)105, (int)104) : Color.rgb((int)179, (int)179, (int)179));
                    } else {
                        MacosCheckBoxSwitch.this.setStyle(this.get() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" : "-accent-color: " + accentColor.getAquaStyleClass() + ";");
                    }
                } else {
                    MacosCheckBoxSwitch.this.setBkgColor(this.get() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua());
                }
            }

            public Object getBean() {
                return MacosCheckBoxSwitch.this;
            }

            public String getName() {
                return "dark";
            }
        };
        this.windowFocusLost = new BooleanPropertyBase(false){

            protected void invalidated() {
                MacosCheckBoxSwitch.this.pseudoClassStateChanged(WINDOW_FOCUS_LOST_PSEUDO_CLASS, this.get());
                if (MacosCheckBoxSwitch.this.isSelected()) {
                    if (MacosCheckBoxSwitch.this.isDark()) {
                        MacosCheckBoxSwitch.this.setBkgColor(this.get() ? Color.rgb((int)106, (int)105, (int)104) : MacosCheckBoxSwitch.this.getAccentColor().getColorDark());
                    } else {
                        MacosCheckBoxSwitch.this.setBkgColor(this.get() ? Color.rgb((int)179, (int)179, (int)179) : MacosCheckBoxSwitch.this.getAccentColor().getColorAqua());
                    }
                }
            }

            public Object getBean() {
                return MacosCheckBoxSwitch.this;
            }

            public String getName() {
                return "windowFocusLost";
            }
        };
        this.accentColor = new ObjectPropertyBase<MacosAccentColor>(accentColor){

            protected void invalidated() {
                MacosCheckBoxSwitch.this.setStyle(MacosCheckBoxSwitch.this.isDark() ? "-accent-color: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() + ";" : "-accent-color: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass() + ";");
            }

            public Object getBean() {
                return MacosCheckBoxSwitch.this;
            }

            public String getName() {
                return "accentColor";
            }
        };
        this.bkgColor = FACTORY.createStyleableColorProperty((Styleable)this, "bkgColor", "-bkg-color", s -> s.bkgColor, Color.rgb((int)215, (int)213, (int)213));
        this.showDescriptions = new BooleanPropertyBase(false){

            public Object getBean() {
                return MacosCheckBoxSwitch.this;
            }

            public String getName() {
                return "showDescriptions";
            }
        };
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, darkMode);
        this.setStyle(this.isDark() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" : "-accent-color: " + accentColor.getAquaStyleClass() + ";");
        this.registerListeners();
    }

    private void registerListeners() {
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get() && this.isSelected()) {
                this.setBkgColor(this.isDark() ? this.getAccentColor().getColorDark() : this.getAccentColor().getColorAqua());
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public final BooleanProperty darkProperty() {
        return this.dark;
    }

    public boolean getWindowFocusLost() {
        return this.windowFocusLost.get();
    }

    public void setWindowFocusLost(boolean windowFocusLost) {
        this.windowFocusLost.set(windowFocusLost);
    }

    public BooleanProperty windowFocusLostProperty() {
        return this.windowFocusLost;
    }

    public MacosAccentColor getAccentColor() {
        return (MacosAccentColor)((Object)this.accentColor.get());
    }

    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.set((Object)accentColor);
    }

    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        return this.accentColor;
    }

    public boolean getShowDescriptions() {
        return this.showDescriptions.get();
    }

    public void setShowDescriptions(boolean showDescriptions) {
        this.showDescriptions.set(showDescriptions);
    }

    public BooleanProperty showDescriptionsProperty() {
        return this.showDescriptions;
    }

    protected Color getBkgColor() {
        return (Color)this.bkgColor.getValue();
    }

    protected void setBkgColor(Color bkgColor) {
        this.bkgColor.setValue((Object)bkgColor);
    }

    protected StyleableObjectProperty<Color> bkgColorProperty() {
        return (StyleableObjectProperty)this.bkgColor;
    }

    protected Skin<?> createDefaultSkin() {
        return new MacosCheckBoxSwitchSkin(this);
    }

    public String getUserAgentStylesheet() {
        return MacosRadioButton.class.getResource("apple.css").toExternalForm();
    }
}

