/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosComboBox;
import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class MacosComboBoxCell<T>
extends ListCell<T>
implements MacosControlWithAccentColor {
    private static final ImageView EMPTY_CHECK_MARK = new ImageView(new Image(MacosComboBoxCell.class.getResourceAsStream("macos-checkmark-empty.png"), 10.0, 10.0, true, false));
    private static final ImageView BLACK_CHECK_MARK = new ImageView(new Image(MacosComboBoxCell.class.getResourceAsStream("macos-checkmark-black.png"), 10.0, 10.0, true, false));
    private static final ImageView WHITE_CHECK_MARK = new ImageView(new Image(MacosComboBoxCell.class.getResourceAsStream("macos-checkmark-white.png"), 10.0, 10.0, true, false));
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private BooleanProperty dark;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosComboBoxCell(MacosComboBox<T> comboBox) {
        this.getStyleClass().add((Object)"macos-combo-box-cell");
        this.dark = new BooleanPropertyBase(Helper.isDarkMode()){

            protected void invalidated() {
                MacosComboBoxCell.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosComboBoxCell.this;
            }

            public String getName() {
                return "dark";
            }
        };
        this.accentColor = new ObjectPropertyBase<MacosAccentColor>(Helper.getMacosAccentColor()){

            protected void invalidated() {
                MacosComboBoxCell.this.setStyle(MacosComboBoxCell.this.isDark() ? "-accent-color-dark: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() + ";" : "-accent-color: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass() + ";");
            }

            public Object getBean() {
                return MacosComboBoxCell.this;
            }

            public String getName() {
                return "accentColor";
            }
        };
        this.setGraphicTextGap(5.0);
        this.setContentDisplay(ContentDisplay.LEFT);
        comboBox.darkProperty().addListener((o, ov, nv) -> this.dark.set(nv.booleanValue()));
        this.accentColor.bind(comboBox.accentColorProperty());
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, comboBox.isDark());
    }

    @Override
    public final boolean isDark() {
        return this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public final BooleanProperty darkProperty() {
        return this.dark;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.set((Object)accentColor);
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        return this.accentColor;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(item.toString());
            this.setGraphic((Node)(this.isSelected() ? (this.isDark() ? WHITE_CHECK_MARK : BLACK_CHECK_MARK) : EMPTY_CHECK_MARK));
        }
    }

    public String toString() {
        return this.getItem().toString();
    }

    public String getUserAgentStylesheet() {
        return MacosComboBoxCell.class.getResource("apple.css").toExternalForm();
    }
}

