/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class MacosLabel
extends Label
implements MacosControl {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;

    public MacosLabel() {
        this.init();
    }

    public MacosLabel(String text) {
        super(text);
        this.init();
    }

    public MacosLabel(String text, Node graphic) {
        super(text, graphic);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-label");
        this._dark = false;
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosLabel.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosLabel.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }
}

