/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.tools.Helper;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;

public class MacosProgress
extends Region
implements MacosControl {
    private static final double PREFERRED_WIDTH = 16.0;
    private static final double PREFERRED_HEIGHT = 16.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final StyleablePropertyFactory<MacosProgress> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private static final CssMetaData<MacosProgress, Color> PROGRESS_STROKE = FACTORY.createColorCssMetaData("-progress-stroke", s -> s.progressStroke, Color.rgb((int)119, (int)119, (int)119), false);
    private static final CssMetaData<MacosProgress, Color> PROGRESS_FILL = FACTORY.createColorCssMetaData("-progress-fill", s -> s.progressFill, Color.rgb((int)119, (int)119, (int)119), false);
    private static final Color[] PILL_COLORS = new Color[]{Color.rgb((int)0, (int)0, (int)0), Color.rgb((int)21, (int)21, (int)21), Color.rgb((int)42, (int)42, (int)42), Color.rgb((int)63, (int)63, (int)63), Color.rgb((int)84, (int)84, (int)84), Color.rgb((int)105, (int)105, (int)105), Color.rgb((int)126, (int)126, (int)126), Color.rgb((int)147, (int)147, (int)147), Color.rgb((int)168, (int)168, (int)168), Color.rgb((int)189, (int)189, (int)189), Color.rgb((int)210, (int)210, (int)210), Color.rgb((int)231, (int)231, (int)231), Color.rgb((int)252, (int)252, (int)252)};
    private static final Color[] PILL_COLORS_DARK = new Color[]{Color.rgb((int)252, (int)252, (int)252), Color.rgb((int)231, (int)231, (int)231), Color.rgb((int)210, (int)210, (int)210), Color.rgb((int)189, (int)189, (int)189), Color.rgb((int)168, (int)168, (int)168), Color.rgb((int)147, (int)147, (int)147), Color.rgb((int)126, (int)126, (int)126), Color.rgb((int)105, (int)105, (int)105), Color.rgb((int)84, (int)84, (int)84), Color.rgb((int)63, (int)63, (int)63), Color.rgb((int)42, (int)42, (int)42), Color.rgb((int)21, (int)21, (int)21), Color.rgb((int)0, (int)0, (int)0)};
    private boolean _dark = false;
    private BooleanProperty dark;
    private final StyleableProperty<Color> progressStroke = new StyleableObjectProperty<Color>((Color)PROGRESS_STROKE.getInitialValue((Styleable)this)){

        protected void invalidated() {
            MacosProgress.this.redraw();
        }

        public Object getBean() {
            return MacosProgress.this;
        }

        public String getName() {
            return "progressStroke";
        }

        public CssMetaData<? extends Styleable, Color> getCssMetaData() {
            return PROGRESS_STROKE;
        }
    };
    private final StyleableProperty<Color> progressFill = new StyleableObjectProperty<Color>((Color)PROGRESS_FILL.getInitialValue((Styleable)this)){

        protected void invalidated() {
            MacosProgress.this.redraw();
        }

        public Object getBean() {
            return MacosProgress.this;
        }

        public String getName() {
            return "progressFill";
        }

        public CssMetaData<? extends Styleable, Color> getCssMetaData() {
            return PROGRESS_FILL;
        }
    };
    private boolean _indeterminate = false;
    private BooleanProperty indeterminate;
    private String userAgentStyleSheet;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private double lineWidth;
    private double halfLineWidth;
    private double _progress;
    private DoubleProperty progress;
    private long lastTimerCall;
    private AnimationTimer timer;
    private int pillFillOffset;

    public MacosProgress() {
        this(0.0);
    }

    public MacosProgress(double progress) {
        this._progress = Helper.clamp(0.0, 1.0, progress);
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > MacosProgress.this.lastTimerCall + 66660000L) {
                    MacosProgress.this.redraw();
                    MacosProgress.this.lastTimerCall = now;
                }
            }
        };
        this.pillFillOffset = 0;
        this.lineWidth = 1.0;
        this.halfLineWidth = 0.5;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(16.0, 16.0);
            }
        }
        this.getStyleClass().add((Object)"macos-progress");
        this.canvas = new Canvas(16.0, 16.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double height) {
        return 5.0;
    }

    protected double computeMinHeight(double width) {
        return 5.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 1024.0;
    }

    protected double computeMaxHeight(double width) {
        return 1024.0;
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosProgress.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosProgress.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public Color getProgressStroke() {
        return (Color)this.progressStroke.getValue();
    }

    public void setProgressStroke(Color color) {
        this.progressStroke.setValue((Object)color);
    }

    public ObjectProperty<Color> progressStrokeProperty() {
        return (ObjectProperty)this.progressStroke;
    }

    public Color getProgressFill() {
        return (Color)this.progressFill.getValue();
    }

    public void setProgressFill(Color color) {
        this.progressFill.setValue((Object)color);
    }

    public ObjectProperty<Color> progressFillProperty() {
        return (ObjectProperty)this.progressFill;
    }

    public double getProgress() {
        return this.progress == null ? this._progress : this.progress.get();
    }

    public void setProgress(double progress) {
        if (this.progress == null) {
            this._progress = Helper.clamp(0.0, 1.0, progress);
            this.redraw();
        } else {
            this.progress.set(Helper.clamp(0.0, 1.0, progress));
        }
    }

    public DoubleProperty progressProperty() {
        if (this.progress == null) {
            this.progress = new DoublePropertyBase(this._progress){

                protected void invalidated() {
                    if (this.isBound()) {
                        if (this.get() > 1.0 || this.get() < 0.0) {
                            throw new IllegalArgumentException("Value cannot be smaller than 0 or larger than 1");
                        }
                    } else {
                        this.set(Helper.clamp(0.0, 1.0, this.get()));
                    }
                    MacosProgress.this.redraw();
                }

                public Object getBean() {
                    return MacosProgress.this;
                }

                public String getName() {
                    return "progress";
                }
            };
        }
        return this.progress;
    }

    public boolean isIndeterminate() {
        return this.indeterminate == null ? this._indeterminate : this.indeterminate.get();
    }

    public void setIndeterminate(boolean indeterminate) {
        if (indeterminate) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
        if (this.indeterminate == null) {
            this._indeterminate = indeterminate;
            this.redraw();
        } else {
            this.indeterminate.set(indeterminate);
        }
    }

    public BooleanProperty indeterminateProperty() {
        if (this.indeterminate == null) {
            this.indeterminate = new BooleanPropertyBase(this._indeterminate){

                protected void invalidated() {
                    MacosProgress.this.redraw();
                }

                public Object getBean() {
                    return MacosProgress.this;
                }

                public String getName() {
                    return "indeterminate";
                }
            };
        }
        return this.indeterminate;
    }

    public String getUserAgentStylesheet() {
        if (this.userAgentStyleSheet == null) {
            this.userAgentStyleSheet = MacosProgress.class.getResource("apple.css").toExternalForm();
        }
        return this.userAgentStyleSheet;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.lineWidth = Helper.clamp(1.0, 10.0, this.size * 0.0625);
            this.halfLineWidth = this.lineWidth * 0.5;
            if (!this.isIndeterminate()) {
                this.redraw();
            }
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.isIndeterminate()) {
            double pillWidth = this.size * 0.125;
            double pillHeight = this.size * 0.28125;
            this.ctx.save();
            int i = 0;
            while (i < 12) {
                int pillFillIndex = this.pillFillOffset + i;
                if (pillFillIndex > 11) {
                    pillFillIndex -= 11;
                }
                this.ctx.setFill((Paint)(this.isDark() ? PILL_COLORS_DARK[pillFillIndex] : PILL_COLORS[pillFillIndex]));
                this.ctx.fillRoundRect((this.size - pillWidth) * 0.5, 0.0, pillWidth, pillHeight, pillWidth, pillWidth);
                this.ctx.translate(this.size * 0.5, this.size * 0.5);
                this.ctx.rotate(-30.0);
                this.ctx.translate(-this.size * 0.5, -this.size * 0.5);
                ++i;
            }
            ++this.pillFillOffset;
            if (this.pillFillOffset > 11) {
                this.pillFillOffset = 0;
            }
            this.ctx.restore();
        } else {
            this.ctx.setFill((Paint)this.getProgressFill());
            this.ctx.setStroke((Paint)this.getProgressStroke());
            this.ctx.setLineWidth(this.lineWidth);
            this.ctx.strokeOval(this.halfLineWidth, this.halfLineWidth, this.size - this.lineWidth, this.size - this.lineWidth);
            this.ctx.fillArc(this.halfLineWidth, this.halfLineWidth, this.size - this.lineWidth, this.size - this.lineWidth, 90.0, -360.0 * this.getProgress(), ArcType.ROUND);
        }
    }
}

