/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.event.MacEvt;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import eu.hansolo.applefx.tools.MacosSystemColor;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

@DefaultProperty(value="children")
public class MacosSwitch
extends Region
implements MacosControl {
    public static final double MIN_DURATION = 10.0;
    public static final double MAX_DURATION = 500.0;
    public static final Color DEFAULT_ACCENT_COLOR = MacosAccentColor.BLUE.getColorAqua();
    private static final double MACOS_WIDTH = 38.0;
    private static final double MACOS_HEIGHT = 22.0;
    private static final double MACOS_KNOB_RADIUS = 10.0;
    private static final double MACOS_KNOB_INSET = 1.0;
    private static final double MACOS_KNOB_CENTER_Y = 11.0;
    private static final double IOS_WIDTH = 38.0;
    private static final double IOS_HEIGHT = 25.5;
    private static final double IOS_KNOB_RADIUS = 11.0;
    private static final double IOS_KNOB_INSET = 1.5;
    private static final double IOS_KNOB_CENTER_Y = 12.75;
    private double width = 38.0;
    private double height = 22.0;
    private double knobRadius = 10.0;
    private double knobInset = 1.0;
    private double knobCenterY = 11.0;
    private static final StyleablePropertyFactory<MacosSwitch> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private static final PseudoClass IOS_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"ios");
    private final MacEvt selectedEvt = new MacEvt(this, MacEvt.SELECTED);
    private final MacEvt deselectedEvt = new MacEvt(this, MacEvt.DESELECTED);
    private final StyleableProperty<Color> accentColor = FACTORY.createStyleableColorProperty((Styleable)this, "accentColor", "-accent-color", s -> s.accentColor, DEFAULT_ACCENT_COLOR);
    private Map<EvtType, List<EvtObserver<MacEvt>>> observers;
    private boolean _dark = Helper.isDarkMode();
    private BooleanProperty dark;
    private boolean _ios = false;
    private BooleanProperty ios;
    private BooleanProperty windowFocusLost = new BooleanPropertyBase(){

        protected void invalidated() {
            if (MacosSwitch.this.isSelected()) {
                if (MacosSwitch.this.isDark()) {
                    MacosSwitch.this.backgroundArea.setFill((Paint)(this.get() ? Color.rgb((int)106, (int)105, (int)104) : MacosSwitch.this.getAccentColor()));
                } else {
                    MacosSwitch.this.backgroundArea.setFill((Paint)(this.get() ? Color.rgb((int)179, (int)179, (int)179) : MacosSwitch.this.getAccentColor()));
                }
            }
        }

        public Object getBean() {
            return MacosSwitch.this;
        }

        public String getName() {
            return "windowFocusLost";
        }
    };
    private Rectangle backgroundArea;
    private Circle knob;
    private Circle zero;
    private Rectangle one;
    private Pane pane;
    private boolean _selected = false;
    private BooleanProperty selected;
    private double _duration = 250.0;
    private DoubleProperty duration;
    private boolean _showOnOffText = false;
    private BooleanProperty showOnOffText;
    private Timeline timeline;
    private BooleanBinding showing;
    private HashMap<String, Property> settings;
    private EventHandler<MouseEvent> clickedHandler;

    public MacosSwitch() {
        this(new HashMap<String, Property>());
    }

    public MacosSwitch(Map<String, Property> settings) {
        this.settings = new HashMap<String, Property>(settings);
        this.timeline = new Timeline();
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<MacEvt>>>();
        this.clickedHandler = e -> {
            this.setSelected(!this.isSelected());
            if (this.windowFocusLost.get()) {
                this.windowFocusLost.set(false);
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        this.setMinSize(this.width, this.height);
        this.setMaxSize(this.width, this.height);
        this.setPrefSize(this.width, this.height);
        this.getStyleClass().add((Object)"macos-switch");
        this.backgroundArea = new Rectangle(this.width, this.height);
        this.backgroundArea.setArcWidth(this.height);
        this.backgroundArea.setArcHeight(this.height);
        this.backgroundArea.getStyleClass().addAll((Object[])new String[]{"background-area"});
        if (this.isSelected()) {
            this.backgroundArea.setFill((Paint)this.getAccentColor());
        }
        this.one = new Rectangle(8.0, 8.0, 0.7, 6.0);
        this.one.getStyleClass().addAll((Object[])new String[]{"one"});
        this.one.setMouseTransparent(true);
        this.one.setVisible(false);
        this.zero = new Circle(30.0, 11.0, 3.0);
        this.zero.getStyleClass().addAll((Object[])new String[]{"zero"});
        this.zero.setMouseTransparent(true);
        this.zero.setVisible(false);
        this.knob = new Circle(this.knobRadius);
        this.knob.getStyleClass().addAll((Object[])new String[]{"knob"});
        this.knob.setMouseTransparent(true);
        this.knob.setCenterX(this.isSelected() ? this.width - this.knobRadius - this.knobInset : this.knobRadius + this.knobInset);
        this.knob.setCenterY(this.knobCenterY);
        this.pane = new Pane(new Node[]{this.backgroundArea, this.one, this.zero, this.knob});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.disabledProperty().addListener(o -> this.setOpacity(this.isDisabled() ? 0.5 : 1.0));
        this.backgroundArea.addEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedHandler);
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
        this.accentColorProperty().addListener(o -> {
            if (this.isSelected()) {
                if (this.isDark()) {
                    this.backgroundArea.setFill((Paint)(this.isWindowFocusLost() ? Color.rgb((int)106, (int)105, (int)104) : this.getAccentColor()));
                } else {
                    this.backgroundArea.setFill((Paint)(this.isWindowFocusLost() ? Color.rgb((int)179, (int)179, (int)179) : this.getAccentColor()));
                }
            }
        });
    }

    private void setupBinding() {
        this.showing = Bindings.selectBoolean((ObservableValue)this.sceneProperty(), (String[])new String[]{"window", "showing"});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.applySettings();
            }
        });
    }

    private void applySettings() {
        if (this.settings.isEmpty()) {
            return;
        }
        for (String key : this.settings.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.settings.get(key)).get();
                this.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.settings.get(key)).get();
                this.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.settings.get(key)).get();
                this.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                this.setPrefWidth(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                this.setPrefHeight(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                this.setMinWidth(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                this.setMinHeight(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                this.setMaxWidth(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                this.setMaxHeight(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                this.setScaleX(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                this.setScaleY(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                this.setLayoutX(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                this.setLayoutY(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                this.setTranslateX(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                this.setTranslateY(((DoubleProperty)this.settings.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                this.setPadding((Insets)((ObjectProperty)this.settings.get(key)).get());
                continue;
            }
            if ("selectedColor".equals(key)) {
                this.setAccentColor((Color)((ObjectProperty)this.settings.get(key)).get());
                continue;
            }
            if ("dark".equals(key)) {
                this.setDark(((BooleanProperty)this.settings.get(key)).get());
                continue;
            }
            if ("ios".equals(key)) {
                this.setIos(((BooleanProperty)this.settings.get(key)).get());
                continue;
            }
            if ("showOnOffText".equals(key)) {
                this.setShowOnOffText(((BooleanProperty)this.settings.get(key)).get());
                continue;
            }
            if (!"duration".equals(key)) continue;
            this.setDuration(((DoubleProperty)this.settings.get(key)).get());
        }
        if (this.settings.containsKey("selected")) {
            this.setSelected(((BooleanProperty)this.settings.get("selected")).get());
        }
        this.settings.clear();
        if (this.showing == null) {
            return;
        }
    }

    public void dispose() {
        this.backgroundArea.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.clickedHandler);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double height) {
        return this.width;
    }

    protected double computeMinHeight(double width) {
        return this.height;
    }

    protected double computePrefWidth(double height) {
        return this.width;
    }

    protected double computePrefHeight(double width) {
        return this.height;
    }

    protected double computeMaxWidth(double height) {
        return this.width;
    }

    protected double computeMaxHeight(double width) {
        return this.height;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public boolean isSelected() {
        return this.selected == null ? this._selected : this.selected.get();
    }

    public void setSelected(boolean selected) {
        if (this.selected == null) {
            this._selected = selected;
            if (this._selected) {
                this.fireMacEvt(selected ? this.selectedEvt : this.deselectedEvt);
                this.animateToSelected();
            } else {
                this.animateToDeselected();
            }
        } else {
            this.selected.set(selected);
        }
    }

    public BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(this._selected){

                protected void invalidated() {
                    MacosSwitch.this.fireMacEvt(this.get() ? MacosSwitch.this.selectedEvt : MacosSwitch.this.deselectedEvt);
                    if (this.get()) {
                        MacosSwitch.this.animateToSelected();
                    } else {
                        MacosSwitch.this.animateToDeselected();
                    }
                }

                public Object getBean() {
                    return MacosSwitch.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public Color getAccentColor() {
        return (Color)this.accentColor.getValue();
    }

    public void setAccentColor(Color color) {
        this.accentColor.setValue((Object)color);
    }

    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.setValue((Object)(this.isDark() ? accentColor.getColorDark() : accentColor.getColorAqua()));
    }

    public ObjectProperty<Color> accentColorProperty() {
        return (ObjectProperty)this.accentColor;
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
            this.backgroundArea.setFill((Paint)(dark ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()));
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosSwitch.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                    MacosSwitch.this.backgroundArea.setFill((Paint)(this.get() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()));
                }

                public Object getBean() {
                    return MacosSwitch.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    public final boolean isIos() {
        return this.ios == null ? this._ios : this.ios.get();
    }

    public final void setIos(boolean ios) {
        if (this.ios == null) {
            this._ios = ios;
            this.pseudoClassStateChanged(IOS_PSEUDO_CLASS, ios);
            if (ios) {
                this.width = 38.0;
                this.height = 25.5;
                this.knobRadius = 11.0;
                this.knobInset = 1.5;
                this.knobCenterY = 12.75;
                this.one.setX(7.0);
                this.one.setY(9.0);
                this.one.setWidth(0.7);
                this.one.setHeight(7.5);
                this.zero.setRadius(3.75);
                this.zero.setCenterX(31.0);
                this.zero.setCenterY(12.75);
            } else {
                this.width = 38.0;
                this.height = 22.0;
                this.knobRadius = 10.0;
                this.knobInset = 1.0;
                this.knobCenterY = 11.0;
                this.one.setX(8.0);
                this.one.setY(8.0);
                this.one.setWidth(0.7);
                this.one.setHeight(6.0);
                this.zero.setRadius(3.0);
                this.zero.setCenterX(30.0);
                this.zero.setCenterY(11.0);
            }
            this.setMinSize(this.width, this.height);
            this.setMaxSize(this.width, this.height);
            this.setPrefSize(this.width, this.height);
            this.backgroundArea.setHeight(this.height);
            this.backgroundArea.setArcWidth(this.height);
            this.backgroundArea.setArcHeight(this.height);
            this.knob.setRadius(this.knobRadius);
            this.knob.setCenterX(this.isSelected() ? this.width - this.knobRadius - this.knobInset : this.knobRadius + this.knobInset);
            this.knob.setCenterY(this.knobCenterY);
        } else {
            this.dark.set(ios);
        }
    }

    public final BooleanProperty iosProperty() {
        if (this.ios == null) {
            this.ios = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosSwitch.this.pseudoClassStateChanged(IOS_PSEUDO_CLASS, this.get());
                    if (this.get()) {
                        MacosSwitch.this.width = 38.0;
                        MacosSwitch.this.height = 25.5;
                        MacosSwitch.this.knobRadius = 11.0;
                        MacosSwitch.this.knobInset = 1.5;
                        MacosSwitch.this.knobCenterY = 12.75;
                        MacosSwitch.this.one.setX(7.0);
                        MacosSwitch.this.one.setY(9.0);
                        MacosSwitch.this.one.setWidth(0.7);
                        MacosSwitch.this.one.setHeight(7.5);
                        MacosSwitch.this.zero.setRadius(3.75);
                        MacosSwitch.this.zero.setCenterX(31.0);
                        MacosSwitch.this.zero.setCenterY(12.75);
                    } else {
                        MacosSwitch.this.width = 38.0;
                        MacosSwitch.this.height = 22.0;
                        MacosSwitch.this.knobRadius = 10.0;
                        MacosSwitch.this.knobInset = 1.0;
                        MacosSwitch.this.knobCenterY = 11.0;
                        MacosSwitch.this.one.setX(8.0);
                        MacosSwitch.this.one.setY(8.0);
                        MacosSwitch.this.one.setWidth(0.7);
                        MacosSwitch.this.one.setHeight(6.0);
                        MacosSwitch.this.zero.setRadius(3.0);
                        MacosSwitch.this.zero.setCenterX(30.0);
                        MacosSwitch.this.zero.setCenterY(11.0);
                    }
                    MacosSwitch.this.setMinSize(MacosSwitch.this.width, MacosSwitch.this.height);
                    MacosSwitch.this.setMaxSize(MacosSwitch.this.width, MacosSwitch.this.height);
                    MacosSwitch.this.setPrefSize(MacosSwitch.this.width, MacosSwitch.this.height);
                    MacosSwitch.this.backgroundArea.setHeight(MacosSwitch.this.height);
                    MacosSwitch.this.backgroundArea.setArcWidth(MacosSwitch.this.height);
                    MacosSwitch.this.backgroundArea.setArcHeight(MacosSwitch.this.height);
                    MacosSwitch.this.knob.setRadius(MacosSwitch.this.knobRadius);
                    MacosSwitch.this.knob.setCenterX(MacosSwitch.this.isSelected() ? MacosSwitch.this.width - MacosSwitch.this.knobRadius - MacosSwitch.this.knobInset : MacosSwitch.this.knobRadius + MacosSwitch.this.knobInset);
                    MacosSwitch.this.knob.setCenterY(MacosSwitch.this.knobCenterY);
                }

                public Object getBean() {
                    return MacosSwitch.this;
                }

                public String getName() {
                    return "ios";
                }
            };
        }
        return this.ios;
    }

    public double getDuration() {
        return this.duration == null ? this._duration : this.duration.get();
    }

    public void setDuration(double duration) {
        if (this.duration == null) {
            this._duration = Helper.clamp(10.0, 500.0, duration);
        } else {
            this.duration.set(duration);
        }
    }

    public DoubleProperty durationProperty() {
        if (this.duration == null) {
            this.duration = new DoublePropertyBase(this._duration){

                protected void invalidated() {
                    this.set(Helper.clamp(10.0, 500.0, this.get()));
                }

                public Object getBean() {
                    return MacosSwitch.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public boolean getShowOnOffText() {
        return this.showOnOffText == null ? this._showOnOffText : this.showOnOffText.get();
    }

    public void setShowOnOffText(boolean show) {
        if (this.showOnOffText == null) {
            this._showOnOffText = show;
            this.one.setVisible(show);
            this.zero.setVisible(show);
        } else {
            this.showOnOffText.set(show);
        }
    }

    public BooleanProperty showOnOffTextProperty() {
        if (this.showOnOffText == null) {
            this.showOnOffText = new BooleanPropertyBase(this._showOnOffText){

                protected void invalidated() {
                    MacosSwitch.this.one.setVisible(this.get());
                    MacosSwitch.this.zero.setVisible(this.get());
                }

                public Object getBean() {
                    return MacosSwitch.this;
                }

                public String getName() {
                    return "showOnOffText";
                }
            };
        }
        return this.showOnOffText;
    }

    public boolean isWindowFocusLost() {
        return this.windowFocusLost.get();
    }

    public void setWindowFocusLost(boolean windowFocusLost) {
        this.windowFocusLost.set(windowFocusLost);
    }

    public BooleanProperty windowFocusLostProperty() {
        return this.windowFocusLost;
    }

    protected HashMap<String, Property> getSettings() {
        return this.settings;
    }

    private void animateToSelected() {
        KeyValue kvBackgroundFillStart = new KeyValue((WritableValue)this.backgroundArea.fillProperty(), (Object)(this.isDark() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()), Interpolator.EASE_BOTH);
        KeyValue kvBackgroundFillEnd = new KeyValue((WritableValue)this.backgroundArea.fillProperty(), (Object)this.getAccentColor(), Interpolator.EASE_BOTH);
        KeyValue kvKnobXStart = new KeyValue((WritableValue)this.knob.centerXProperty(), (Object)(this.knobRadius + this.knobInset), Interpolator.EASE_BOTH);
        KeyValue kvKnobXEnd = new KeyValue((WritableValue)this.knob.centerXProperty(), (Object)(this.width - this.knobRadius - this.knobInset), Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityStart = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityEnd = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)1, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityStart = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)this.zero.getOpacity(), Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityEnd = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvBackgroundFillStart, kvKnobXStart, kvOneOpacityStart, kvZeroOpacityStart});
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)(this.getDuration() * 0.5)), new KeyValue[]{kvZeroOpacityEnd});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.getDuration()), new KeyValue[]{kvBackgroundFillEnd, kvKnobXEnd, kvOneOpacityEnd});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
        this.timeline.play();
    }

    private void animateToDeselected() {
        KeyValue kvBackgroundFillStart = new KeyValue((WritableValue)this.backgroundArea.fillProperty(), (Object)this.getAccentColor(), Interpolator.EASE_BOTH);
        KeyValue kvBackgroundFillEnd = new KeyValue((WritableValue)this.backgroundArea.fillProperty(), (Object)(this.isDark() ? MacosSystemColor.CTRL_BACKGROUND.dark() : MacosSystemColor.CTRL_BACKGROUND.aqua()), Interpolator.EASE_BOTH);
        KeyValue kvKnobXStart = new KeyValue((WritableValue)this.knob.centerXProperty(), (Object)(this.width - this.knobRadius - this.knobInset), Interpolator.EASE_BOTH);
        KeyValue kvKnobXEnd = new KeyValue((WritableValue)this.knob.centerXProperty(), (Object)(this.knobRadius + this.knobInset), Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityStart = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)this.one.getOpacity(), Interpolator.EASE_BOTH);
        KeyValue kvOneOpacityEnd = new KeyValue((WritableValue)this.one.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityStart = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)0, Interpolator.EASE_BOTH);
        KeyValue kvZeroOpacityEnd = new KeyValue((WritableValue)this.zero.opacityProperty(), (Object)1, Interpolator.EASE_BOTH);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvBackgroundFillStart, kvKnobXStart, kvOneOpacityStart, kvZeroOpacityStart});
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)(this.getDuration() * 0.5)), new KeyValue[]{kvOneOpacityEnd});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.getDuration()), new KeyValue[]{kvBackgroundFillEnd, kvKnobXEnd, kvZeroOpacityEnd});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
        this.timeline.play();
    }

    public void addMacEvtObserver(EvtType type, EvtObserver<MacEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeMacEvtObserver(EvtType type, EvtObserver<MacEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllMacEvtObservers() {
        this.observers.clear();
    }

    public void fireMacEvt(MacEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MacEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(MacEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    public String getUserAgentStylesheet() {
        return MacosSwitch.class.getResource("apple.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

