/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.control.TextField;

public class MacosTextField
extends TextField
implements MacosControlWithAccentColor {
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private boolean _dark;
    private BooleanProperty dark;
    private MacosAccentColor _accentColor;
    private ObjectProperty<MacosAccentColor> accentColor;

    public MacosTextField() {
        this.init();
    }

    public MacosTextField(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"macos-text-field");
        this._dark = Helper.isDarkMode();
        this._accentColor = Helper.getMacosAccentColor();
        this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this._dark);
    }

    @Override
    public final boolean isDark() {
        return this.dark == null ? this._dark : this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        if (this.dark == null) {
            this._dark = dark;
            this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, dark);
        } else {
            this.dark.set(dark);
        }
    }

    @Override
    public final BooleanProperty darkProperty() {
        if (this.dark == null) {
            this.dark = new BooleanPropertyBase(){

                protected void invalidated() {
                    MacosTextField.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return MacosTextField.this;
                }

                public String getName() {
                    return "dark";
                }
            };
        }
        return this.dark;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return this.accentColor == null ? this._accentColor : (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        if (this.accentColor == null) {
            this._accentColor = accentColor;
            String style = this.isDark() ? "-fx-focus-color: " + accentColor.getDarkHighlightStyleClass() + ";" + "-fx-faint-focus-color: " + accentColor.getDarkHighlightStyleClass() + ";" + "-highlight-color-dark: " + accentColor.getDarkHighlightStyleClass() + ";" : "-fx-focus-color: " + accentColor.getAquaStyleClass() + ";" + "-highlight-color: " + accentColor.getAquaHighlightStyleClass() + ";";
            this.setStyle(style);
        } else {
            this.accentColor.set((Object)accentColor);
        }
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        if (this.accentColor == null) {
            this.accentColor = new ObjectPropertyBase<MacosAccentColor>(this._accentColor){

                protected void invalidated() {
                    String style = MacosTextField.this.isDark() ? "-fx-focus-color: " + ((MacosAccentColor)((Object)this.get())).getDarkStyleClass() + ";" + "-focus-color-dark: " + ((MacosAccentColor)((Object)this.get())).getDarkHighlightStyleClass() + ";" : "-fx-focus-color: " + ((MacosAccentColor)((Object)this.get())).getAquaStyleClass() + ";" + "-focus-color: " + ((MacosAccentColor)((Object)this.get())).getAquaHighlightStyleClass() + ";";
                    MacosTextField.this.setStyle(style);
                }

                public Object getBean() {
                    return MacosTextField.this;
                }

                public String getName() {
                    return "accentColor";
                }
            };
            this._accentColor = null;
        }
        return this.accentColor;
    }

    public String getUserAgentStylesheet() {
        return MacosTextField.class.getResource("apple.css").toExternalForm();
    }
}

