/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosButton;
import eu.hansolo.applefx.MacosButtonSize;
import eu.hansolo.applefx.MacosButtonType;
import eu.hansolo.applefx.MacosCheckBox;
import eu.hansolo.applefx.MacosCheckBoxSwitch;
import eu.hansolo.applefx.MacosComboBox;
import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.MacosControlWithAccentColor;
import eu.hansolo.applefx.MacosLabel;
import eu.hansolo.applefx.MacosRadioButton;
import eu.hansolo.applefx.MacosSlider;
import eu.hansolo.applefx.MacosSwitch;
import eu.hansolo.applefx.MacosTextField;
import eu.hansolo.applefx.MacosToolbarButton;
import eu.hansolo.applefx.MacosWindowButton;
import eu.hansolo.applefx.tools.Helper;
import eu.hansolo.applefx.tools.MacosAccentColor;
import eu.hansolo.applefx.tools.ResizeHelper;
import eu.hansolo.jdktools.OperatingSystem;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class MacosWindow
extends Region
implements MacosControlWithAccentColor {
    public static final double OFFSET = 40.0;
    private static final DropShadow HEADER_SHADOW = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.1), 1.0, 0.0, 0.0, 1.0);
    private static final DropShadow STAGE_SHADOW_FOCUSED = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.5), 45.0, 0.0, 0.0, 15.0);
    private static final DropShadow STAGE_SHADOW = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.35), 20.0, 0.0, 0.0, 10.0);
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private static final PseudoClass WINDOW_FOCUS_LOST_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"window-focus-lost");
    private static final StyleablePropertyFactory<MacosWindow> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final CssMetaData HEADER_HEIGHT = FACTORY.createSizeCssMetaData("-header-height", s -> s.headerHeight, (Number)HeaderHeight.STANDARD.getHeight(), false);
    private final boolean decorated;
    private final boolean shadowEnabled;
    private BooleanBinding showing;
    private WatchService watchService;
    private BooleanProperty dark;
    private BooleanProperty windowFocusLost;
    private ObjectProperty<MacosAccentColor> accentColor;
    private StyleableProperty<Number> headerHeight;
    private Stage stage;
    private MacosWindowButton closeButton;
    private MacosWindowButton minimizeButton;
    private MacosWindowButton maximizeButton;
    private HBox buttonBox;
    private HBox headerBox;
    private AnchorPane headerPane;
    private HBox headerPaneLeftToolBar;
    private HBox headerPaneRightToolBar;
    private MacosLabel headerText;
    private AnchorPane contentPane;
    private BorderPane mainPane;
    private Parent content;

    public MacosWindow(Stage stage, Parent content) {
        this(stage, content, Helper.isDarkMode(), MacosAccentColor.MULTI_COLOR, Style.DEFAULT, false);
    }

    public MacosWindow(Stage stage, Parent content, boolean darkMode) {
        this(stage, content, Helper.isDarkMode(), MacosAccentColor.MULTI_COLOR, Style.DEFAULT, false);
    }

    public MacosWindow(Stage stage, Parent content, MacosAccentColor accentColor) {
        this(stage, content, Helper.isDarkMode(), Helper.getMacosAccentColor(), Style.DEFAULT, false);
    }

    public MacosWindow(Stage stage, Parent content, boolean darkMode, MacosAccentColor accentColor, Style style, boolean shadowEnabled) {
        if (stage == null) {
            throw new IllegalArgumentException("stage cannot be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        this.stage = stage;
        this.content = content;
        this.dark = new BooleanPropertyBase(darkMode){

            protected void invalidated() {
                MacosWindow.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosWindow.this;
            }

            public String getName() {
                return "dark";
            }
        };
        this.windowFocusLost = new BooleanPropertyBase(){

            public Object getBean() {
                return MacosWindow.this;
            }

            public String getName() {
                return "windowFocusLost";
            }
        };
        this.accentColor = new ObjectPropertyBase<MacosAccentColor>(accentColor){

            protected void invalidated() {
                MacosWindow.this.setAllAccentColors((MacosAccentColor)((Object)this.get()));
            }

            public Object getBean() {
                return MacosWindow.this;
            }

            public String getName() {
                return "accentColor";
            }
        };
        this.decorated = Style.DECORATED == style;
        this.shadowEnabled = shadowEnabled;
        this.headerHeight = new StyleableObjectProperty<Number>((Number)HeaderHeight.STANDARD.getHeight()){

            protected void invalidated() {
                MacosWindow.this.headerPane.setStyle("-header-height: " + this.get() + ";");
                MacosWindow.this.headerPaneLeftToolBar.setVisible(HeaderHeight.DOUBLE.getHeight() == ((Number)this.get()).doubleValue());
                MacosWindow.this.headerPaneRightToolBar.setVisible(HeaderHeight.DOUBLE.getHeight() == ((Number)this.get()).doubleValue());
            }

            public Object getBean() {
                return MacosWindow.this;
            }

            public String getName() {
                return "headerHeight";
            }

            public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                return HEADER_HEIGHT;
            }
        };
        this.init();
        this.registerListeners();
        this.enableDarkMode(this.isDark());
        this.setAllAccentColors(accentColor);
    }

    private void init() {
        if (this.decorated) {
            this.stage.initStyle(StageStyle.TRANSPARENT);
            this.closeButton = new MacosWindowButton(MacosButtonType.CLOSE, MacosButtonSize.NORMAL);
            this.minimizeButton = new MacosWindowButton(MacosButtonType.MINIMIZE, MacosButtonSize.NORMAL);
            this.maximizeButton = new MacosWindowButton(MacosButtonType.MAXIMIZE, MacosButtonSize.NORMAL);
            this.maximizeButton.setDisable(!this.stage.isResizable());
            this.buttonBox = new HBox(8.0, new Node[]{this.closeButton, this.minimizeButton, this.maximizeButton});
            this.buttonBox.setAlignment(Pos.CENTER);
            this.headerText = new MacosLabel(this.stage.getTitle());
            this.headerText.setMaxWidth(Double.MAX_VALUE);
            this.headerText.setPrefWidth(-1.0);
            this.headerText.getStyleClass().add((Object)"macos-header-text");
            this.headerText.setAlignment(Pos.CENTER_LEFT);
            this.headerText.setMouseTransparent(true);
            this.headerPaneLeftToolBar = new HBox(5.0);
            this.headerPaneLeftToolBar.setPrefWidth(0.0);
            this.headerPaneLeftToolBar.setVisible(false);
            this.headerPaneLeftToolBar.setAlignment(Pos.CENTER_LEFT);
            this.headerPaneRightToolBar = new HBox(5.0);
            this.headerPaneRightToolBar.setPrefWidth(0.0);
            this.headerPaneRightToolBar.setVisible(false);
            this.headerPaneRightToolBar.setAlignment(Pos.CENTER_RIGHT);
            HBox.setHgrow((Node)this.closeButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)this.minimizeButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)this.maximizeButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)this.headerPaneLeftToolBar, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.headerText, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)this.headerPaneRightToolBar, (Priority)Priority.ALWAYS);
            HBox.setMargin((Node)this.headerPaneLeftToolBar, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
            HBox.setMargin((Node)this.headerPaneRightToolBar, (Insets)new Insets(0.0, 5.0, 0.0, 60.0));
            this.headerBox = new HBox(new Node[]{this.buttonBox, this.headerPaneLeftToolBar, this.headerText, this.headerPaneRightToolBar});
            this.headerBox.setAlignment(Pos.CENTER_LEFT);
            AnchorPane.setTopAnchor((Node)this.headerBox, (Double)11.0);
            AnchorPane.setRightAnchor((Node)this.headerBox, (Double)11.0);
            AnchorPane.setBottomAnchor((Node)this.headerBox, (Double)11.0);
            AnchorPane.setLeftAnchor((Node)this.headerBox, (Double)11.0);
            this.headerPane = new AnchorPane();
            this.headerPane.getStyleClass().add((Object)"macos-header");
            this.headerPane.setEffect((Effect)HEADER_SHADOW);
            this.headerPane.getChildren().setAll((Object[])new Node[]{this.headerBox});
            AnchorPane.setTopAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setRightAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setBottomAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setLeftAnchor((Node)this.content, (Double)1.0);
            this.contentPane = new AnchorPane(new Node[]{this.content});
            this.contentPane.getStyleClass().add((Object)"macos-content-pane");
            this.mainPane = new BorderPane();
            this.mainPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(10.0), Insets.EMPTY)}));
            this.mainPane.setCenter((Node)this.contentPane);
            this.mainPane.setTop((Node)this.headerPane);
            this.mainPane.setMinSize(270.0, 100.0);
            this.getChildren().add((Object)this.mainPane);
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(10.0), Insets.EMPTY)}));
            if (this.shadowEnabled) {
                this.setEffect((Effect)(this.isFocused() ? STAGE_SHADOW_FOCUSED : STAGE_SHADOW));
                this.setPadding(new Insets(0.0, 40.0, 40.0, 40.0));
                this.setTranslateX(40.0);
            }
        } else {
            AnchorPane.setTopAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setRightAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setBottomAnchor((Node)this.content, (Double)1.0);
            AnchorPane.setLeftAnchor((Node)this.content, (Double)1.0);
            this.contentPane = new AnchorPane(new Node[]{this.content});
            this.contentPane.getStyleClass().add((Object)"macos-content-pane");
            this.contentPane.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.isDark());
            this.getChildren().add((Object)this.contentPane);
        }
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.darkProperty().addListener((o, ov, nv) -> this.enableDarkMode((boolean)nv));
        if (this.decorated) {
            this.headerPane.setOnMousePressed(press -> this.headerPane.setOnMouseDragged(drag -> {
                this.stage.setX(drag.getScreenX() - press.getSceneX());
                this.stage.setY(drag.getScreenY() - press.getSceneY());
            }));
            this.buttonBox.setOnMouseEntered(e -> {
                this.closeButton.setHovered(true);
                this.minimizeButton.setHovered(true);
                this.maximizeButton.setHovered(true);
            });
            this.headerBox.setOnMouseExited(e -> {
                this.closeButton.setHovered(false);
                this.minimizeButton.setHovered(false);
                this.maximizeButton.setHovered(false);
            });
            this.closeButton.setOnMouseReleased(e -> {
                if (this.stage.isShowing()) {
                    this.stage.hide();
                }
            });
            this.minimizeButton.setOnMouseReleased(e -> {
                if (this.stage.isShowing()) {
                    this.stage.setIconified(!this.stage.isIconified());
                }
            });
            this.maximizeButton.setOnMouseReleased(e -> {
                if (this.stage.isShowing()) {
                    if (this.stage.isFullScreen()) {
                        if (this.shadowEnabled) {
                            this.setPadding(new Insets(0.0, 40.0, 40.0, 40.0));
                            this.setTranslateX(40.0);
                        }
                        this.stage.setFullScreen(false);
                    } else {
                        this.setPadding(new Insets(0.0));
                        this.setTranslateX(0.0);
                        this.stage.setFullScreen(true);
                    }
                }
            });
            this.stage.titleProperty().addListener(o -> this.headerText.setText(this.stage.getTitle()));
            this.stage.sceneProperty().addListener((o, ov, nv) -> {
                if (nv != null) {
                    nv.setFill((Paint)Color.TRANSPARENT);
                    nv.widthProperty().addListener(o1 -> this.resize());
                    nv.heightProperty().addListener(o1 -> this.resize());
                    Platform.runLater(() -> ResizeHelper.addResizeListener(this.stage, this.shadowEnabled ? 40.0 : 0.0));
                }
            });
            this.stage.focusedProperty().addListener((o, ov, nv) -> {
                if (this.shadowEnabled) {
                    this.setEffect((Effect)(nv != false ? STAGE_SHADOW_FOCUSED : STAGE_SHADOW));
                }
                this.headerPane.pseudoClassStateChanged(WINDOW_FOCUS_LOST_PSEUDO_CLASS, nv == false);
                this.closeButton.setDisable(nv == false);
                this.minimizeButton.setDisable(nv == false);
                this.maximizeButton.setDisable(nv == false);
                this.windowFocusLost.set(nv == false);
                this.setAllWindowFocusLost(nv == false);
            });
            this.stage.resizableProperty().addListener((o, ov, nv) -> this.maximizeButton.setDisable(nv == false));
        } else {
            this.stage.focusedProperty().addListener((o, ov, nv) -> {
                this.windowFocusLost.set(nv == false);
                this.setAllWindowFocusLost(nv == false);
            });
        }
        if (this.getScene() != null) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (nv1 == null) {
                    return;
                }
                if (this.getScene().getWindow() != null) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (nv2 == null) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.watchForAppearanceChanged();
                if (this.decorated) {
                    this.calculateMinSize();
                    if (this.content instanceof Pane) {
                        Pane p = (Pane)this.content;
                        double minWidth = p.getChildren().stream().filter(node -> node instanceof Region).map(node -> (Region)node).map(region -> region.getWidth()).max(Comparator.naturalOrder()).get();
                        double minHeight = p.getChildren().stream().filter(node -> node instanceof Region).map(node -> (Region)node).map(region -> region.getHeight()).max(Comparator.naturalOrder()).get();
                        this.mainPane.setMinWidth(minWidth);
                        this.mainPane.setMinHeight(minHeight + this.getHeaderHeight());
                    }
                }
            }
        });
    }

    @Override
    public final boolean isDark() {
        return this.dark.get();
    }

    @Override
    public final void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public final BooleanProperty darkProperty() {
        return this.dark;
    }

    public final boolean isWindowFocusLost() {
        return this.windowFocusLost.get();
    }

    public ReadOnlyBooleanProperty windowFocusLostProperty() {
        return this.windowFocusLost;
    }

    @Override
    public MacosAccentColor getAccentColor() {
        return (MacosAccentColor)((Object)this.accentColor.get());
    }

    @Override
    public void setAccentColor(MacosAccentColor accentColor) {
        this.accentColor.set((Object)accentColor);
    }

    @Override
    public ObjectProperty<MacosAccentColor> accentColorProperty() {
        return this.accentColor;
    }

    public Double getHeaderHeight() {
        return ((Number)this.headerHeight.getValue()).doubleValue();
    }

    public void setHeaderHeight(HeaderHeight headerHeight) {
        AnchorPane.setLeftAnchor((Node)this.headerBox, (Double)(HeaderHeight.DOUBLE == headerHeight ? 22.0 : 11.0));
        this.setHeaderHeight(headerHeight.getHeight());
    }

    public void setHeaderHeight(double headerHeight) {
        this.headerHeight.setValue((Object)headerHeight);
    }

    public StyleableProperty<Number> headerHeightProperty() {
        return this.headerHeight;
    }

    public void addToToolbarLeft(MacosToolbarButton toolbarButton) {
        if (HeaderHeight.STANDARD.getHeight() == this.getHeaderHeight().doubleValue()) {
            return;
        }
        if (this.headerPaneLeftToolBar.getChildren().contains((Object)toolbarButton)) {
            return;
        }
        this.headerPaneLeftToolBar.getChildren().add((Object)toolbarButton);
    }

    public void removeFromToolbarLeft(MacosControl control) {
        if (this.headerPaneLeftToolBar.getChildren().contains((Object)control)) {
            this.headerPaneLeftToolBar.getChildren().remove((Object)control);
        }
    }

    public void addToToolbarRight(MacosToolbarButton toolbarButton) {
        if (HeaderHeight.STANDARD.getHeight() == this.getHeaderHeight().doubleValue()) {
            return;
        }
        if (this.headerPaneRightToolBar.getChildren().contains((Object)toolbarButton)) {
            return;
        }
        this.headerPaneRightToolBar.getChildren().add((Object)toolbarButton);
    }

    public void removeFromToolbarRight(MacosControl control) {
        if (this.headerPaneRightToolBar.getChildren().contains((Object)control)) {
            this.headerPaneRightToolBar.getChildren().remove((Object)control);
        }
    }

    public void dispose() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void enableDarkMode(boolean enable) {
        if (this.decorated) {
            this.headerPane.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            this.headerText.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            this.contentPane.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            this.closeButton.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            this.minimizeButton.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            this.maximizeButton.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            Helper.getAllNodes((Parent)this.contentPane).stream().filter(node -> node instanceof MacosControl).forEach(node -> ((MacosControl)node).setDark(enable));
            Helper.getAllNodes((Parent)this.headerPaneLeftToolBar).stream().filter(node -> node instanceof MacosControl).forEach(node -> ((MacosControl)node).setDark(enable));
            Helper.getAllNodes((Parent)this.headerPaneRightToolBar).stream().filter(node -> node instanceof MacosControl).forEach(node -> ((MacosControl)node).setDark(enable));
        } else {
            this.contentPane.pseudoClassStateChanged(DARK_PSEUDO_CLASS, enable);
            Helper.getAllNodes(this.content).stream().filter(node -> node instanceof MacosControl).forEach(node -> ((MacosControl)node).setDark(enable));
        }
    }

    private void setAllAccentColors(MacosAccentColor accentColor) {
        List<Node> allNodes = Helper.getAllNodes((Parent)this.contentPane);
        if (Platform.isFxApplicationThread()) {
            allNodes.stream().filter(node -> node instanceof MacosControl).forEach(node -> node.setStyle(this.isDark() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" : "-accent-color: " + accentColor.getAquaStyleClass() + ";"));
            allNodes.stream().filter(node -> node instanceof MacosSwitch).map(node -> (MacosSwitch)node).forEach(macosSwitch -> macosSwitch.setAccentColor(this.isDark() ? accentColor.getColorDark() : accentColor.getColorAqua()));
            allNodes.stream().filter(node -> node instanceof MacosCheckBoxSwitch).map(node -> (MacosCheckBoxSwitch)node).forEach(macosSwitch -> macosSwitch.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosCheckBox).map(node -> (MacosCheckBox)node).forEach(macosCheckBox -> macosCheckBox.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosRadioButton).map(node -> (MacosRadioButton)node).forEach(macosRadioButton -> macosRadioButton.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosComboBox).map(node -> (MacosComboBox)node).forEach(macosComboBox -> macosComboBox.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosSlider).map(node -> (MacosSlider)node).forEach(macosSlider -> macosSlider.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosTextField).map(node -> (MacosTextField)node).forEach(macosTextField -> macosTextField.setAccentColor(accentColor));
            allNodes.stream().filter(node -> node instanceof MacosButton).map(node -> (MacosButton)node).forEach(macosButton -> macosButton.setAccentColor(accentColor));
        } else {
            Platform.runLater(() -> {
                allNodes.stream().filter(node -> node instanceof MacosControl).forEach(node -> node.setStyle(this.isDark() ? "-accent-color-dark: " + accentColor.getDarkStyleClass() + ";" : "-accent-color: " + accentColor.getAquaStyleClass() + ";"));
                allNodes.stream().filter(node -> node instanceof MacosSwitch).map(node -> (MacosSwitch)node).forEach(macosSwitch -> macosSwitch.setAccentColor(this.isDark() ? accentColor.getColorDark() : accentColor.getColorAqua()));
                allNodes.stream().filter(node -> node instanceof MacosCheckBoxSwitch).map(node -> (MacosCheckBoxSwitch)node).forEach(macosSwitch -> macosSwitch.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosCheckBox).map(node -> (MacosCheckBox)node).forEach(macosCheckBox -> macosCheckBox.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosRadioButton).map(node -> (MacosRadioButton)node).forEach(macosRadioButton -> macosRadioButton.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosComboBox).map(node -> (MacosComboBox)node).forEach(macosComboBox -> macosComboBox.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosSlider).map(node -> (MacosSlider)node).forEach(macosSlider -> macosSlider.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosTextField).map(node -> (MacosTextField)node).forEach(macosTextField -> macosTextField.setAccentColor(accentColor));
                allNodes.stream().filter(node -> node instanceof MacosButton).map(node -> (MacosButton)node).forEach(macosButton -> macosButton.setAccentColor(accentColor));
            });
        }
    }

    private void setAllWindowFocusLost(boolean windowFocusLost) {
        List<Node> allNodes = Helper.getAllNodes((Parent)this.contentPane);
        allNodes.stream().filter(node -> node instanceof MacosControl).forEach(node -> node.pseudoClassStateChanged(WINDOW_FOCUS_LOST_PSEUDO_CLASS, windowFocusLost));
        allNodes.stream().filter(node -> node instanceof MacosSwitch).map(node -> (MacosSwitch)node).forEach(macosSwitch -> macosSwitch.setWindowFocusLost(windowFocusLost));
        allNodes.stream().filter(node -> node instanceof MacosSlider).map(node -> (MacosSlider)node).forEach(macosSlider -> macosSlider.setWindowFocusLost(windowFocusLost));
        allNodes.stream().filter(node -> node instanceof MacosCheckBoxSwitch).map(node -> (MacosCheckBoxSwitch)node).forEach(macosSwitch -> macosSwitch.setWindowFocusLost(windowFocusLost));
    }

    private void calculateMinSize() {
        double width = this.content.getChildrenUnmodifiable().stream().map(node -> node.getLayoutBounds().getWidth()).reduce(0.0, Double::sum);
        double height = this.content.getChildrenUnmodifiable().stream().map(node -> node.getLayoutBounds().getHeight()).reduce(0.0, Double::sum);
        this.contentPane.setMinSize(width, height);
    }

    private void watchForAppearanceChanged() {
        if (OperatingSystem.MACOS != eu.hansolo.jdktools.util.Helper.getOperatingSystem()) {
            return;
        }
        Path path = FileSystems.getDefault().getPath(System.getProperty("user.home"), "/Library/Preferences/");
        Thread t = new Thread(() -> {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                try {
                    WatchKey key;
                    path.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                    while ((key = this.watchService.take()) != null) {
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path changed = (Path)event.context();
                            if (!changed.endsWith(".GlobalPreferences.plist")) continue;
                            this.setDark(Helper.isDarkMode());
                            this.setAccentColor(Helper.getMacosAccentColor());
                        }
                        key.reset();
                    }
                }
                finally {
                    this.watchService.close();
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public String getUserAgentStylesheet() {
        return MacosWindow.class.getResource("apple.css").toExternalForm();
    }

    private void resize() {
        if (this.stage != null) {
            if (this.shadowEnabled) {
                this.stage.setMinWidth(this.contentPane.getMinWidth() + 80.0);
                this.stage.setMinHeight(this.contentPane.getMinHeight() + 80.0);
                this.setMinWidth(this.contentPane.getMinWidth() + 80.0);
                this.setMinHeight(this.contentPane.getMinHeight() + 80.0);
            } else if (this.decorated) {
                this.stage.setMinWidth(this.mainPane.getMinWidth());
                this.stage.setMinHeight(this.mainPane.getMinHeight());
            }
            this.setPrefWidth(this.stage.getWidth());
            this.setPrefHeight(this.stage.getHeight());
        }
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (width > 0.0 && height > 0.0) {
            if (this.decorated) {
                this.mainPane.setPrefSize(width, height);
            } else {
                this.contentPane.setPrefSize(width, height);
            }
        }
    }

    public static enum HeaderHeight {
        STANDARD(28.75),
        DOUBLE(52.5);

        private final double height;

        private HeaderHeight(double height) {
            this.height = height;
        }

        public double getHeight() {
            return this.height;
        }
    }

    public static enum Style {
        DEFAULT,
        DECORATED;

    }
}

