/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.applefx;

import eu.hansolo.applefx.MacosButtonSize;
import eu.hansolo.applefx.MacosButtonType;
import eu.hansolo.applefx.MacosControl;
import eu.hansolo.applefx.tools.Helper;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;

@DefaultProperty(value="children")
public class MacosWindowButton
extends Region
implements MacosControl {
    private static final double MINIMUM_WIDTH = MacosButtonSize.SMALL.px;
    private static final double MINIMUM_HEIGHT = MacosButtonSize.SMALL.px;
    private static final double MAXIMUM_WIDTH = MacosButtonSize.NORMAL.px;
    private static final double MAXIMUM_HEIGHT = MacosButtonSize.NORMAL.px;
    private static final PseudoClass CLOSE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"close");
    private static final PseudoClass MINIMIZE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"minimize");
    private static final PseudoClass MAXIMIZE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"maximize");
    private static final PseudoClass HOVERED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"hovered");
    private static final PseudoClass PRESSED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"pressed");
    private static final PseudoClass DARK_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dark");
    private MacosButtonSize iconSize;
    private BooleanProperty dark;
    private BooleanProperty hovered;
    private static String userAgentStyleSheet;
    private ObjectProperty<MacosButtonType> type;
    private double size;
    private double width;
    private double height;
    private Circle circle;
    private Region symbol;
    private Consumer<MouseEvent> mousePressedConsumer;
    private Consumer<MouseEvent> mouseReleasedConsumer;

    public MacosWindowButton() {
        this(MacosButtonType.CLOSE);
    }

    public MacosWindowButton(MacosButtonType type) {
        this(type, MacosButtonSize.NORMAL);
    }

    public MacosWindowButton(MacosButtonType type, MacosButtonSize size) {
        this.type = new ObjectPropertyBase<MacosButtonType>(type){

            protected void invalidated() {
                switch ((MacosButtonType)((Object)this.get())) {
                    case CLOSE: {
                        MacosWindowButton.this.pseudoClassStateChanged(CLOSE_PSEUDO_CLASS, true);
                        MacosWindowButton.this.pseudoClassStateChanged(MINIMIZE_PSEUDO_CLASS, false);
                        MacosWindowButton.this.pseudoClassStateChanged(MAXIMIZE_PSEUDO_CLASS, false);
                        break;
                    }
                    case MINIMIZE: {
                        MacosWindowButton.this.pseudoClassStateChanged(CLOSE_PSEUDO_CLASS, false);
                        MacosWindowButton.this.pseudoClassStateChanged(MINIMIZE_PSEUDO_CLASS, true);
                        MacosWindowButton.this.pseudoClassStateChanged(MAXIMIZE_PSEUDO_CLASS, false);
                        break;
                    }
                    case MAXIMIZE: {
                        MacosWindowButton.this.pseudoClassStateChanged(CLOSE_PSEUDO_CLASS, false);
                        MacosWindowButton.this.pseudoClassStateChanged(MINIMIZE_PSEUDO_CLASS, false);
                        MacosWindowButton.this.pseudoClassStateChanged(MAXIMIZE_PSEUDO_CLASS, true);
                    }
                }
            }

            public Object getBean() {
                return MacosWindowButton.this;
            }

            public String getName() {
                return "type";
            }
        };
        this.dark = new BooleanPropertyBase(Helper.isDarkMode()){

            protected void invalidated() {
                MacosWindowButton.this.pseudoClassStateChanged(DARK_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosWindowButton.this;
            }

            public String getName() {
                return "darkMode";
            }
        };
        this.hovered = new BooleanPropertyBase(){

            protected void invalidated() {
                MacosWindowButton.this.pseudoClassStateChanged(HOVERED_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return MacosWindowButton.this;
            }

            public String getName() {
                return "hovered";
            }
        };
        this.iconSize = size;
        this.pseudoClassStateChanged(CLOSE_PSEUDO_CLASS, MacosButtonType.CLOSE == type);
        this.pseudoClassStateChanged(MINIMIZE_PSEUDO_CLASS, MacosButtonType.MINIMIZE == type);
        this.pseudoClassStateChanged(MAXIMIZE_PSEUDO_CLASS, MacosButtonType.MAXIMIZE == type);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setMinSize(this.iconSize.px, this.iconSize.px);
                this.setMaxSize(this.iconSize.px, this.iconSize.px);
                this.setPrefSize(this.iconSize.px, this.iconSize.px);
            }
        }
        this.getStyleClass().add((Object)"macos-window-button");
        this.circle = new Circle();
        this.circle.getStyleClass().add((Object)"circle");
        this.circle.setStrokeType(StrokeType.INSIDE);
        this.symbol = new Region();
        this.symbol.getStyleClass().add((Object)(MacosButtonSize.NORMAL == this.iconSize ? "symbol" : "symbol-small"));
        this.getChildren().setAll((Object[])new Node[]{this.circle, this.symbol});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            this.pseudoClassStateChanged(PRESSED_PSEUDO_CLASS, true);
            if (this.mousePressedConsumer == null) {
                return;
            }
            this.mousePressedConsumer.accept((MouseEvent)e);
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            this.pseudoClassStateChanged(PRESSED_PSEUDO_CLASS, false);
            if (this.mouseReleasedConsumer == null) {
                return;
            }
            this.mouseReleasedConsumer.accept((MouseEvent)e);
        });
    }

    protected double computeMinWidth(double height) {
        return MINIMUM_WIDTH;
    }

    protected double computeMinHeight(double width) {
        return MINIMUM_HEIGHT;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return MAXIMUM_WIDTH;
    }

    protected double computeMaxHeight(double width) {
        return MAXIMUM_HEIGHT;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public MacosButtonType getType() {
        return (MacosButtonType)((Object)this.type.get());
    }

    public void setType(MacosButtonType type) {
        this.type.set((Object)type);
    }

    public ObjectProperty<MacosButtonType> typeProperty() {
        return this.type;
    }

    @Override
    public boolean isDark() {
        return this.dark.get();
    }

    @Override
    public void setDark(boolean dark) {
        this.dark.set(dark);
    }

    @Override
    public BooleanProperty darkProperty() {
        return this.dark;
    }

    public boolean isHovered() {
        return this.hovered.get();
    }

    public void setHovered(boolean hovered) {
        this.hovered.set(hovered);
    }

    public BooleanProperty hoveredProperty() {
        return this.hovered;
    }

    public void setOnMousePressed(Consumer<MouseEvent> mousePressedConsumer) {
        this.mousePressedConsumer = mousePressedConsumer;
    }

    public void setOnMouseReleased(Consumer<MouseEvent> mouseReleasedConsumer) {
        this.mouseReleasedConsumer = mouseReleasedConsumer;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.setMinSize(this.size, this.size);
            this.setMaxSize(this.size, this.size);
            this.setPrefSize(this.size, this.size);
            double center = this.size * 0.5;
            this.circle.setRadius(center);
            this.circle.setCenterX(center);
            this.circle.setCenterY(center);
            this.symbol.setPrefSize(this.size, this.size);
        }
    }

    public String getUserAgentStylesheet() {
        if (userAgentStyleSheet == null) {
            userAgentStyleSheet = MacosWindowButton.class.getResource("apple.css").toExternalForm();
        }
        return userAgentStyleSheet;
    }
}

