/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.data.Connection;
import eu.hansolo.fx.charts.data.PlotItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.geometry.Circle;
import eu.hansolo.fx.geometry.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class ArcChart
extends Region {
    private static final double PREFERRED_WIDTH = 500.0;
    private static final double PREFERRED_HEIGHT = 500.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double DEFAULT_SEGMENT_GAP = 4.0;
    private static final double DEFAULT_CONNECTION_OPACITY = 0.65;
    private static final Color DEFAULT_SELECTION_COLOR = Color.rgb((int)128, (int)0, (int)0, (double)0.25);
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Color _tickMarkColor = Color.BLACK;
    private ObjectProperty<Color> tickMarkColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _tickLabelsVisible = true;
    private TickLabelOrientation _tickLabelOrientation = TickLabelOrientation.ORTHOGONAL;
    private double _connectionOpacity = 0.65;
    private DoubleProperty connectionOpacity;
    private Locale _locale = Locale.getDefault();
    private ObjectProperty<Locale> locale;
    private boolean _coloredConnections = false;
    private BooleanProperty coloredConnections;
    private Color _connectionColor = Color.rgb((int)128, (int)128, (int)128, (double)0.25);
    private ObjectProperty<Color> connectionColor;
    private Color _selectionColor = DEFAULT_SELECTION_COLOR;
    private ObjectProperty<Color> selectionColor;
    private boolean _sortByCluster = false;
    private BooleanProperty sortByCluster;
    private boolean _useFullCircle = false;
    private BooleanProperty useFullCircle;
    private boolean _weightConnections = false;
    private BooleanProperty weightConnections;
    private boolean _weightDots = false;
    private BooleanProperty weightDots;
    private ObservableList<PlotItem> items = FXCollections.observableArrayList();
    private ItemEventListener itemListener = e -> this.redraw();
    private ListChangeListener<PlotItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
        }
        this.validateData();
        this.redraw();
    };
    private Map<Circle, PlotItem> itemPaths;
    private Map<Path, Connection> paths;
    private Map<Path, PlotItem[]> connectionMap;
    private PlotItem selectedItem;
    private Tooltip tooltip;
    private String formatString = "%." + this._decimals + "f";
    private ObservableList<Connection> connections = FXCollections.observableArrayList();

    public ArcChart() {
        this.itemPaths = new LinkedHashMap<Circle, PlotItem>();
        this.paths = new LinkedHashMap<Path, Connection>();
        this.connectionMap = new LinkedHashMap<Path, PlotItem[]>();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(500.0, 500.0);
            }
        }
        this.canvas = new Canvas(500.0, 500.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.tooltip = new Tooltip();
        this.tooltip.setAutoHide(true);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMousePressed(e -> this.itemPaths.forEach((itemPath, plotItem) -> {
            double eventY;
            double eventX = e.getX();
            if (itemPath.contains(eventX, eventY = e.getY())) {
                Platform.runLater(() -> {
                    plotItem.fireItemEvent(new ItemEvent<PlotItem>((PlotItem)plotItem, EventType.SELECTED));
                    this.selectedItem = plotItem;
                    this.redraw();
                });
            }
        }));
        this.canvas.setOnMouseReleased(e -> {
            this.selectedItem = null;
            this.redraw();
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.forEach(item -> item.removeItemEventListener(this.itemListener));
        this.items.removeListener(this.itemListListener);
    }

    public Color getTickMarkColor() {
        return this.tickMarkColor == null ? this._tickMarkColor : (Color)this.tickMarkColor.get();
    }

    public void setTickMarkColor(Color COLOR) {
        if (this.tickMarkColor == null) {
            this._tickMarkColor = COLOR;
            this.redraw();
        } else {
            this.tickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickMarkColorProperty() {
        if (this.tickMarkColor == null) {
            this.tickMarkColor = new ObjectPropertyBase<Color>(this._tickMarkColor){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "tickMarkColor";
                }
            };
            this._tickMarkColor = null;
        }
        return this.tickMarkColor;
    }

    public Color getTextColor() {
        return this.textColor == null ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (this.textColor == null) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (this.textColor == null) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public int getDecimals() {
        return this.decimals == null ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (this.decimals == null) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (this.decimals == null) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    ArcChart.this.formatString = "%." + this.get() + "f";
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean getTickLabelsVisible() {
        return this._tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean VISIBLE) {
        this._tickLabelsVisible = VISIBLE;
        this.redraw();
    }

    public TickLabelOrientation getTickLabelOrientation() {
        return this._tickLabelOrientation;
    }

    public void setTickLabelOrientation(TickLabelOrientation ORIENTATION) {
        this._tickLabelOrientation = ORIENTATION;
        this.redraw();
    }

    public double getConnectionOpacity() {
        return this.connectionOpacity == null ? this._connectionOpacity : this.connectionOpacity.get();
    }

    public void setConnectionOpacity(double OPACITY) {
        if (this.connectionOpacity == null) {
            this._connectionOpacity = Helper.clamp(0.1, 1.0, OPACITY);
            this.redraw();
        } else {
            this.connectionOpacity.set(OPACITY);
        }
    }

    public DoubleProperty connectionOpacityProperty() {
        if (this.connectionOpacity == null) {
            this.connectionOpacity = new DoublePropertyBase(this._connectionOpacity){

                protected void invalidated() {
                    this.set(Helper.clamp(0.1, 1.0, this.get()));
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "connectionOpacity";
                }
            };
        }
        return this.connectionOpacity;
    }

    public Locale getLocale() {
        return this.locale == null ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (this.locale == null) {
            this._locale = LOCALE;
            this.redraw();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (this.locale == null) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public boolean getColoredConnections() {
        return this.coloredConnections == null ? this._coloredConnections : this.coloredConnections.get();
    }

    public void setColoredConnections(boolean COLORED) {
        if (this.coloredConnections == null) {
            this._coloredConnections = COLORED;
            this.redraw();
        } else {
            this.coloredConnections.set(COLORED);
        }
    }

    public BooleanProperty coloredConnectionsProperty() {
        if (this.coloredConnections == null) {
            this.coloredConnections = new BooleanPropertyBase(this._coloredConnections){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "coloredConnections";
                }
            };
        }
        return this.coloredConnections;
    }

    public Color getConnectionColor() {
        return this.connectionColor == null ? this._connectionColor : (Color)this.connectionColor.get();
    }

    public void setConnectionColor(Color COLOR) {
        if (this.connectionColor == null) {
            this._connectionColor = COLOR;
            this.redraw();
        } else {
            this.connectionColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> connectionColorProperty() {
        if (this.connectionColor == null) {
            this.connectionColor = new ObjectPropertyBase<Color>(this._connectionColor){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "connectionColor";
                }
            };
            this._connectionColor = null;
        }
        return this.connectionColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor == null ? this._selectionColor : (Color)this.selectionColor.get();
    }

    public void setSelectionColor(Color COLOR) {
        if (this.selectionColor == null) {
            this._selectionColor = COLOR;
            this.redraw();
        } else {
            this.selectionColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectionColorProperty() {
        if (this.selectionColor == null) {
            this.selectionColor = new ObjectPropertyBase<Color>(this._selectionColor){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "selectionColor";
                }
            };
            this._selectionColor = null;
        }
        return this.selectionColor;
    }

    public boolean getSortByCluster() {
        return this.sortByCluster == null ? this._sortByCluster : this.sortByCluster.get();
    }

    public void setSortByCluster(boolean SORT) {
        if (this.sortByCluster == null) {
            this._sortByCluster = SORT;
            this.redraw();
        } else {
            this.sortByCluster.set(SORT);
        }
    }

    public BooleanProperty sortByClusterProperty() {
        if (this.sortByCluster == null) {
            this.sortByCluster = new BooleanPropertyBase(this._sortByCluster){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "sortByCluster";
                }
            };
        }
        return this.sortByCluster;
    }

    public boolean getUseFullCircle() {
        return this.useFullCircle == null ? this._useFullCircle : this.useFullCircle.get();
    }

    public void setUseFullCircle(boolean USE) {
        if (this.useFullCircle == null) {
            this._useFullCircle = USE;
            this.redraw();
        } else {
            this.useFullCircle.set(USE);
        }
    }

    public BooleanProperty useFullCircleProperty() {
        if (this.useFullCircle == null) {
            this.useFullCircle = new BooleanPropertyBase(this._useFullCircle){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "useFullCircle";
                }
            };
        }
        return this.useFullCircle;
    }

    public boolean getWeightConnections() {
        return this.weightConnections == null ? this._weightConnections : this.weightConnections.get();
    }

    public void setWeightConnections(boolean WEIGHT) {
        if (this.weightConnections == null) {
            this._weightConnections = WEIGHT;
            this.redraw();
        } else {
            this.weightConnections.set(WEIGHT);
        }
    }

    public BooleanProperty weightConnectionsProperty() {
        if (this.weightConnections == null) {
            this.weightConnections = new BooleanPropertyBase(this._weightConnections){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "weightConnections";
                }
            };
        }
        return this.weightConnections;
    }

    public boolean getWeightDots() {
        return this.weightDots == null ? this._weightDots : this.weightDots.get();
    }

    public void setWeightDots(boolean WEIGHT) {
        if (this.weightDots == null) {
            this._weightDots = WEIGHT;
            this.redraw();
        } else {
            this.weightDots.set(WEIGHT);
        }
    }

    public BooleanProperty weightDotsProperty() {
        if (this.weightDots == null) {
            this.weightDots = new BooleanPropertyBase(this._weightDots){

                protected void invalidated() {
                    ArcChart.this.redraw();
                }

                public Object getBean() {
                    return ArcChart.this;
                }

                public String getName() {
                    return "weightDots";
                }
            };
        }
        return this.weightDots;
    }

    public PlotItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(PlotItem SELECTED_ITEM) {
        this.selectedItem = SELECTED_ITEM;
        this.redraw();
    }

    public void resetSelectedItem() {
        this.setSelectedItem(null);
    }

    public List<PlotItem> getItems() {
        return this.items;
    }

    public void setItems(PlotItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<PlotItem> ITEMS) {
        this.items.setAll(ITEMS);
        this.validateData();
    }

    public void addItem(PlotItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
        this.validateData();
    }

    public void removeItem(PlotItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public void sortAscending() {
        Collections.sort(this.getItems(), Comparator.comparingDouble(PlotItem::getValue));
    }

    public void sortDescending() {
        Collections.sort(this.getItems(), (item1, item2) -> Double.compare(item2.getValue(), item1.getValue()));
    }

    public ObservableList<Connection> getConnections() {
        return this.connections;
    }

    public Connection getConnection(PlotItem FROM, PlotItem TO) {
        return this.connections.stream().filter(connection -> connection.getOutgoingItem().equals(FROM) && connection.getIncomingItem().equals(TO)).findFirst().orElse(null);
    }

    private void validateData() {
        this.connections.clear();
        HashMap incoming = new HashMap(this.getItems().size());
        for (PlotItem item : this.getItems()) {
            item.getOutgoing().forEach((outgoingItem, value) -> {
                if (incoming.containsKey(outgoingItem)) {
                    this.connections.add((Object)new Connection(item, (PlotItem)outgoingItem, item.getOutgoing().get(outgoingItem), Color.TRANSPARENT));
                } else {
                    this.connections.add((Object)new Connection((PlotItem)outgoingItem, item, item.getOutgoing().get(outgoingItem), Color.TRANSPARENT));
                }
            });
        }
        for (PlotItem item : this.getItems()) {
            if (!incoming.containsKey(item)) continue;
            double sumOfIncoming = (Double)incoming.get(item);
            if (!(item.getValue() < sumOfIncoming)) continue;
            item.setValue(sumOfIncoming);
        }
    }

    private void drawChart() {
        LinkedList<Object> sortedItems;
        this.itemPaths.clear();
        this.paths.clear();
        this.connectionMap.clear();
        int noOfItems = this.items.size();
        double centerY = this.size * 0.5;
        PlotItem itemWithMaxOutgoing = this.items.stream().max(Comparator.comparingDouble(PlotItem::getSumOfOutgoing)).get();
        double minItemSize = this.size * 0.02;
        double maxItemSize = this.size * 0.05;
        double itemSizeFactor = maxItemSize / itemWithMaxOutgoing.getSumOfOutgoing();
        double maxConnectionWidth = maxItemSize;
        double connectionWidthFactor = maxConnectionWidth / Helper.getMaxValueInMap(itemWithMaxOutgoing.getOutgoing());
        double insetX = maxItemSize;
        double stepSizeX = (this.size - 2.0 * insetX) / (double)noOfItems;
        if (this.getSortByCluster()) {
            sortedItems = new LinkedList();
            TreeSet clusters = new TreeSet(this.items.stream().filter(item -> item.getCluster() != null).map(PlotItem::getCluster).collect(Collectors.toSet()));
            clusters.forEach(cluster -> {
                boolean bl = sortedItems.addAll(cluster.getSortedItems());
            });
            if (sortedItems.isEmpty()) {
                sortedItems.addAll((Collection<Object>)this.items);
            }
        } else {
            sortedItems = new LinkedList<PlotItem>((Collection<PlotItem>)this.items);
            Collections.sort(sortedItems, Comparator.comparingDouble(PlotItem::getSumOfOutgoing).reversed());
        }
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        LinkedHashMap<PlotItem, Point> itemPoints = new LinkedHashMap<PlotItem, Point>();
        int i = 0;
        while (i < noOfItems) {
            PlotItem item2 = (PlotItem)sortedItems.get(i);
            double itemX = insetX + (double)i * stepSizeX;
            double itemY = centerY;
            itemPoints.put(item2, new Point(itemX, itemY));
            ++i;
        }
        sortedItems.forEach(item -> {
            Point itemPoint = (Point)itemPoints.get(item);
            this.ctx.setLineCap(StrokeLineCap.BUTT);
            item.getOutgoing().forEach((outgoingItem, value) -> {
                Point outgoingItemPoint = (Point)itemPoints.get(outgoingItem);
                double connectionWidth = this.getWeightConnections() ? Helper.clamp(2.0, maxConnectionWidth, value * connectionWidthFactor) : 2.0;
                double arcWidth = outgoingItemPoint.getX() - itemPoint.getX();
                Connection connection = this.getConnection((PlotItem)item, (PlotItem)outgoingItem);
                Color connectionStroke = this.getColoredConnections() ? (this.getSortByCluster() && item.getCluster() != null ? Helper.getColorWithOpacity(item.getCluster().getFill(), this.getConnectionOpacity()) : (connection != null && !connection.getFill().equals((Object)Color.TRANSPARENT) ? Helper.getColorWithOpacity(connection.getFill(), this.getConnectionOpacity()) : Helper.getColorWithOpacity(item.getFill(), this.getConnectionOpacity()))) : this.getConnectionColor();
                this.ctx.setStroke((Paint)connectionStroke);
                this.ctx.setLineWidth(connectionWidth);
                Path path = new Path();
                path.setStroke((Paint)connectionStroke);
                path.moveTo(itemPoint.getX(), itemPoint.getY());
                if (this.getUseFullCircle()) {
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, 180.0, false, true, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                } else if (arcWidth < 0.0) {
                    path.setStroke((Paint)Helper.getColorWithOpacity(connectionStroke, this.getConnectionOpacity() * 0.5));
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, -180.0, false, false, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                } else {
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, 180.0, false, true, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                }
                path.draw(this.ctx, false, true);
                String tooltipText = item.getName() + " -> " + outgoingItem.getName() + " " + String.format(this.getLocale(), this.formatString, value);
                if (connection != null) {
                    connection.setTooltipText(tooltipText);
                    this.paths.put(path, connection);
                    this.connectionMap.put(path, new PlotItem[]{item, outgoingItem});
                }
            });
        });
        if (this.selectedItem != null) {
            this.selectedItem.getOutgoing().forEach((outgoingItem, value) -> {
                Point itemPoint = (Point)itemPoints.get(this.selectedItem);
                Point outgoingItemPoint = (Point)itemPoints.get(outgoingItem);
                double connectionWidth = this.getWeightConnections() ? Helper.clamp(2.0, maxConnectionWidth, value * connectionWidthFactor) : 2.0;
                double arcWidth = outgoingItemPoint.getX() - itemPoint.getX();
                Color connectionStroke = this.getConnectionColor();
                Connection connection = this.getConnection(this.selectedItem, (PlotItem)outgoingItem);
                if (connection.getIncomingItem().equals(this.selectedItem) || connection.getOutgoingItem().equals(this.selectedItem)) {
                    connectionStroke = this.getColoredConnections() ? this.getSelectionColor() : (this.getSortByCluster() && this.selectedItem.getCluster() != null ? Helper.getColorWithOpacity(this.selectedItem.getCluster().getFill(), this.getConnectionOpacity()) : Helper.getColorWithOpacity(this.selectedItem.getFill(), this.getConnectionOpacity()));
                }
                this.ctx.setStroke((Paint)connectionStroke);
                this.ctx.setLineWidth(connectionWidth);
                Path path = new Path();
                path.setStroke((Paint)connectionStroke);
                path.moveTo(itemPoint.getX(), itemPoint.getY());
                if (this.getUseFullCircle()) {
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, 180.0, false, true, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                } else if (arcWidth < 0.0) {
                    path.setStroke((Paint)Helper.getColorWithOpacity(connectionStroke, this.getConnectionOpacity() * 0.5));
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, -180.0, false, false, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                } else {
                    path.arcTo(arcWidth * 0.5, arcWidth * 0.5, 180.0, false, true, outgoingItemPoint.getX(), outgoingItemPoint.getY());
                }
                path.draw(this.ctx, false, true);
            });
        }
        Collections.reverse(sortedItems);
        sortedItems.forEach(item -> {
            double itemSize = this.getWeightDots() ? Helper.clamp(minItemSize, maxItemSize, item.getSumOfOutgoing() * itemSizeFactor) : minItemSize;
            Point itemPoint = (Point)itemPoints.get(item);
            double itemX = itemPoint.getX();
            double itemY = itemPoint.getY();
            if (this.getSortByCluster()) {
                if (item.getCluster() == null) {
                    this.ctx.setFill((Paint)item.getFill());
                } else {
                    this.ctx.setFill((Paint)item.getCluster().getFill());
                }
            } else {
                this.ctx.setFill((Paint)item.getFill());
            }
            this.ctx.fillOval(itemX - itemSize * 0.5, itemY - itemSize * 0.5, itemSize, itemSize);
            Circle dot = new Circle(itemX, itemY, itemSize * 0.5);
            this.itemPaths.put(dot, (PlotItem)item);
            if (this.getTickLabelsVisible()) {
                this.ctx.save();
                this.ctx.setFill((Paint)this.getTextColor());
                if (this.selectedItem == null) {
                    this.ctx.setFont(Fonts.opensansRegular(this.size * 0.016));
                } else {
                    this.ctx.setFont(this.selectedItem.getName().equals(item.getName()) ? Fonts.opensansRegular(this.size * 0.022) : Fonts.opensansRegular(this.size * 0.016));
                }
                this.ctx.setTextAlign(TickLabelOrientation.ORTHOGONAL == this.getTickLabelOrientation() ? TextAlignment.LEFT : TextAlignment.CENTER);
                this.ctx.setTextBaseline(VPos.CENTER);
                double offsetY = this.getWeightDots() ? maxItemSize * 0.75 : minItemSize * 0.75;
                double itemNamePointX = itemPoint.getX();
                double itemNamePointY = itemPoint.getY() + (TickLabelOrientation.ORTHOGONAL == this.getTickLabelOrientation() ? offsetY : 0.0);
                this.ctx.translate(itemNamePointX, itemNamePointY);
                this.rotateContextForText(this.ctx, 0.0, 270.0, this.getTickLabelOrientation());
                this.ctx.fillText(item.getName(), 0.0, 0.0);
                this.ctx.restore();
            }
        });
    }

    private void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double TEXT_ANGLE, TickLabelOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - TEXT_ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - TEXT_ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                break;
            }
            case TANGENT: {
                if ((360.0 - START_ANGLE - TEXT_ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - TEXT_ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                break;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

