/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.data.Connection;
import eu.hansolo.fx.charts.data.PlotItem;
import eu.hansolo.fx.charts.event.ConnectionEvent;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.geometry.Path;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class CircularPlot
extends Region {
    private static final double PREFERRED_WIDTH = 500.0;
    private static final double PREFERRED_HEIGHT = 500.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double DEFAULT_SEGMENT_GAP = 4.0;
    private static final double DEFAULT_CONNECTION_OPACITY = 0.65;
    private static final double MAJOR_TICK_MARK_LENGTH = 0.0125;
    private static final double MEDIUM_TICK_MARK_LENGTH = 0.01;
    private static final double MINOR_TICK_MARK_LENGTH = 0.0075;
    private static final double TICK_MARK_WIDTH = 0.001;
    private static final double ANGLE_OFFSET = 90.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double mainLineWidth;
    private double outgoingLineWidth;
    private double tickMarkWidth;
    private double chartSize;
    private double chartOffset;
    private double innerChartSize;
    private double innerChartOffset;
    private double centerX;
    private double centerY;
    private Color _tickMarkColor = Color.BLACK;
    private ObjectProperty<Color> tickMarkColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private double _segmentGap = 4.0;
    private DoubleProperty segmentGap;
    private boolean _showFlowDirection = false;
    private BooleanProperty showFlowDirection;
    private boolean _minorTickMarksVisible = true;
    private boolean _mediumTickMarksVisible = true;
    private boolean _majorTickMarksVisible = true;
    private boolean _tickLabelsVisible = true;
    private TickLabelOrientation _tickLabelOrientation = TickLabelOrientation.TANGENT;
    private boolean _onlyFirstAndLastTickLabelVisible = true;
    private double _connectionOpacity = 0.65;
    private DoubleProperty connectionOpacity;
    private Locale _locale = Locale.getDefault();
    private ObjectProperty<Locale> locale;
    private ObservableList<PlotItem> items = FXCollections.observableArrayList();
    private ItemEventListener itemListener = e -> this.redraw();
    private ListChangeListener<PlotItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
        }
        this.validateData();
        this.redraw();
    };
    private Map<Path, PlotItem> itemPaths;
    private Map<Path, Connection> paths;
    private Map<Path, PlotItem[]> connectionMap;
    private Tooltip tooltip;
    private String formatString = "%." + this._decimals + "f";
    private ObservableList<Connection> connections = FXCollections.observableArrayList();

    public CircularPlot() {
        this.itemPaths = new LinkedHashMap<Path, PlotItem>();
        this.paths = new LinkedHashMap<Path, Connection>();
        this.connectionMap = new LinkedHashMap<Path, PlotItem[]>();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(500.0, 500.0);
            }
        }
        this.canvas = new Canvas(500.0, 500.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.tooltip = new Tooltip();
        this.tooltip.setAutoHide(true);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMouseClicked(e -> {
            this.paths.forEach((path, connection) -> {
                double eventY;
                double eventX = e.getX();
                if (path.contains(eventX, eventY = e.getY())) {
                    double tooltipX = eventX + this.canvas.getScene().getX() + this.canvas.getScene().getWindow().getX();
                    double tooltipY = eventY + this.canvas.getScene().getY() + this.canvas.getScene().getWindow().getY() - 25.0;
                    this.tooltip.setText(connection.getTooltipText());
                    this.tooltip.setX(tooltipX);
                    this.tooltip.setY(tooltipY);
                    this.tooltip.show(this.getScene().getWindow());
                    if (this.connectionMap.get(path).length > 1) {
                        Platform.runLater(() -> connection.fireConnectionEvent(new ConnectionEvent<Connection>((Connection)connection, EventType.CONNECTION_SELECTED, (MouseEvent)e)));
                    }
                }
            });
            this.itemPaths.forEach((itemPath, plotItem) -> {
                double eventY;
                double eventX = e.getX();
                if (itemPath.contains(eventX, eventY = e.getY())) {
                    Platform.runLater(() -> plotItem.fireItemEvent(new ItemEvent<PlotItem>((PlotItem)plotItem, EventType.SELECTED, (MouseEvent)e)));
                }
            });
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.forEach(item -> item.removeItemEventListener(this.itemListener));
        this.items.removeListener(this.itemListListener);
    }

    public Color getTickMarkColor() {
        return this.tickMarkColor == null ? this._tickMarkColor : (Color)this.tickMarkColor.get();
    }

    public void setTickMarkColor(Color COLOR) {
        if (this.tickMarkColor == null) {
            this._tickMarkColor = COLOR;
            this.redraw();
        } else {
            this.tickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickMarkColorProperty() {
        if (this.tickMarkColor == null) {
            this.tickMarkColor = new ObjectPropertyBase<Color>(this._tickMarkColor){

                protected void invalidated() {
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "tickMarkColor";
                }
            };
            this._tickMarkColor = null;
        }
        return this.tickMarkColor;
    }

    public Color getTextColor() {
        return this.textColor == null ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (this.textColor == null) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (this.textColor == null) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public int getDecimals() {
        return this.decimals == null ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (this.decimals == null) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (this.decimals == null) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    CircularPlot.this.formatString = "%." + this.get() + "f";
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public double getSegmentGap() {
        return this.segmentGap == null ? this._segmentGap : this.segmentGap.get();
    }

    public void setSegmentGap(double GAP) {
        if (this.segmentGap == null) {
            this._segmentGap = Helper.clamp(0.0, 10.0, GAP);
            this.redraw();
        } else {
            this.segmentGap.set(GAP);
        }
    }

    public DoubleProperty segmentGapProperty() {
        if (this.segmentGap == null) {
            this.segmentGap = new DoublePropertyBase(this._segmentGap){

                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 10.0, this.get()));
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "segmentGap";
                }
            };
        }
        return this.segmentGap;
    }

    public boolean getShowFlowDirection() {
        return this.showFlowDirection == null ? this._showFlowDirection : this.showFlowDirection.get();
    }

    public void setShowFlowDirection(boolean SHOW) {
        if (this.showFlowDirection == null) {
            this._showFlowDirection = SHOW;
            this.drawChart();
        } else {
            this.showFlowDirection.set(SHOW);
        }
    }

    public BooleanProperty showFlowDirectionProperty() {
        if (this.showFlowDirection == null) {
            this.showFlowDirection = new BooleanPropertyBase(this._showFlowDirection){

                protected void invalidated() {
                    CircularPlot.this.drawChart();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "showFlowDirection";
                }
            };
        }
        return this.showFlowDirection;
    }

    public boolean getMinorTickMarksVisible() {
        return this._minorTickMarksVisible;
    }

    public void setMinorTickMarksVisible(boolean VISIBLE) {
        this._minorTickMarksVisible = VISIBLE;
        this.redraw();
    }

    public boolean getMediumTickMarksVisible() {
        return this._mediumTickMarksVisible;
    }

    public void setMediumTickMarksVisible(boolean VISIBLE) {
        this._mediumTickMarksVisible = VISIBLE;
        this.redraw();
    }

    public boolean getMajorTickMarksVisible() {
        return this._majorTickMarksVisible;
    }

    public void setMajorTickMarksVisible(boolean VISIBLE) {
        this._majorTickMarksVisible = VISIBLE;
        this.redraw();
    }

    public boolean getTickLabelsVisible() {
        return this._tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean VISIBLE) {
        this._tickLabelsVisible = VISIBLE;
        this.redraw();
    }

    public TickLabelOrientation getTickLabelOrientation() {
        return this._tickLabelOrientation;
    }

    public void setTickLabelOrientation(TickLabelOrientation ORIENTATION) {
        this._tickLabelOrientation = ORIENTATION;
        this.redraw();
    }

    public boolean isOnlyFirstAndLastTickLabelVisible() {
        return this._onlyFirstAndLastTickLabelVisible;
    }

    public void setOnlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        this._onlyFirstAndLastTickLabelVisible = VISIBLE;
        this.redraw();
    }

    public double getConnectionOpacity() {
        return this.connectionOpacity == null ? this._connectionOpacity : this.connectionOpacity.get();
    }

    public void setConnectionOpacity(double OPACITY) {
        if (this.connectionOpacity == null) {
            this._connectionOpacity = Helper.clamp(0.1, 1.0, OPACITY);
            this.redraw();
        } else {
            this.connectionOpacity.set(OPACITY);
        }
    }

    public DoubleProperty connectionOpacityProperty() {
        if (this.connectionOpacity == null) {
            this.connectionOpacity = new DoublePropertyBase(this._connectionOpacity){

                protected void invalidated() {
                    this.set(Helper.clamp(0.1, 1.0, this.get()));
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "connectionOpacity";
                }
            };
        }
        return this.connectionOpacity;
    }

    public Locale getLocale() {
        return this.locale == null ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (this.locale == null) {
            this._locale = LOCALE;
            this.redraw();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (this.locale == null) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    CircularPlot.this.redraw();
                }

                public Object getBean() {
                    return CircularPlot.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public List<PlotItem> getItems() {
        return this.items;
    }

    public void setItems(PlotItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<PlotItem> ITEMS) {
        this.items.setAll(ITEMS);
        this.validateData();
    }

    public void addItem(PlotItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
        this.validateData();
    }

    public void removeItem(PlotItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public void sortAscending() {
        Collections.sort(this.getItems(), Comparator.comparingDouble(PlotItem::getValue));
    }

    public void sortDescending() {
        Collections.sort(this.getItems(), (item1, item2) -> Double.compare(item2.getValue(), item1.getValue()));
    }

    public ObservableList<Connection> getConnections() {
        return this.connections;
    }

    public Connection getConnection(PlotItem FROM, PlotItem TO) {
        return this.connections.stream().filter(connection -> connection.getOutgoingItem().equals(FROM) && connection.getIncomingItem().equals(TO)).findFirst().orElse(null);
    }

    protected void validateData() {
        this.connections.clear();
        HashMap incoming = new HashMap(this.getItems().size());
        for (PlotItem item : this.getItems()) {
            item.getOutgoing().forEach((outgoingItem, value) -> {
                if (incoming.containsKey(outgoingItem)) {
                    this.connections.add((Object)this.createConnection(item, (PlotItem)outgoingItem, item.getOutgoing().get(outgoingItem), Color.TRANSPARENT));
                } else {
                    this.connections.add((Object)this.createConnection((PlotItem)outgoingItem, item, item.getOutgoing().get(outgoingItem), Color.TRANSPARENT));
                }
            });
        }
        for (PlotItem item : this.getItems()) {
            if (!incoming.containsKey(item)) continue;
            double sumOfIncoming = (Double)incoming.get(item);
            if (!(item.getValue() < sumOfIncoming)) continue;
            item.setValue(sumOfIncoming);
        }
    }

    protected Connection createConnection(PlotItem INCOMING_ITEM, PlotItem OUTGOING_ITEM, double VALUE, Color FILL) {
        return new Connection(INCOMING_ITEM, OUTGOING_ITEM, VALUE, FILL);
    }

    protected void drawChart() {
        this.itemPaths.clear();
        this.paths.clear();
        this.connectionMap.clear();
        TickLabelOrientation tickLabelOrientation = this.getTickLabelOrientation();
        if (TickLabelOrientation.ORTHOGONAL == tickLabelOrientation) {
            this.chartSize = this.size * 0.75;
            this.mainLineWidth = this.chartSize * 0.045;
            this.outgoingLineWidth = this.chartSize * 0.015;
            this.tickMarkWidth = this.chartSize * 0.001;
            this.chartOffset = (this.size - this.chartSize) * 0.5;
            this.innerChartOffset = this.chartOffset + this.chartSize * 0.032;
            this.innerChartSize = this.chartSize - this.chartSize * 0.064;
            this.centerX = this.size * 0.5;
            this.centerY = this.size * 0.5;
        }
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        double sum = this.items.stream().mapToDouble(PlotItem::getValue).sum();
        int noOfItems = this.items.size();
        double innerRadius = this.chartSize * 0.5 - this.mainLineWidth * 0.5;
        double outerRadius = this.chartSize * 0.5 + this.mainLineWidth * 0.5;
        HashMap<PlotItem, ChartItemParameter> parameterMap = new HashMap<PlotItem, ChartItemParameter>(this.items.size());
        double angleStep = (360.0 - (double)noOfItems * this.getSegmentGap()) / sum;
        double angle = -90.0;
        int i = 0;
        while (i < noOfItems) {
            PlotItem item = (PlotItem)this.items.get(i);
            double angleRange = item.getValue() * angleStep;
            double sumOfOutgoing = item.getOutgoing().values().stream().mapToDouble(Double::doubleValue).sum();
            parameterMap.put(item, new ChartItemParameter(angle + 90.0, angleRange));
            this.ctx.setLineWidth(this.mainLineWidth);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(this.chartOffset, this.chartOffset, this.chartSize, this.chartSize, -angle, -angleRange, ArcType.OPEN);
            double[] xy1 = Helper.rotatePointAroundRotationCenter(this.centerX - outerRadius, this.centerY, this.centerX, this.centerY, angle - 180.0);
            double[] xy2 = Helper.rotatePointAroundRotationCenter(this.centerX - outerRadius, this.centerY, this.centerX, this.centerY, angle + angleRange - 180.0);
            double[] xy3 = Helper.rotatePointAroundRotationCenter(this.centerX - innerRadius, this.centerY, this.centerX, this.centerY, angle + angleRange - 180.0);
            double[] xy4 = Helper.rotatePointAroundRotationCenter(this.centerX - innerRadius, this.centerY, this.centerX, this.centerY, angle - 180.0);
            Path itemPath = new Path();
            itemPath.setFill((Paint)Color.TRANSPARENT);
            itemPath.moveTo(xy1[0], xy1[1]);
            itemPath.arcTo(outerRadius, outerRadius, angle + angleRange - 180.0, false, true, xy2[0], xy2[1]);
            itemPath.lineTo(xy3[0], xy3[1]);
            itemPath.arcTo(innerRadius, innerRadius, -angle - angleRange - 180.0, false, false, xy4[0], xy4[1]);
            itemPath.lineTo(xy1[0], xy1[1]);
            itemPath.closePath();
            itemPath.draw(this.ctx, true, false);
            this.itemPaths.put(itemPath, item);
            double outgoingAngleRange = sumOfOutgoing * angleStep;
            this.ctx.setLineWidth(this.outgoingLineWidth);
            this.ctx.strokeArc(this.innerChartOffset, this.innerChartOffset, this.innerChartSize, this.innerChartSize, -angle - angleRange + outgoingAngleRange, -outgoingAngleRange, ArcType.OPEN);
            this.ctx.setLineWidth(this.tickMarkWidth);
            this.ctx.setStroke((Paint)this.getTickMarkColor());
            this.ctx.strokeArc(this.chartOffset - this.mainLineWidth * 0.5, this.chartOffset - this.mainLineWidth * 0.5, this.chartSize + this.mainLineWidth, this.chartSize + this.mainLineWidth, -angle, -angleRange, ArcType.OPEN);
            this.drawTickMarks(item, angle, angleRange);
            angle += angleRange + this.getSegmentGap();
            ++i;
        }
        double innerRingRadius = this.chartSize * 0.462;
        double innerRingRadius2 = this.chartSize * 0.475;
        double outerPointRadius = this.chartSize * 0.26;
        double innerPointRadius = this.chartSize * 0.2;
        int i2 = 0;
        while (i2 < noOfItems) {
            PlotItem item = (PlotItem)this.items.get(i2);
            ChartItemParameter itemParameter = (ChartItemParameter)parameterMap.get(item);
            double itemStartAngle = itemParameter.getStartAngle();
            double itemAngleRange = itemParameter.getAngleRange();
            double itemEndAngle = itemParameter.getEndAngle();
            this.ctx.save();
            this.ctx.setFill((Paint)(Color.TRANSPARENT.equals((Object)item.getTextColor()) ? this.getTextColor() : item.getTextColor()));
            if (item.getFont().getName().equals(Font.getDefault().getName())) {
                this.ctx.setFont(Fonts.latoRegular(this.size * 0.02));
            } else {
                this.ctx.setFont(Fonts.latoRegular(this.size * 0.02));
            }
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setTextBaseline(VPos.CENTER);
            double sinValue = Math.sin(Math.toRadians(-itemStartAngle - itemAngleRange * 0.5 - 180.0));
            double cosValue = Math.cos(Math.toRadians(-itemStartAngle - itemAngleRange * 0.5 - 180.0));
            double itemNamePointX = this.centerX + this.chartSize * 0.56 * sinValue;
            double itemNamePointY = this.centerY + this.chartSize * 0.56 * cosValue;
            if (TickLabelOrientation.ORTHOGONAL == tickLabelOrientation) {
                Font font = Fonts.latoRegular(this.size * 0.02);
                Text measureText = new Text(item.getName());
                measureText.setFont(font);
                double textWidth = measureText.getLayoutBounds().getWidth();
                itemNamePointX += textWidth * 0.33 * sinValue;
                itemNamePointY += textWidth * 0.33 * cosValue;
            }
            this.ctx.translate(itemNamePointX, itemNamePointY);
            this.rotateContextForText(this.ctx, -itemStartAngle, -itemAngleRange * 0.5 + 90.0, tickLabelOrientation);
            this.ctx.fillText(item.getName(), 0.0, 0.0);
            this.ctx.restore();
            for (PlotItem outgoingItem : item.getOutgoing().keySet()) {
                Point p5;
                Point p4;
                ChartItemParameter outgoingItemParameter = (ChartItemParameter)parameterMap.get(outgoingItem);
                double outgoingValue = item.getOutgoing().get(outgoingItem);
                double outgoingAngleRange = outgoingValue * angleStep;
                int indexDelta = this.items.indexOf((Object)item) - this.items.indexOf((Object)outgoingItem);
                outerPointRadius /= (double)Math.abs(indexDelta) + 0.75;
                innerPointRadius /= (double)Math.abs(indexDelta) + 0.75;
                sinValue = Math.sin(Math.toRadians(-itemEndAngle + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                cosValue = Math.cos(Math.toRadians(-itemEndAngle + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                Point p0 = new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians(-itemEndAngle + 180.0 + outgoingAngleRange + itemParameter.getNextOutgoingStartAngle()));
                cosValue = Math.cos(Math.toRadians(-itemEndAngle + 180.0 + outgoingAngleRange + itemParameter.getNextOutgoingStartAngle()));
                Point p1 = new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians(-itemEndAngle + outgoingAngleRange * 0.5 + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                cosValue = Math.cos(Math.toRadians(-itemEndAngle + outgoingAngleRange * 0.5 + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                Point p01 = new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() + 180.0));
                cosValue = Math.cos(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() + 180.0));
                Point p2 = new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() - outgoingAngleRange + 180.0));
                cosValue = Math.cos(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() - outgoingAngleRange + 180.0));
                Point p3 = new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() - outgoingAngleRange * 0.5 + 180.0));
                cosValue = Math.cos(Math.toRadians(-outgoingItemParameter.getNextIncomingStartAngle() - outgoingAngleRange * 0.5 + 180.0));
                Point p23 = this.getShowFlowDirection() ? new Point(this.centerX + innerRingRadius2 * sinValue, this.centerY + innerRingRadius2 * cosValue) : new Point(this.centerX + innerRingRadius * sinValue, this.centerY + innerRingRadius * cosValue);
                sinValue = Math.sin(Math.toRadians((-itemEndAngle - outgoingItemParameter.getNextIncomingStartAngle()) * 0.5 + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                cosValue = Math.cos(Math.toRadians((-itemEndAngle - outgoingItemParameter.getNextIncomingStartAngle()) * 0.5 + 180.0 + itemParameter.getNextOutgoingStartAngle()));
                if (indexDelta < 0) {
                    p4 = new Point(this.centerX + outerPointRadius * sinValue, this.centerY + outerPointRadius * cosValue);
                    p5 = new Point(this.centerX + innerPointRadius * sinValue, this.centerY + innerPointRadius * cosValue);
                } else {
                    p4 = new Point(this.centerX + innerPointRadius * sinValue, this.centerY + innerPointRadius * cosValue);
                    p5 = new Point(this.centerX + outerPointRadius * sinValue, this.centerY + outerPointRadius * cosValue);
                }
                outgoingItemParameter.setNextIncomingStartAngle(outgoingItemParameter.getNextIncomingStartAngle() + outgoingAngleRange);
                itemParameter.setNextOutgoingStartAngle(itemParameter.getNextOutgoingStartAngle() + outgoingAngleRange);
                Connection connection = this.getConnection(item, outgoingItem);
                Color connectionFill = connection != null && !connection.getFill().equals((Object)Color.TRANSPARENT) ? Helper.getColorWithOpacity(connection.getFill(), this.getConnectionOpacity()) : Helper.getColorWithOpacity(item.getFill(), this.getConnectionOpacity());
                Path path = new Path();
                path.setFill((Paint)connectionFill);
                path.moveTo(p0.getX(), p0.getY());
                path.quadraticCurveTo(p4.getX(), p4.getY(), p2.getX(), p2.getY());
                if (this.getShowFlowDirection()) {
                    path.lineTo(p23.getX(), p23.getY());
                    path.lineTo(p3.getX(), p3.getY());
                } else {
                    path.quadraticCurveTo(p23.getX(), p23.getY(), p3.getX(), p3.getY());
                }
                path.quadraticCurveTo(p5.getX(), p5.getY(), p1.getX(), p1.getY());
                path.quadraticCurveTo(p01.getX(), p01.getY(), p0.getX(), p0.getY());
                path.closePath();
                path.draw(this.ctx, true, false);
                String tooltipText = item.getName() + " -> " + outgoingItem.getName() + " " + String.format(this.getLocale(), this.formatString, outgoingValue);
                if (connection == null) continue;
                connection.setTooltipText(tooltipText);
                this.paths.put(path, connection);
                this.connectionMap.put(path, new PlotItem[]{item, outgoingItem});
            }
            ++i2;
        }
    }

    protected void drawTickMarks(PlotItem ITEM, double START_ANGLE, double ANGLE_RANGE) {
        double[] scaleParameters = Helper.calcAutoScale(0.0, ITEM.getValue());
        double minorTickSpace = scaleParameters[0];
        double majorTickSpace = scaleParameters[1];
        double minValue = 0.0;
        double maxValue = ITEM.getValue();
        double range = maxValue - minValue;
        double angleStep = ANGLE_RANGE / range * minorTickSpace;
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(majorTickSpace);
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(0L);
        double counter = 0.0;
        boolean majorTickMarksVisible = this.getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = this.getMediumTickMarksVisible();
        boolean minorTickMarksVisible = this.getMinorTickMarksVisible();
        boolean tickLabelsVisible = this.getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = this.isOnlyFirstAndLastTickLabelVisible();
        double orthTextFactor = 0.542;
        double tickLabelFontSize = this.getDecimals() == 0 ? 0.018 * this.chartSize : 0.017 * this.chartSize;
        double tickLabelOrientationFactor = TickLabelOrientation.HORIZONTAL == this.getTickLabelOrientation() ? 0.9 : 1.0;
        Font tickLabelFont = Fonts.latoRegular(tickLabelFontSize * tickLabelOrientationFactor);
        this.ctx.setStroke((Paint)this.getTickMarkColor());
        this.ctx.setFill((Paint)this.getTickMarkColor());
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setLineWidth(this.size * 0.001);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        BigDecimal tmpStepBD = new BigDecimal(angleStep);
        tmpStepBD = tmpStepBD.setScale(3, RoundingMode.HALF_UP);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        double i = 0.0;
        while (Double.compare(-ANGLE_RANGE - tmpStep, i) <= 0) {
            double sinValue = Math.sin(Math.toRadians(-START_ANGLE + angle + 90.0));
            double cosValue = Math.cos(Math.toRadians(-START_ANGLE + angle + 90.0));
            double innerPointX = this.centerX + this.chartSize * 0.5225 * sinValue;
            double innerPointY = this.centerY + this.chartSize * 0.5225 * cosValue;
            double outerPointX = this.centerX + this.chartSize * 0.5299999999999999 * sinValue;
            double outerPointY = this.centerY + this.chartSize * 0.5299999999999999 * cosValue;
            double outerMediumPointX = this.centerX + this.chartSize * 0.5275 * sinValue;
            double outerMediumPointY = this.centerY + this.chartSize * 0.5275 * cosValue;
            double outerMinorPointX = this.centerX + this.chartSize * 0.5249999999999999 * sinValue;
            double outerMinorPointY = this.centerY + this.chartSize * 0.5249999999999999 * cosValue;
            double textPointX = this.centerX + this.chartSize * orthTextFactor * sinValue;
            double textPointY = this.centerY + this.chartSize * orthTextFactor * cosValue;
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (majorTickMarksVisible) {
                    this.ctx.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                } else if (minorTickMarksVisible) {
                    this.ctx.strokeLine(innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                }
                if (tickLabelsVisible) {
                    this.ctx.save();
                    this.ctx.translate(textPointX, textPointY);
                    this.rotateContextForText(this.ctx, -START_ANGLE, angle, this.getTickLabelOrientation());
                    this.ctx.setFont(tickLabelFont);
                    if (!onlyFirstAndLastLabelVisible) {
                        this.ctx.setFill((Paint)this.getTextColor());
                    } else if (Double.compare(counter, minValue) == 0 || counter + majorTickSpace > maxValue) {
                        this.ctx.setFill((Paint)this.getTextColor());
                    } else {
                        this.ctx.setFill((Paint)Color.TRANSPARENT);
                    }
                    this.ctx.fillText(Helper.format(counter, this.getDecimals(), this.getLocale()), 0.0, 0.0);
                    this.ctx.restore();
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                this.ctx.strokeLine(innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
            } else if (minorTickMarksVisible && Double.compare(counterBD.remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                this.ctx.strokeLine(innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > maxValue) break;
            angle -= angleStep;
            i -= tmpStep;
        }
    }

    private void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double TEXT_ANGLE, TickLabelOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - TEXT_ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - TEXT_ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                break;
            }
            case TANGENT: {
                if ((360.0 - START_ANGLE - TEXT_ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - TEXT_ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - TEXT_ANGLE) % 360.0);
                break;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        this.chartSize = this.size * 0.85;
        this.mainLineWidth = this.chartSize * 0.045;
        this.outgoingLineWidth = this.chartSize * 0.015;
        this.tickMarkWidth = this.chartSize * 0.001;
        this.chartOffset = (this.size - this.chartSize) * 0.5;
        this.innerChartOffset = this.chartOffset + this.chartSize * 0.032;
        this.innerChartSize = this.chartSize - this.chartSize * 0.064;
        this.centerX = this.size * 0.5;
        this.centerY = this.size * 0.5;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.redraw();
        }
    }

    public void redraw() {
        this.drawChart();
    }

    private class ChartItemParameter {
        private double startAngle;
        private double angleRange;
        private double endAngle;
        private double nextIncomingStartAngle;
        private double nextOutgoingStartAngle;

        public ChartItemParameter() {
            this(0.0, 0.0);
        }

        public ChartItemParameter(double START_ANGLE, double ANGLE_RANGE) {
            this.startAngle = START_ANGLE;
            this.angleRange = ANGLE_RANGE;
            this.endAngle = START_ANGLE + ANGLE_RANGE;
            this.nextIncomingStartAngle = START_ANGLE;
            this.nextOutgoingStartAngle = 0.0;
        }

        public double getStartAngle() {
            return this.startAngle;
        }

        public void setStartAngle(double START_ANGLE) {
            this.startAngle = START_ANGLE;
            this.endAngle = this.startAngle + this.getAngleRange();
            this.nextIncomingStartAngle = this.startAngle;
            this.nextOutgoingStartAngle = 0.0;
        }

        public double getAngleRange() {
            return this.angleRange;
        }

        public void setAngleRange(double ANGLE_RANGE) {
            this.angleRange = ANGLE_RANGE;
            this.endAngle = this.getStartAngle() + this.angleRange;
            this.nextOutgoingStartAngle = 0.0;
        }

        public double getEndAngle() {
            return this.endAngle;
        }

        public double getNextIncomingStartAngle() {
            return this.nextIncomingStartAngle;
        }

        public void setNextIncomingStartAngle(double ANGLE) {
            this.nextIncomingStartAngle = ANGLE;
        }

        public double getNextOutgoingStartAngle() {
            return this.nextOutgoingStartAngle;
        }

        public void setNextOutgoingStartAngle(double ANGLE) {
            this.nextOutgoingStartAngle = ANGLE;
        }
    }
}

