/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.LegendItem;
import eu.hansolo.fx.charts.series.Series;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;

@DefaultProperty(value="children")
public class Legend
extends FlowPane {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 18.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private ObservableList<LegendItem> legendItems = FXCollections.observableArrayList();
    private ListChangeListener<LegendItem> itemListListener;

    public Legend() {
        this(new ArrayList<LegendItem>());
    }

    public Legend(LegendItem ... LEGEND_ITEMS) {
        this(Arrays.asList(LEGEND_ITEMS));
    }

    public Legend(List<LegendItem> LEGEND_ITEMS) {
        this.legendItems.addAll(LEGEND_ITEMS);
        this.itemListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(item -> {
                        boolean bl = this.getChildren().add((Object)item);
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(item -> {
                    boolean bl = this.getChildren().remove((Object)item);
                });
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.setHgap(3.168);
        this.setVgap(3.168);
        this.setOrientation(this.getOrientation());
        this.setAlignment(Pos.TOP_LEFT);
        this.getChildren().addAll(this.legendItems);
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.legendItems.addListener(this.itemListListener);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 20.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 18.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        "".equals(PROPERTY);
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.legendItems.removeListener(this.itemListListener);
    }

    public ObservableList<LegendItem> getLegendItems() {
        return this.legendItems;
    }

    public void setLegendItems(LegendItem ... LEGEND_ITEMS) {
        this.setLegendItems(Arrays.asList(LEGEND_ITEMS));
    }

    public void setLegendItems(List<LegendItem> LEGEND_ITEMS) {
        this.legendItems.setAll(LEGEND_ITEMS);
    }

    public void addLegendItem(LegendItem ITEM) {
        if (!this.legendItems.contains((Object)ITEM)) {
            this.legendItems.add((Object)ITEM);
        }
    }

    public void removeLegendItem(LegendItem ITEM) {
        if (this.legendItems.contains((Object)ITEM)) {
            this.legendItems.remove((Object)ITEM);
        }
    }

    public void createFromListOfSeries(List<Series> SERIES) {
        this.legendItems.clear();
        SERIES.forEach(series -> {
            boolean bl = this.legendItems.add((Object)new LegendItem(series.getSymbol(), series.getName(), series.getSymbolFill(), series.getSymbolStroke()));
        });
    }

    private double getItemHeight() {
        if (this.legendItems.size() == 0) {
            return 0.0;
        }
        return ((LegendItem)((Object)this.legendItems.get(0))).getHeight();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.setHgap(this.getItemHeight() * 0.22);
            this.setVgap(this.getItemHeight() * 0.22);
            this.redraw();
        }
    }

    private void redraw() {
    }
}

