/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.event.SelectionEvent;
import eu.hansolo.fx.charts.event.SelectionEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

public class SectorChart
extends Region {
    private static final int MIN_NO_OF_SECTORS = 4;
    private static final int MAX_NO_OF_SECTORS = 128;
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 10.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double centerX = 125.0;
    private double centerY = 125.0;
    private Pane pane;
    private Canvas canvas;
    private GraphicsContext ctx;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private String formatString = "%." + this._decimals + "f";
    private double angleStep;
    private ObservableList<ChartItemSeries<ChartItem>> allSeries;
    private Map<Sector, ChartItem> sectorMap;
    private double originalThreshold = 100.0;
    private double _threshold = 100.0;
    private DoubleProperty threshold;
    private Color _thresholdColor;
    private ObjectProperty<Color> thresholdColor;
    private boolean _thresholdVisible = false;
    private BooleanProperty thresholdVisible;
    private boolean _itemTextVisible = true;
    private BooleanProperty itemTextVisible;
    private boolean _seriesTextVisible = true;
    private BooleanProperty seriesTextVisible;
    private boolean _seriesSumTextVisible = true;
    private BooleanProperty seriesSumTextVisible;
    private Color _gridColor;
    private ObjectProperty<Color> gridColor;
    private CopyOnWriteArrayList<SelectionEventListener> listeners;
    private InfoPopup popup;
    private InvalidationListener resizeListener;
    private ListChangeListener<ChartItemSeries<ChartItem>> seriesListener;
    private ListChangeListener<ChartItem> itemListListener;
    private ItemEventListener itemEventListener;
    private EventHandler<MouseEvent> mouseHandler;

    public SectorChart() {
        this(null);
    }

    public SectorChart(List<ChartItemSeries<ChartItem>> ALL_SERIES) {
        this.allSeries = ALL_SERIES == null ? FXCollections.observableArrayList() : FXCollections.observableArrayList(ALL_SERIES);
        this.sectorMap = new HashMap<Sector, ChartItem>();
        this._gridColor = Color.WHITE;
        this._thresholdColor = Color.RED;
        this.listeners = new CopyOnWriteArrayList();
        this.resizeListener = o -> this.resize();
        this.seriesListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(series -> {
                        series.getItems().forEach(item -> item.addItemEventListener(this.itemEventListener));
                        series.getItems().addListener(this.itemListListener);
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(series -> {
                    series.getItems().forEach(item -> item.removeItemEventListener(this.itemEventListener));
                    series.getItems().removeListener(this.itemListListener);
                });
            }
            this.angleStep = 360.0 / (double)this.getNoOfSectors();
            this.redraw();
        };
        this.itemListListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(item -> item.addItemEventListener(this.itemEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(item -> item.removeItemEventListener(this.itemEventListener));
            }
        };
        this.itemEventListener = e -> this.redraw();
        this.mouseHandler = e -> {
            Optional<Map.Entry> optionalSector = this.sectorMap.entrySet().parallelStream().filter(entry -> Helper.isInSector(e.getX(), e.getY(), this.centerX, this.centerY, ((Sector)entry.getKey()).radius, ((Sector)entry.getKey()).startAngle, ((Sector)entry.getKey()).segmentAngle)).findFirst();
            if (optionalSector.isPresent()) {
                this.popup.setX(e.getScreenX());
                this.popup.setY(e.getScreenY() - this.popup.getHeight());
                this.popup.update((Item)optionalSector.get().getValue());
                this.popup.animatedShow(this.getScene().getWindow());
            }
        };
        if (ALL_SERIES == null || ALL_SERIES.isEmpty()) {
            int noOfSectorsPerSeries = 32;
            int i = 0;
            while (i < 4) {
                ChartItemSeries<ChartItem> series2 = new ChartItemSeries<ChartItem>();
                int j = 0;
                while (j < noOfSectorsPerSeries) {
                    series2.getItems().add((Object)new ChartItem(0.0));
                    ++j;
                }
                this.addSeries(series2);
                ++i;
            }
        } else {
            this.allSeries.forEach(series -> {
                series.getItems().forEach(item -> item.addItemEventListener(this.itemEventListener));
                series.getItems().addListener(this.itemListListener);
            });
        }
        this.angleStep = 360.0 / (double)this.getNoOfSectors();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void initAllSeries(List<ChartItemSeries<ChartItem>> ALL_SERIES) {
        if (ALL_SERIES == null || ALL_SERIES.isEmpty()) {
            int noOfSectorsPerSeries = 32;
            int i = 0;
            while (i < 4) {
                ChartItemSeries<ChartItem> series = new ChartItemSeries<ChartItem>();
                int j = 0;
                while (j < noOfSectorsPerSeries) {
                    series.getItems().add((Object)new ChartItem(0.0));
                    ++j;
                }
                this.addSeries(series);
                ++i;
            }
        } else {
            this.allSeries.setAll(ALL_SERIES);
        }
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(10.0, 10.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.popup = new InfoPopup();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.resizeListener);
        this.heightProperty().addListener(this.resizeListener);
        this.allSeries.addListener(this.seriesListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    public void dispose() {
        this.widthProperty().removeListener(this.resizeListener);
        this.heightProperty().removeListener(this.resizeListener);
        this.allSeries.removeListener(this.seriesListener);
        this.allSeries.forEach(series -> {
            series.getItems().forEach(item -> item.removeItemEventListener(this.itemEventListener));
            series.getItems().removeListener(this.itemListListener);
        });
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    public double getMinValue() {
        return this.allSeries.isEmpty() ? 0.0 : this.allSeries.stream().min(Comparator.comparingDouble(ChartItemSeries::getMinValue)).map(ChartItemSeries::getMinValue).orElse(0.0);
    }

    public double getMaxValue() {
        return this.allSeries.isEmpty() ? 100.0 : this.allSeries.stream().max(Comparator.comparingDouble(ChartItemSeries::getMaxValue)).map(ChartItemSeries::getMaxValue).orElse(100.0);
    }

    public double getRange() {
        return this.getMaxValue() - this.getMinValue();
    }

    public int getDecimals() {
        return this.decimals == null ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (this.decimals == null) {
            this._decimals = DECIMALS;
            this.formatString = "%." + this._decimals + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (this.decimals == null) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    SectorChart.this.formatString = "%." + this.get() + "f";
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public double getThreshold() {
        return this.threshold == null ? this._threshold : this.threshold.get();
    }

    public void setThreshold(double VALUE) {
        this.originalThreshold = VALUE;
        if (this.threshold == null) {
            this._threshold = this.allSeries.isEmpty() ? VALUE : Helper.clamp(this.getMinValue(), this.getMaxValue(), VALUE);
            this.drawChart();
        } else {
            this.threshold.set(VALUE);
        }
    }

    public DoubleProperty thresholdProperty() {
        if (this.threshold == null) {
            this.threshold = new DoublePropertyBase(this._threshold){

                protected void invalidated() {
                    if (!SectorChart.this.allSeries.isEmpty()) {
                        SectorChart.this.originalThreshold = this.get();
                        this.set(Helper.clamp(SectorChart.this.getMinValue(), SectorChart.this.getMaxValue(), this.get()));
                    }
                    SectorChart.this.drawChart();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    public int getNoOfSectors() {
        return this.allSeries.isEmpty() ? 0 : this.allSeries.stream().mapToInt(l -> l.getItems().size()).sum();
    }

    public boolean isThresholdVisible() {
        return this.thresholdVisible == null ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public void setThresholdVisible(boolean VISIBLE) {
        if (this.thresholdVisible == null) {
            this._thresholdVisible = VISIBLE;
            this.redraw();
        } else {
            this.thresholdVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdVisibleProperty() {
        if (this.thresholdVisible == null) {
            this.thresholdVisible = new BooleanPropertyBase(this._thresholdVisible){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "thresholdVisible";
                }
            };
        }
        return this.thresholdVisible;
    }

    public boolean getItemTextVisible() {
        return this.itemTextVisible == null ? this._itemTextVisible : this.itemTextVisible.get();
    }

    public void setItemTextVisible(boolean VISIBLE) {
        if (this.itemTextVisible == null) {
            this._itemTextVisible = VISIBLE;
            this.redraw();
        } else {
            this.itemTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty itemTextVisibleProperty() {
        if (this.itemTextVisible == null) {
            this.itemTextVisible = new BooleanPropertyBase(this._itemTextVisible){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "itemTextVisible";
                }
            };
        }
        return this.itemTextVisible;
    }

    public boolean getSeriesTextVisible() {
        return this.seriesTextVisible == null ? this._seriesTextVisible : this.seriesTextVisible.get();
    }

    public void setSeriesTextVisible(boolean VISIBLE) {
        if (this.seriesTextVisible == null) {
            this._seriesTextVisible = VISIBLE;
            this.redraw();
        } else {
            this.seriesTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty seriesTextVisibleProperty() {
        if (this.seriesTextVisible == null) {
            this.seriesTextVisible = new BooleanPropertyBase(this._seriesTextVisible){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "seriesTextVisible";
                }
            };
        }
        return this.seriesTextVisible;
    }

    public boolean getSeriesSumTextVisible() {
        return this.seriesSumTextVisible == null ? this._seriesSumTextVisible : this.seriesSumTextVisible.get();
    }

    public void setSeriesSumTextVisible(boolean VISIBLE) {
        if (this.seriesSumTextVisible == null) {
            this._seriesSumTextVisible = VISIBLE;
            this.redraw();
        } else {
            this.seriesSumTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty seriesSumTextVisibleProperty() {
        if (this.seriesSumTextVisible == null) {
            this.seriesTextVisible = new BooleanPropertyBase(this._seriesSumTextVisible){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "seriesSumTextVisible";
                }
            };
        }
        return this.seriesSumTextVisible;
    }

    public ObservableList<ChartItemSeries<ChartItem>> getAllSeries() {
        return this.allSeries;
    }

    public void setAllSeries(List<ChartItemSeries<ChartItem>> ALL_SERIES) {
        int noOfSectors = this.allSeries.stream().mapToInt(l -> l.getItems().size()).sum();
        if (noOfSectors < 4) {
            throw new IllegalArgumentException("Not enough sectors (min. 4needed)");
        }
        if (noOfSectors > 128) {
            throw new IllegalArgumentException("Too many sectors (max. 128 sectors allowed)");
        }
        this.allSeries.setAll(ALL_SERIES);
        this.setThreshold(this.originalThreshold);
    }

    public void addSeries(ChartItemSeries<ChartItem> SERIES) {
        int noOfSectors = this.allSeries.stream().mapToInt(l -> l.getItems().size()).sum();
        if (noOfSectors + SERIES.getItems().size() > 128) {
            throw new IllegalArgumentException("Too many sectors (max. " + this.getNoOfSectors() + " sectors allowed)");
        }
        this.allSeries.add(SERIES);
        this.setThreshold(this.originalThreshold);
    }

    public void reset() {
        this.allSeries.clear();
        this.initAllSeries((List<ChartItemSeries<ChartItem>>)this.allSeries);
    }

    public Color getGridColor() {
        return this.gridColor == null ? this._gridColor : (Color)this.gridColor.getValue();
    }

    public void setGridColor(Color COLOR) {
        if (this.gridColor == null) {
            this._gridColor = COLOR;
            this.redraw();
        } else {
            this.gridColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> gridColorProperty() {
        if (this.gridColor == null) {
            this.gridColor = new ObjectPropertyBase<Color>(this._gridColor){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "gridColor";
                }
            };
            this._gridColor = null;
        }
        return this.gridColor;
    }

    public Color getThresholdColor() {
        return this.thresholdColor == null ? this._thresholdColor : (Color)this.thresholdColor.getValue();
    }

    public void setThresholdColor(Color COLOR) {
        if (this.thresholdColor == null) {
            this._thresholdColor = COLOR;
            this.redraw();
        } else {
            this.thresholdColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdColorProperty() {
        if (this.thresholdColor == null) {
            this.thresholdColor = new ObjectPropertyBase<Color>(this._thresholdColor){

                protected void invalidated() {
                    SectorChart.this.redraw();
                }

                public Object getBean() {
                    return SectorChart.this;
                }

                public String getName() {
                    return "thresholdColor";
                }
            };
            this._thresholdColor = null;
        }
        return this.thresholdColor;
    }

    public String getUserAgentStylesheet() {
        return SectorChart.class.getResource("chart.css").toExternalForm();
    }

    public void setOnSelectionEvent(SelectionEventListener LISTENER) {
        this.addSelectionEventListener(LISTENER);
    }

    public void addSelectionEventListener(SelectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeSelectionEventListener(SelectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllSelectionEventListeners() {
        this.listeners.clear();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        for (SelectionEventListener listener : this.listeners) {
            listener.onSelectionEvent(EVENT);
        }
    }

    private void resize() {
        double height;
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d = this.size = width < (height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.centerX = this.getInsets().getLeft() + this.size * 0.5;
            this.centerY = this.getInsets().getTop() + this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.redraw();
        }
    }

    public void redraw() {
        this.canvas.setCache(false);
        this.drawChart();
        this.canvas.setCache(true);
        this.canvas.setCacheHint(CacheHint.QUALITY);
    }

    private void drawChart() {
        double radius;
        double radiusFactor;
        ChartItem item;
        int j;
        ChartItemSeries series;
        double CENTER_X;
        if (this.ctx == null) {
            return;
        }
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.95 * this.size;
        double CIRCLE_RADIUS = 0.475 * CIRCLE_SIZE;
        double MIN_VALUE = this.getMinValue();
        double MAX_VALUE = this.getMaxValue();
        double DATA_RANGE = MAX_VALUE - MIN_VALUE;
        int NO_OF_SECTORS = this.getNoOfSectors();
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        this.ctx.save();
        this.ctx.translate(CENTER_X, CENTER_Y);
        this.ctx.rotate(-90.0);
        this.ctx.translate(-CENTER_X, -CENTER_Y);
        this.ctx.save();
        int i = 0;
        while (i < this.allSeries.size()) {
            ChartItemSeries series2 = (ChartItemSeries)this.allSeries.get(i);
            this.ctx.beginPath();
            this.ctx.moveTo(CENTER_X, CENTER_Y);
            this.ctx.arc(CENTER_X, CENTER_Y, CIRCLE_RADIUS, CIRCLE_RADIUS, 0.0, -this.angleStep * (double)series2.getItems().size());
            this.ctx.closePath();
            this.ctx.setFill(series2.getFill());
            this.ctx.fill();
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(this.angleStep * (double)series2.getItems().size());
            this.ctx.translate(-CENTER_X, -CENTER_Y);
            ++i;
        }
        this.ctx.restore();
        double currentAngle = 0.0;
        int i2 = 0;
        while (i2 < this.allSeries.size()) {
            series = (ChartItemSeries)this.allSeries.get(i2);
            j = 0;
            while (j < series.getItems().size()) {
                item = (ChartItem)series.getItems().get(j);
                radiusFactor = Helper.clamp(MIN_VALUE, MAX_VALUE, item.getValue() - MIN_VALUE) / DATA_RANGE;
                radius = Helper.clamp(0.0, CIRCLE_RADIUS, radiusFactor * CIRCLE_RADIUS);
                this.ctx.beginPath();
                this.ctx.moveTo(CENTER_X, CENTER_Y);
                this.ctx.arc(CENTER_X, CENTER_Y, radius, radius, 0.0, -this.angleStep);
                this.ctx.closePath();
                this.ctx.setFill((Paint)item.getFill());
                this.ctx.fill();
                this.ctx.translate(CENTER_X, CENTER_Y);
                this.ctx.rotate(this.angleStep);
                this.ctx.translate(-CENTER_X, -CENTER_Y);
                this.sectorMap.put(new Sector(this.centerX, this.centerY, radius, currentAngle, this.angleStep), item);
                currentAngle += this.angleStep;
                ++j;
            }
            ++i2;
        }
        this.ctx.restore();
        this.ctx.setLineWidth(0.75);
        this.ctx.setStroke((Paint)this.getGridColor());
        this.ctx.save();
        i2 = 0;
        while (i2 < NO_OF_SECTORS) {
            this.ctx.strokeLine(CENTER_X, CENTER_Y, CENTER_X, CENTER_Y - CIRCLE_RADIUS);
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(this.angleStep);
            this.ctx.translate(-CENTER_X, -CENTER_Y);
            ++i2;
        }
        this.ctx.restore();
        if (this.isThresholdVisible()) {
            this.ctx.save();
            radiusFactor = Helper.clamp(MIN_VALUE, MAX_VALUE, this.getThreshold() - MIN_VALUE) / DATA_RANGE;
            radius = Helper.clamp(0.0, CIRCLE_RADIUS, radiusFactor * CIRCLE_RADIUS);
            this.ctx.setLineWidth(Helper.clamp(0.75, 1.0, this.size * 0.005));
            this.ctx.setLineDashes(new double[]{6.0, 3.0});
            this.ctx.setStroke((Paint)this.getThresholdColor());
            this.ctx.strokeOval(0.5 * this.size - radius, 0.5 * this.size - radius, 2.0 * radius, 2.0 * radius);
            this.ctx.restore();
        }
        this.ctx.save();
        this.ctx.translate(CENTER_X, CENTER_Y);
        this.ctx.rotate(this.angleStep * 0.5);
        this.ctx.translate(-CENTER_X, -CENTER_Y);
        if (this.getItemTextVisible()) {
            this.ctx.save();
            this.ctx.setFont(Fonts.latoRegular(0.015 * this.size));
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setTextBaseline(VPos.CENTER);
            currentAngle = 0.0;
            i2 = 0;
            while (i2 < this.allSeries.size()) {
                series = (ChartItemSeries)this.allSeries.get(i2);
                j = 0;
                while (j < series.getItems().size()) {
                    item = (ChartItem)series.getItems().get(j);
                    this.ctx.setFill((Paint)item.getTextFill());
                    this.ctx.save();
                    this.ctx.setTextAlign(currentAngle < 180.0 ? TextAlignment.RIGHT : TextAlignment.LEFT);
                    this.ctx.translate(CENTER_X, this.size * 0.06);
                    this.ctx.rotate((double)(currentAngle < 180.0 ? 270 : 90));
                    this.ctx.translate(-CENTER_X, -this.size * 0.06);
                    this.ctx.fillText(item.getName(), CENTER_X, this.size * 0.06);
                    this.ctx.restore();
                    this.ctx.translate(CENTER_X, CENTER_Y);
                    this.ctx.rotate(this.angleStep);
                    this.ctx.translate(-CENTER_X, -CENTER_Y);
                    currentAngle += this.angleStep;
                    ++j;
                }
                ++i2;
            }
            this.ctx.restore();
        }
        if (this.getSeriesTextVisible()) {
            this.ctx.save();
            this.ctx.setFont(Fonts.latoRegular(0.018 * this.size));
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setTextBaseline(VPos.CENTER);
            boolean sumVisible = this.getSeriesSumTextVisible();
            currentAngle = 0.0;
            int i3 = 0;
            while (i3 < this.allSeries.size()) {
                ChartItemSeries series3 = (ChartItemSeries)this.allSeries.get(i3);
                this.ctx.translate(CENTER_X, CENTER_Y);
                this.ctx.rotate(this.angleStep * (double)series3.getItems().size() * 0.5 - this.angleStep * 0.5);
                this.ctx.translate(-CENTER_X, -CENTER_Y);
                this.ctx.save();
                this.ctx.translate(CENTER_X, this.size * 0.035);
                this.ctx.rotate((double)((currentAngle += this.angleStep * (double)series3.getItems().size() * 0.5 - this.angleStep * 0.5) > 135.0 && currentAngle < 225.0 ? 180 : 0));
                this.ctx.translate(-CENTER_X, -this.size * 0.035);
                this.ctx.setFill((Paint)series3.getTextFill());
                if (sumVisible) {
                    this.ctx.fillText(String.valueOf(series3.getName()) + " (" + String.format(Locale.US, this.formatString, series3.getSumOfAllItems()) + ")", CENTER_X, this.size * 0.035);
                } else {
                    this.ctx.fillText(series3.getName(), CENTER_X, this.size * 0.035);
                }
                this.ctx.restore();
                this.ctx.translate(CENTER_X, CENTER_Y);
                this.ctx.rotate(this.angleStep * (double)series3.getItems().size() * 0.5 + this.angleStep * 0.5);
                this.ctx.translate(-CENTER_X, -CENTER_Y);
                currentAngle += this.angleStep * (double)series3.getItems().size() * 0.5 + this.angleStep * 0.5;
                ++i3;
            }
            this.ctx.restore();
        }
        this.ctx.restore();
    }

    private static final class Sector {
        private final double centerX;
        private final double centerY;
        private final double radius;
        private final double startAngle;
        private final double segmentAngle;

        private Sector(double centerX, double centerY, double radius, double startAngle, double segmentAngle) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.radius = radius;
            this.startAngle = startAngle;
            this.segmentAngle = segmentAngle;
        }

        public double centerX() {
            return this.centerX;
        }

        public double centerY() {
            return this.centerY;
        }

        public double radius() {
            return this.radius;
        }

        public double startAngle() {
            return this.startAngle;
        }

        public double segmentAngle() {
            return this.segmentAngle;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Sector that = (Sector)obj;
            return Double.doubleToLongBits(this.centerX) == Double.doubleToLongBits(that.centerX) && Double.doubleToLongBits(this.centerY) == Double.doubleToLongBits(that.centerY) && Double.doubleToLongBits(this.radius) == Double.doubleToLongBits(that.radius) && Double.doubleToLongBits(this.startAngle) == Double.doubleToLongBits(that.startAngle) && Double.doubleToLongBits(this.segmentAngle) == Double.doubleToLongBits(that.segmentAngle);
        }

        public int hashCode() {
            return Objects.hash(this.centerX, this.centerY, this.radius, this.startAngle, this.segmentAngle);
        }

        public String toString() {
            return "Sector[centerX=" + this.centerX + ", " + "centerY=" + this.centerY + ", " + "radius=" + this.radius + ", " + "startAngle=" + this.startAngle + ", " + "segmentAngle=" + this.segmentAngle + ']';
        }
    }
}

