/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.CtxBounds;
import eu.hansolo.fx.charts.tools.FontMetrix;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.Point;
import eu.hansolo.fx.charts.tools.SortDirection;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.fx.geometry.Path;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class StreamChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color DEFAULT_ITEM_COLOR = Color.rgb((int)164, (int)164, (int)164);
    private static final Color DEFAULT_SELECTION_COLOR = Color.rgb((int)128, (int)0, (int)0, (double)0.25);
    private static final Color UNSELECTED_COLOR = Color.rgb((int)128, (int)128, (int)128, (double)0.2);
    private static final int DEFAULT_ITEM_WIDTH = 80;
    private static final int DEFAULT_NODE_GAP = 20;
    private static final double DEFAULT_OPACITY = 0.55;
    private static final int MAX_ITEM_WIDTH = 100;
    private double size;
    private double width;
    private double height;
    private double reducedHeight;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Category _category;
    private ObjectProperty<Category> category;
    private Type _type;
    private ObjectProperty<Type> type;
    private ObservableList<ChartItem> items = FXCollections.observableArrayList();
    private Map<LocalDate, List<ChartItem>> chartItems = new LinkedHashMap<LocalDate, List<ChartItem>>();
    private Map<Integer, List<ChartItemData>> itemsPerCategory = new LinkedHashMap<Integer, List<ChartItemData>>();
    private Map<Integer, Double> sumsPerCategory = new LinkedHashMap<Integer, Double>();
    private ItemEventListener itemListener = e -> this.redraw();
    private ListChangeListener<ChartItem> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.setOnItemEvent(this.itemListener));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeItemEventListener(this.itemListener));
        }
        this.groupBy(this.getCategory());
    };
    private double scaleY;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private boolean _autoTextColor;
    private BooleanProperty autoTextColor;
    private Color _categoryTextColor;
    private ObjectProperty<Color> categoryTextColor;
    private Color _selectionColor;
    private ObjectProperty<Color> selectionColor;
    private int _itemWidth;
    private IntegerProperty itemWidth;
    private boolean _autoItemWidth;
    private BooleanProperty autoItemWidth;
    private int _itemGap;
    private IntegerProperty itemGap;
    private boolean _autoItemGap;
    private BooleanProperty autoItemGap;
    private int _decimals;
    private IntegerProperty decimals;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private double _itemTextThreshold;
    private DoubleProperty itemTextThreshold;
    private boolean _itemTextVisible;
    private BooleanProperty itemTextVisible;
    private SortDirection _sortDirection;
    private ObjectProperty<SortDirection> sortDirection;
    private boolean _sortByName;
    private BooleanProperty sortByName;
    private boolean _categorySumVisible;
    private BooleanProperty categorySumVisible;
    private String formatString;
    private Font itemFont;
    private Font categoryFont;
    private FontMetrix itemFontMetrix;
    private List<Path> selectedPaths;
    private Map<Path, ChartItem> bezierPaths;
    private TooltipPopup popup;

    public StreamChart() {
        this(Category.DAY, Type.STACKED, new ArrayList<ChartItem>());
    }

    public StreamChart(Category CATEGORY, ChartItem ... ITEMS) {
        this(CATEGORY, Type.STACKED, Arrays.asList(ITEMS));
    }

    public StreamChart(Type TYPE, ChartItem ... ITEMS) {
        this(Category.DAY, TYPE, Arrays.asList(ITEMS));
    }

    public StreamChart(Category CATEGORY, List<ChartItem> ITEMS) {
        this(CATEGORY, Type.STACKED, ITEMS);
    }

    public StreamChart(Category CATEGORY, Type TYPE, List<ChartItem> ITEMS) {
        this._category = CATEGORY;
        this._type = TYPE;
        this._textColor = Color.BLACK;
        this._autoTextColor = false;
        this._categoryTextColor = Color.BLACK;
        this._selectionColor = DEFAULT_SELECTION_COLOR;
        this._itemWidth = 80;
        this._autoItemWidth = true;
        this._itemGap = 20;
        this._autoItemGap = true;
        this._decimals = 0;
        this._locale = Locale.getDefault();
        this._itemTextThreshold = 1.0;
        this._itemTextVisible = true;
        this._sortDirection = SortDirection.ASCENDING;
        this._sortByName = false;
        this._categorySumVisible = false;
        this.itemFont = Fonts.latoRegular(10.0);
        this.categoryFont = Fonts.latoRegular(10.0);
        this.itemFontMetrix = new FontMetrix(this.itemFont);
        this.formatString = "%." + this._decimals + "f";
        this.selectedPaths = new LinkedList<Path>();
        this.bezierPaths = new LinkedHashMap<Path, ChartItem>();
        this.popup = new TooltipPopup(2000L);
        this.items.setAll((Collection)(ITEMS == null ? new ArrayList() : ITEMS));
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.popup.setOnHiding(e -> this.popup.setText(""));
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMouseMoved(e -> this.bezierPaths.forEach((path, chartItem) -> {
            String tooltipText;
            double eventY;
            double eventX = e.getX();
            if (path.contains(eventX, eventY = e.getY()) && !(tooltipText = String.valueOf(chartItem.getName()) + ": " + chartItem.getValue()).isEmpty()) {
                this.popup.setX(e.getScreenX() - this.popup.getWidth() * 0.5);
                this.popup.setY(e.getScreenY() - 30.0);
                this.popup.setText(tooltipText);
                this.popup.animatedShow(this.getScene().getWindow());
            }
        }));
        this.canvas.setOnMousePressed(e -> {
            if (Type.CENTERED == this.getType()) {
                return;
            }
            this.selectedPaths.clear();
            this.bezierPaths.forEach((path, chartItem) -> {
                double eventY;
                double eventX = e.getX();
                if (path.contains(eventX, eventY = e.getY())) {
                    chartItem.fireItemEvent(new ItemEvent<ChartItem>((ChartItem)chartItem, EventType.SELECTED));
                    this.selectedPaths.addAll(this.bezierPaths.entrySet().parallelStream().filter(entry -> ((ChartItem)entry.getValue()).getName().equals(chartItem.getName())).collect(Collectors.toList()).stream().map(entry -> (Path)entry.getKey()).collect(Collectors.toList()));
                    this.redraw();
                }
            });
        });
        this.canvas.setOnMouseReleased(e -> {
            if (Type.CENTERED == this.getType()) {
                return;
            }
            this.selectedPaths.clear();
            this.redraw();
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public Category getCategory() {
        return this.category == null ? this._category : (Category)((Object)this.category.get());
    }

    public void setCategory(Category CATEGORY) {
        if (this.category == null) {
            this._category = CATEGORY;
            this.redraw();
        } else {
            this.category.set((Object)CATEGORY);
        }
    }

    public ObjectProperty<Category> categoryProperty() {
        if (this.category == null) {
            this.category = new ObjectPropertyBase<Category>(this._category){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "category";
                }
            };
            this._category = null;
        }
        return this.category;
    }

    public Type getType() {
        return this.type == null ? this._type : (Type)((Object)this.type.get());
    }

    public void setType(Type TYPE) {
        if (this.type == null) {
            this._type = TYPE;
            this.prepareData();
        } else {
            this.type.set((Object)TYPE);
        }
    }

    public ObjectProperty<Type> typeProperty() {
        if (this.type == null) {
            this.type = new ObjectPropertyBase<Type>(this._type){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "type";
                }
            };
            this._type = null;
        }
        return this.type;
    }

    public List<ChartItem> getItems() {
        return this.items;
    }

    public void setItems(ChartItem ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<ChartItem> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(ChartItem ITEM) {
        if (!this.items.contains((Object)ITEM)) {
            this.items.add((Object)ITEM);
        }
    }

    public void removeItem(ChartItem ITEM) {
        if (this.items.contains((Object)ITEM)) {
            this.items.remove((Object)ITEM);
        }
    }

    public Color getTextColor() {
        return this.textColor == null ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (this.textColor == null) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (this.textColor == null) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor == null ? this._selectionColor : (Color)this.selectionColor.get();
    }

    public void setSelectionColor(Color COLOR) {
        if (this.selectionColor == null) {
            this._selectionColor = COLOR;
            this.redraw();
        } else {
            this.selectionColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectionColorProperty() {
        if (this.selectionColor == null) {
            this.selectionColor = new ObjectPropertyBase<Color>(this._selectionColor){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "selectionColor";
                }
            };
            this._selectionColor = null;
        }
        return this.selectionColor;
    }

    public Color getCategoryTextColor() {
        return this.categoryTextColor == null ? this._categoryTextColor : (Color)this.categoryTextColor.get();
    }

    public void setCategoryTextColor(Color COLOR) {
        if (this.categoryTextColor == null) {
            this._categoryTextColor = COLOR;
            this.redraw();
        } else {
            this.categoryTextColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> categoryTextColorProperty() {
        if (this.categoryTextColor == null) {
            this.categoryTextColor = new ObjectPropertyBase<Color>(this._categoryTextColor){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "categoryTextColor";
                }
            };
            this._categoryTextColor = null;
        }
        return this.categoryTextColor;
    }

    public boolean isAutoTextColor() {
        return this.autoTextColor == null ? this._autoTextColor : this.autoTextColor.get();
    }

    public void setAutoTextColor(boolean AUTO) {
        if (this.autoTextColor == null) {
            this._autoTextColor = AUTO;
            this.redraw();
        } else {
            this.autoTextColor.set(AUTO);
        }
    }

    public BooleanProperty autoTextColorProperty() {
        if (this.autoTextColor == null) {
            this.autoTextColor = new BooleanPropertyBase(this._autoTextColor){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "autoTextColor";
                }
            };
        }
        return this.autoTextColor;
    }

    public int getItemWidth() {
        return this.itemWidth == null ? this._itemWidth : this.itemWidth.get();
    }

    public void setItemWidth(int WIDTH) {
        if (this.itemWidth == null) {
            this._itemWidth = Helper.clamp(2, 100, WIDTH);
            this.prepareData();
        } else {
            this.itemWidth.set(WIDTH);
        }
    }

    public IntegerProperty itemWidthProperty() {
        if (this.itemWidth == null) {
            this.itemWidth = new IntegerPropertyBase(this._itemWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(2, 100, this.get()));
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "itemWidth";
                }
            };
        }
        return this.itemWidth;
    }

    public boolean isAutoItemWidth() {
        return this.autoItemWidth == null ? this._autoItemWidth : this.autoItemWidth.get();
    }

    public void setAutoItemWidth(boolean AUTO) {
        if (this.autoItemWidth == null) {
            this._autoItemWidth = AUTO;
            this.prepareData();
        } else {
            this.autoItemWidth.set(AUTO);
        }
    }

    public BooleanProperty autoItemWidthProperty() {
        if (this.autoItemWidth == null) {
            this.autoItemWidth = new BooleanPropertyBase(this._autoItemWidth){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "autoItemWidth";
                }
            };
        }
        return this.autoItemWidth;
    }

    public int getItemGap() {
        return this.itemGap == null ? this._itemGap : this.itemGap.get();
    }

    public void setItemGap(int GAP) {
        if (this.itemGap == null) {
            this._itemGap = Helper.clamp(0, 100, GAP);
            this.prepareData();
        } else {
            this.itemGap.set(GAP);
        }
    }

    public IntegerProperty itemGapProperty() {
        if (this.itemGap == null) {
            this.itemGap = new IntegerPropertyBase(this._itemGap){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 100, this.get()));
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "itemGap";
                }
            };
        }
        return this.itemGap;
    }

    public boolean isAutoItemGap() {
        return this.autoItemGap == null ? this._autoItemGap : this.autoItemGap.get();
    }

    public void setAutoItemGap(boolean AUTO) {
        if (this.autoItemGap == null) {
            this._autoItemGap = AUTO;
            this.prepareData();
        } else {
            this.autoItemGap.set(AUTO);
        }
    }

    public BooleanProperty autoItemGapProperty() {
        if (this.autoItemGap == null) {
            this.autoItemGap = new BooleanPropertyBase(this._autoItemGap){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "autoItemGap";
                }
            };
        }
        return this.autoItemGap;
    }

    public int getDecimals() {
        return this.decimals == null ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (this.decimals == null) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (this.decimals == null) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    StreamChart.this.formatString = "%." + this.get() + "f";
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public Locale getLocale() {
        return this.locale == null ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (this.locale == null) {
            this._locale = LOCALE;
            this.prepareData();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (this.locale == null) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    StreamChart.this.prepareData();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public double getItemTextThreshold() {
        return this.itemTextThreshold == null ? this._itemTextThreshold : this.itemTextThreshold.get();
    }

    public void setItemTextThreshold(double ITEM_TEXT_THRESHOLD) {
        if (this.itemTextThreshold == null) {
            this._itemTextThreshold = Helper.clamp(1.0, Double.MAX_VALUE, ITEM_TEXT_THRESHOLD);
            this.redraw();
        } else {
            this.itemTextThreshold.set(ITEM_TEXT_THRESHOLD);
        }
    }

    public DoubleProperty itemTextThresholdProperty() {
        if (this.itemTextThreshold == null) {
            this.itemTextThreshold = new DoublePropertyBase(this._itemTextThreshold){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, Double.MAX_VALUE, this.get()));
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "textItemThreshold";
                }
            };
        }
        return this.itemTextThreshold;
    }

    public boolean isItemTextVisible() {
        return this.itemTextVisible == null ? this._itemTextVisible : this.itemTextVisible.get();
    }

    public void setItemTextVisible(boolean VISIBLE) {
        if (this.itemTextVisible == null) {
            this._itemTextVisible = VISIBLE;
            this.redraw();
        } else {
            this.itemTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty itemTextVisibleProperty() {
        if (this.itemTextVisible == null) {
            this.itemTextVisible = new BooleanPropertyBase(this._itemTextVisible){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "itemTextVisible";
                }
            };
        }
        return this.itemTextVisible;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection == null ? this._sortDirection : (SortDirection)((Object)this.sortDirection.get());
    }

    public void setSortDirection(SortDirection DIRECTION) {
        if (this.sortDirection == null) {
            this._sortDirection = DIRECTION;
            this.groupBy(this.getCategory());
        } else {
            this.sortDirection.set((Object)DIRECTION);
        }
    }

    public ObjectProperty<SortDirection> sortDirectionProperty() {
        if (this.sortDirection == null) {
            this.sortDirection = new ObjectPropertyBase<SortDirection>(this._sortDirection){

                protected void invalidated() {
                    StreamChart.this.groupBy(StreamChart.this.getCategory());
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "sortDirection";
                }
            };
            this._sortDirection = null;
        }
        return this.sortDirection;
    }

    public boolean isSortByName() {
        return this.sortByName == null ? this._sortByName : this.sortByName.get();
    }

    public void setSortByName(boolean BY_NAME) {
        if (this.sortByName == null) {
            this._sortByName = BY_NAME;
            this.groupBy(this.getCategory());
        } else {
            this.sortByName.set(BY_NAME);
        }
    }

    public BooleanProperty sortByNameProperty() {
        if (this.sortByName == null) {
            this.sortByName = new BooleanPropertyBase(this._sortByName){

                protected void invalidated() {
                    StreamChart.this.groupBy(StreamChart.this.getCategory());
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "sortByName";
                }
            };
        }
        return this.sortByName;
    }

    public boolean isCategorySumVisible() {
        return this.categorySumVisible == null ? this._categorySumVisible : this.categorySumVisible.get();
    }

    public void setCategorySumVisible(boolean VISIBLE) {
        if (this.categorySumVisible == null) {
            this._categorySumVisible = VISIBLE;
            this.redraw();
        } else {
            this.categorySumVisible.set(VISIBLE);
        }
    }

    public BooleanProperty categorySumVisibleProperty() {
        if (this.categorySumVisible == null) {
            this.categorySumVisible = new BooleanPropertyBase(this._categorySumVisible){

                protected void invalidated() {
                    StreamChart.this.redraw();
                }

                public Object getBean() {
                    return StreamChart.this;
                }

                public String getName() {
                    return "categorySumVisible";
                }
            };
        }
        return this.categorySumVisible;
    }

    public void groupBy(Category CATEGORY) {
        this.chartItems.clear();
        Map<LocalDate, List<ChartItem>> groupedItems = this.items.stream().collect(Collectors.groupingBy(item -> item.getTimestampAsLocalDate().with(CATEGORY.adjuster())));
        Map sorted = groupedItems.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        sorted.entrySet().stream().forEach(entry -> {
            LinkedHashMap<String, ChartItem> compactedItems = new LinkedHashMap<String, ChartItem>();
            for (ChartItem item : (List)entry.getValue()) {
                if (compactedItems.keySet().contains(item.getName())) {
                    ((ChartItem)compactedItems.get(item.getName())).setValue(((ChartItem)compactedItems.get(item.getName())).getValue() + item.getValue());
                    continue;
                }
                compactedItems.put(item.getName(), item);
            }
            ArrayList<ChartItem> compacted = new ArrayList<ChartItem>(compactedItems.values());
            switch (this.getSortDirection()) {
                case ASCENDING: {
                    this.sortItemsAscending(compacted);
                    break;
                }
                case DESCENDING: {
                    this.sortItemsDescending(compacted);
                }
            }
            this.chartItems.put((LocalDate)entry.getKey(), compacted);
        });
        this.prepareData();
    }

    private void sortItemsAscending(List<ChartItem> ITEMS) {
        if (this.isSortByName()) {
            Collections.sort(ITEMS, Comparator.comparing(ChartItem::getName));
        } else {
            Collections.sort(ITEMS);
        }
    }

    private void sortItemsDescending(List<ChartItem> ITEMS) {
        if (this.isSortByName()) {
            Collections.sort(ITEMS, Comparator.comparing(ChartItem::getName).reversed());
        } else {
            Collections.sort(ITEMS, Collections.reverseOrder());
        }
    }

    public double getSumOfItems() {
        return this.items.stream().mapToDouble(ChartItem::getValue).sum();
    }

    private void prepareData() {
        if (this.chartItems.isEmpty()) {
            return;
        }
        Type type = this.getType();
        this.itemsPerCategory.clear();
        int cat = this.chartItems.size() - 1;
        for (LocalDate key : this.chartItems.keySet()) {
            ArrayList itemDataList = new ArrayList();
            this.chartItems.get(key).forEach(item -> {
                boolean bl = itemDataList.add(new ChartItemData((ChartItem)item));
            });
            this.itemsPerCategory.put(cat, itemDataList);
            --cat;
        }
        int noOfCategories = this.chartItems.size();
        this.chartItems.forEach((localDate, items) -> Collections.reverse(items));
        double maxSum = this.chartItems.entrySet().stream().mapToDouble(entry -> ((List)entry.getValue()).stream().mapToDouble(ChartItem::getValue).sum()).max().getAsDouble();
        int maxItems = this.chartItems.entrySet().stream().mapToInt(entry -> ((List)entry.getValue()).size()).reduce(0, Integer::max);
        this.sumsPerCategory.clear();
        double itemWidth = this.isAutoItemWidth() ? this.size * 0.1 : (double)this.getItemWidth();
        double verticalGap = this.isAutoItemGap() ? this.size * 0.005 : (double)this.getItemGap();
        double horizontalGap = (this.width - itemWidth) / (double)(this.chartItems.keySet().size() - 1);
        this.scaleY = (this.reducedHeight - (double)(maxItems - 1) * verticalGap) / maxSum;
        int category = 0;
        while (category < noOfCategories) {
            double spacerY = 0.0;
            double spacerX = horizontalGap * (double)category;
            double sum = 0.0;
            for (ChartItemData itemData : this.itemsPerCategory.get(category)) {
                ChartItem item2 = itemData.getChartItem();
                double itemHeight = item2.getValue() * this.scaleY;
                double textOffsetX = 2.0;
                itemData.setBounds(spacerX, this.reducedHeight - itemHeight - spacerY, itemWidth, itemHeight);
                itemData.setTextPoint(spacerX + textOffsetX, this.reducedHeight - itemHeight - spacerY + this.ctx.getFont().getSize());
                if (Type.STACKED == type) {
                    spacerY += itemHeight + verticalGap;
                }
                sum += item2.getValue();
            }
            this.sumsPerCategory.put(category, sum);
            ++category;
        }
        this.createPaths();
        this.redraw();
    }

    private <K, V> K getKeyByValue(Map<K, V> MAP, V VALUE) {
        return (K)MAP.keySet().stream().filter(key -> VALUE.equals(MAP.get(key))).findFirst().get();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.reducedHeight = this.height - this.height * 0.05;
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
            this.itemFont = Fonts.latoRegular(Helper.clamp(8.0, 20.0, this.size * 0.025));
            this.categoryFont = Fonts.latoRegular(Helper.clamp(8.0, 20.0, this.size * 0.025));
            this.itemFontMetrix = new FontMetrix(this.itemFont);
            this.groupBy(this.getCategory());
        }
    }

    private void createPaths() {
        this.bezierPaths.clear();
        int noOfCategories = this.chartItems.size();
        Type type = this.getType();
        double halfItemWidth = (double)this.getItemWidth() * 0.5;
        double offsetY = Type.STACKED == type ? 0.0 : this.height * 0.5;
        int category = 0;
        while (category < noOfCategories) {
            List<ChartItemData> itemDataInCategory = this.itemsPerCategory.get(category);
            int nextCategory = category + 1;
            if (itemDataInCategory != null) {
                for (ChartItemData itemData : itemDataInCategory) {
                    Optional<ChartItemData> targetItemDataOptional;
                    List<ChartItemData> nextCategoryItemDataList;
                    ChartItem item = itemData.getChartItem();
                    CtxBounds bounds = itemData.getBounds();
                    if (category >= noOfCategories || (nextCategoryItemDataList = this.itemsPerCategory.get(nextCategory)) == null || !(targetItemDataOptional = nextCategoryItemDataList.stream().filter(id -> {
                        if (id.getChartItem().getName() == null || item.getName() == null) {
                            return false;
                        }
                        return id.getChartItem().getName().equals(item.getName());
                    }).findFirst()).isPresent()) continue;
                    ChartItemData targetItemData = targetItemDataOptional.get();
                    CtxBounds targetItemBounds = targetItemData.getBounds();
                    double ctrlPointOffsetX = (targetItemBounds.getMinX() - bounds.getMaxX()) * 0.5;
                    Path path = new Path();
                    path.setFill((Paint)item.getFill());
                    path.setStroke((Paint)item.getFill());
                    if (Type.STACKED == type) {
                        path.moveTo(bounds.getCenterX(), bounds.getMinY());
                        path.lineTo(bounds.getCenterX() + halfItemWidth, bounds.getMinY());
                        path.bezierCurveTo(bounds.getCenterX() + halfItemWidth + ctrlPointOffsetX, bounds.getMinY(), targetItemBounds.getCenterX() - halfItemWidth - ctrlPointOffsetX, targetItemBounds.getMinY(), targetItemBounds.getCenterX() - halfItemWidth, targetItemBounds.getMinY());
                        path.lineTo(targetItemBounds.getCenterX(), targetItemBounds.getMinY());
                        path.lineTo(targetItemBounds.getCenterX(), targetItemBounds.getMaxY());
                        path.lineTo(targetItemBounds.getCenterX() - halfItemWidth, targetItemBounds.getMaxY());
                        path.bezierCurveTo(targetItemBounds.getCenterX() - halfItemWidth - ctrlPointOffsetX, targetItemBounds.getMaxY(), bounds.getCenterX() + halfItemWidth + ctrlPointOffsetX, bounds.getMaxY(), bounds.getCenterX() + halfItemWidth, bounds.getMaxY());
                        path.lineTo(bounds.getCenterX(), bounds.getMaxY());
                        path.lineTo(bounds.getCenterX(), bounds.getMinY());
                        path.closePath();
                    } else {
                        double halfItemHeight = bounds.getHeight() * 0.5;
                        double halfTargetItemHeight = targetItemBounds.getHeight() * 0.5;
                        path.moveTo(bounds.getCenterX(), offsetY - halfItemHeight);
                        path.lineTo(bounds.getCenterX() + halfItemWidth, offsetY - halfItemHeight);
                        path.bezierCurveTo(bounds.getCenterX() + halfItemWidth + ctrlPointOffsetX, offsetY - halfItemHeight, targetItemBounds.getCenterX() - halfItemWidth - ctrlPointOffsetX, offsetY - halfTargetItemHeight, targetItemBounds.getCenterX() - halfItemWidth, offsetY - halfTargetItemHeight);
                        path.lineTo(targetItemBounds.getCenterX(), offsetY - halfTargetItemHeight);
                        path.lineTo(targetItemBounds.getCenterX(), offsetY + halfTargetItemHeight);
                        path.lineTo(targetItemBounds.getCenterX() - halfItemWidth, offsetY + halfTargetItemHeight);
                        path.bezierCurveTo(targetItemBounds.getCenterX() - halfItemWidth - ctrlPointOffsetX, offsetY + halfTargetItemHeight, bounds.getCenterX() + halfItemWidth + ctrlPointOffsetX, offsetY + halfItemHeight, bounds.getCenterX() + halfItemWidth, offsetY + halfItemHeight);
                        path.lineTo(bounds.getCenterX(), offsetY + halfItemHeight);
                        path.lineTo(bounds.getCenterX(), offsetY - halfItemHeight);
                        path.closePath();
                    }
                    this.bezierPaths.put(path, item);
                }
            }
            ++category;
        }
    }

    private void redraw() {
        Color textColor = this.getTextColor();
        boolean autoTextColor = this.isAutoTextColor();
        int noOfCategories = this.chartItems.size();
        DateTimeFormatter formatter = this.getCategory().formatter();
        Color selectionColor = this.getSelectionColor();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.selectedPaths.isEmpty()) {
            this.bezierPaths.forEach((path, plotItem) -> path.draw(this.ctx, true, true));
        } else {
            this.bezierPaths.forEach((path, plotItem) -> path.draw(this.ctx, true, (Paint)UNSELECTED_COLOR, false, (Paint)Color.TRANSPARENT));
            this.selectedPaths.forEach(path -> path.draw(this.ctx, true, (Paint)selectionColor, true, (Paint)selectionColor));
        }
        int category = 0;
        while (category < noOfCategories) {
            List<ChartItemData> itemDataInCategory = this.itemsPerCategory.get(category);
            if (itemDataInCategory != null && !itemDataInCategory.isEmpty()) {
                for (ChartItemData itemData : itemDataInCategory) {
                    ChartItem item = itemData.getChartItem();
                    CtxBounds bounds = itemData.getBounds();
                    if (!this.isItemTextVisible() || !(item.getValue() > this.getItemTextThreshold())) continue;
                    this.ctx.setFill((Paint)(autoTextColor ? (Helper.isDark(item.getFill()) ? Color.WHITE : Color.BLACK) : textColor));
                    this.itemFontMetrix.computeStringWidth(item.getName());
                    if (!(this.itemFontMetrix.computeStringWidth(item.getName()) < 100.0) || !(this.itemFontMetrix.getLineHeight() < bounds.getHeight())) continue;
                    if (category == 0) {
                        this.ctx.setTextAlign(TextAlignment.LEFT);
                        this.ctx.fillText(item.getName(), bounds.getCenterX(), bounds.getCenterY());
                        continue;
                    }
                    if (category == noOfCategories - 1) {
                        this.ctx.setTextAlign(TextAlignment.RIGHT);
                        this.ctx.fillText(item.getName(), bounds.getCenterX(), bounds.getCenterY());
                        continue;
                    }
                    this.ctx.setTextAlign(TextAlignment.CENTER);
                    this.ctx.fillText(item.getName(), bounds.getCenterX(), bounds.getCenterY());
                }
                ChartItemData firstItem = itemDataInCategory.get(0);
                this.ctx.setFill((Paint)this.getCategoryTextColor());
                if (this.isCategorySumVisible()) {
                    this.ctx.fillText("\u03a3 " + String.format(this.getLocale(), this.formatString, this.sumsPerCategory.get(category)), firstItem.getBounds().getCenterX(), 15.0, 100.0);
                }
                this.ctx.fillText(formatter.format(firstItem.getLocalDate()), firstItem.getBounds().getCenterX(), this.reducedHeight + this.size * 0.02, 100.0);
            }
            ++category;
        }
    }

    public static enum Category {
        DAY(TemporalAdjusters.ofDateAdjuster(d -> d), DateTimeFormatter.ofPattern("dd MMM YYYY")),
        WEEK(TemporalAdjusters.previousOrSame(DayOfWeek.of(1)), DateTimeFormatter.ofPattern("w")),
        MONTH(TemporalAdjusters.firstDayOfMonth(), DateTimeFormatter.ofPattern("MMM")),
        YEAR(TemporalAdjusters.firstDayOfYear(), DateTimeFormatter.ofPattern("YYYY"));

        private TemporalAdjuster adjuster;
        private DateTimeFormatter formatter;

        private Category(TemporalAdjuster ADJUSTER, DateTimeFormatter FORMATTER) {
            this.adjuster = ADJUSTER;
            this.formatter = FORMATTER;
        }

        public TemporalAdjuster adjuster() {
            return this.adjuster;
        }

        public DateTimeFormatter formatter() {
            return this.formatter;
        }
    }

    private class ChartItemData {
        private ChartItem chartItem;
        private CtxBounds bounds;
        private Point textPoint;
        private double value;

        public ChartItemData(ChartItem ITEM) {
            this.chartItem = ITEM;
            this.bounds = new CtxBounds();
            this.textPoint = new Point();
            this.value = 0.0;
        }

        public ChartItem getChartItem() {
            return this.chartItem;
        }

        public LocalDate getLocalDate() {
            return this.chartItem.getTimestampAsLocalDate(ZoneId.systemDefault());
        }

        public CtxBounds getBounds() {
            return this.bounds;
        }

        public void setBounds(double X, double Y, double WIDTH, double HEIGHT) {
            this.bounds.set(X, Y, WIDTH, HEIGHT);
        }

        public Point getTextPoint() {
            return this.textPoint;
        }

        public void setTextPoint(double X, double Y) {
            this.textPoint.set(X, Y);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double VALUE) {
            this.value = VALUE;
        }
    }

    public static enum Type {
        STACKED,
        CENTERED;

    }
}

