/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.areaheatmap;

import eu.hansolo.fx.charts.data.DataPoint;
import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.ColorMapping;
import eu.hansolo.fx.charts.tools.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class AreaHeatMap
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private List<DataPoint> points = new ArrayList<DataPoint>();
    private List<DataPoint> polygon = new ArrayList<DataPoint>();
    private int _quality;
    private IntegerProperty quality;
    private int _noOfCloserInfluentPoints;
    private IntegerProperty noOfCloserInfluentPoints;
    private double _heatMapOpacity;
    private DoubleProperty heatMapOpacity;
    private boolean _dataPointsVisible;
    private BooleanProperty dataPointsVisible;
    private boolean _discreteColors;
    private BooleanProperty discreteColors;
    private boolean _smoothedHull;
    private BooleanProperty smoothedHull;
    private ColorMapping _mapping;
    private ObjectProperty<ColorMapping> mapping;
    private boolean _useColorMapping;
    private BooleanProperty useColorMapping;
    private double minValue;
    private double maxValue;
    private double range;

    public AreaHeatMap() {
        this(5, Quality.BETTER.getFactor());
    }

    public AreaHeatMap(Quality QUALITY) {
        this(5, QUALITY.getFactor());
    }

    public AreaHeatMap(int QUALITY) {
        this(5, QUALITY);
    }

    public AreaHeatMap(int NO_OF_CLOSER_INFLUENT_POINTS, int QUALITY) {
        this._quality = QUALITY;
        this._noOfCloserInfluentPoints = NO_OF_CLOSER_INFLUENT_POINTS;
        this._heatMapOpacity = 0.5;
        this._dataPointsVisible = false;
        this._discreteColors = false;
        this._smoothedHull = false;
        this._mapping = ColorMapping.BLUE_CYAN_GREEN_YELLOW_RED;
        this._useColorMapping = true;
        this.minValue = Double.MAX_VALUE;
        this.maxValue = -1.7976931348623157E308;
        this.range = this.maxValue - this.minValue;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public int getQuality() {
        return this.quality == null ? this._quality : this.quality.get();
    }

    public void setQuality(Quality QUALITY) {
        this.setQuality(QUALITY.getFactor());
    }

    public void setQuality(int QUALITY) {
        if (this.quality == null) {
            this._quality = Helper.clamp(2, 32, QUALITY);
            this.redraw();
        } else {
            this.quality.set(QUALITY);
        }
    }

    public IntegerProperty qualityProperty() {
        if (this.quality == null) {
            this.quality = new IntegerPropertyBase(this._quality){

                protected void invalidated() {
                    this.set(Helper.clamp(2, 32, this.get()));
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "quality";
                }
            };
        }
        return this.quality;
    }

    public int getNoOfCloserInfluentPoints() {
        return this.noOfCloserInfluentPoints == null ? this._noOfCloserInfluentPoints : this.noOfCloserInfluentPoints.get();
    }

    public void setNoOfCloserInfluentPoints(int NUMBER_OF_POINTS) {
        if (this.noOfCloserInfluentPoints == null) {
            this._noOfCloserInfluentPoints = Helper.clamp(1, 10, NUMBER_OF_POINTS);
            this.redraw();
        } else {
            this.noOfCloserInfluentPoints.set(NUMBER_OF_POINTS);
        }
    }

    public IntegerProperty noOfCloserInfluentPointsProperty() {
        if (this.noOfCloserInfluentPoints == null) {
            this.noOfCloserInfluentPoints = new IntegerPropertyBase(this._noOfCloserInfluentPoints){

                protected void invalidated() {
                    this.set(Helper.clamp(1, 10, this.get()));
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "noOfCloserInfluentPoints";
                }
            };
        }
        return this.noOfCloserInfluentPoints;
    }

    public double getHeatMapOpacity() {
        return this.heatMapOpacity == null ? this._heatMapOpacity : this.heatMapOpacity.get();
    }

    public void setHeatMapOpacity(double OPACITY) {
        if (this.heatMapOpacity == null) {
            this._heatMapOpacity = Helper.clamp(0.0, 1.0, OPACITY);
            this.redraw();
        } else {
            this.heatMapOpacity.set(OPACITY);
        }
    }

    public DoubleProperty heatMapOpacityProperty() {
        if (this.heatMapOpacity == null) {
            this.heatMapOpacity = new DoublePropertyBase(this._heatMapOpacity){

                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 1.0, this.get()));
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "heatMapOpacity";
                }
            };
        }
        return this.heatMapOpacity;
    }

    public boolean getShowDataPoints() {
        return this.dataPointsVisible == null ? this._dataPointsVisible : this.dataPointsVisible.get();
    }

    public void setDataPointsVisible(boolean VISIBLE) {
        if (this.dataPointsVisible == null) {
            this._dataPointsVisible = VISIBLE;
            this.redraw();
        } else {
            this.dataPointsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty dataPointsVisibleProperty() {
        if (this.dataPointsVisible == null) {
            this.dataPointsVisible = new BooleanPropertyBase(this._dataPointsVisible){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "dataPointsVisible";
                }
            };
        }
        return this.dataPointsVisible;
    }

    public boolean isSmoothedHull() {
        return this.smoothedHull == null ? this._smoothedHull : this.smoothedHull.get();
    }

    public void setSmoothedHull(boolean SMOOTHED) {
        if (this.smoothedHull == null) {
            this._smoothedHull = SMOOTHED;
            this.createHullPolygon();
            this.redraw();
        } else {
            this.smoothedHull.set(SMOOTHED);
        }
    }

    public BooleanProperty smoothedHullProperty() {
        if (this.smoothedHull == null) {
            this.smoothedHull = new BooleanPropertyBase(this._smoothedHull){

                protected void invalidated() {
                    AreaHeatMap.this.createHullPolygon();
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "smoothedHull";
                }
            };
        }
        return this.smoothedHull;
    }

    public boolean isDiscreteColors() {
        return this.discreteColors == null ? this._discreteColors : this.discreteColors.get();
    }

    public void setDiscreteColors(boolean DISCRETE) {
        if (this.discreteColors == null) {
            this._discreteColors = DISCRETE;
            this.redraw();
        } else {
            this.discreteColors.set(DISCRETE);
        }
    }

    public BooleanProperty discreteColorsProperty() {
        if (this.discreteColors == null) {
            this.discreteColors = new BooleanPropertyBase(this._discreteColors){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "discreteColors";
                }
            };
        }
        return this.discreteColors;
    }

    public ColorMapping getMapping() {
        return this.mapping == null ? this._mapping : (ColorMapping)((Object)this.mapping.get());
    }

    public void setColorMapping(ColorMapping MAPPING) {
        if (this.mapping == null) {
            this._mapping = MAPPING;
            this.redraw();
        } else {
            this.mapping.set((Object)MAPPING);
        }
    }

    public ObjectProperty<ColorMapping> mappingProperty() {
        if (this.mapping == null) {
            this.mapping = new ObjectPropertyBase<ColorMapping>(this._mapping){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "mapping";
                }
            };
            this._mapping = null;
        }
        return this.mapping;
    }

    public boolean getUseColorMapping() {
        return this.useColorMapping == null ? this._useColorMapping : this.useColorMapping.get();
    }

    public void setUseColorMapping(boolean USE) {
        if (this.useColorMapping == null) {
            this._useColorMapping = USE;
            this.redraw();
        } else {
            this.useColorMapping.set(USE);
        }
    }

    public BooleanProperty useColorMapping() {
        if (this.useColorMapping == null) {
            this.useColorMapping = new BooleanPropertyBase(this._useColorMapping){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "useColorMapping";
                }
            };
        }
        return this.useColorMapping;
    }

    public void setDataPoints(DataPoint ... POINTS) {
        this.setDataPoints(Arrays.asList(POINTS));
    }

    public void setDataPoints(List<DataPoint> POINTS) {
        this.minValue = POINTS.stream().mapToDouble(DataPoint::getValue).min().getAsDouble();
        this.maxValue = POINTS.stream().mapToDouble(DataPoint::getValue).max().getAsDouble();
        this.range = this.maxValue - this.minValue;
        this.points.clear();
        this.points.addAll(POINTS);
        this.createHullPolygon();
        this.redraw();
    }

    private Color getColorForValue(double VALUE, boolean LEVELS) {
        double limit = 0.55;
        double min = -30.0;
        double max = 50.0;
        double delta = max - min;
        double levels = 25.0;
        double value = Helper.clamp(min, max, VALUE);
        double tmp = 1.0 - (1.0 - limit) - (value - min) * limit / delta;
        if (LEVELS) {
            tmp = (double)Math.round(tmp * levels) / levels;
        }
        return Helper.hslToRGB(tmp, 1.0, 0.5);
    }

    private Color getColorForValue(double VALUE) {
        return this.getColorForValue(VALUE, this.getHeatMapOpacity());
    }

    private Color getColorForValue(double VALUE, double OPACITY) {
        return Helper.getColorWithOpacityAt(this.getMapping().getGradient(), (VALUE - this.minValue) / this.range, OPACITY);
    }

    private void createHullPolygon() {
        this.polygon.clear();
        if (this.isSmoothedHull()) {
            List<DataPoint> p = Helper.createSmoothedHull(this.points, 16);
            this.polygon.addAll(p);
        } else {
            this.polygon.addAll(Helper.createHull(this.points));
        }
    }

    private double getValueAt(int LIMIT, double X, double Y) {
        ArrayList<Number[]> arr = new ArrayList<Number[]>();
        double t = 0.0;
        double b = 0.0;
        if (Helper.isInPolygon(X, Y, this.polygon)) {
            int counter = 0;
            while (counter < this.points.size()) {
                DataPoint point = this.points.get(counter);
                double distance = Helper.squareDistance(X, Y, point.getX(), point.getY());
                if (Double.compare(distance, 0.0) == 0) {
                    return point.getValue();
                }
                arr.add(counter, new Number[]{distance, counter});
                ++counter;
            }
            arr.sort(Comparator.comparingInt(n -> n[0].intValue()));
            counter = 0;
            while (counter < LIMIT) {
                Number[] ptr = (Number[])arr.get(counter);
                double inv = 1.0 / Math.pow(ptr[0].intValue(), 2.0);
                t += inv * this.points.get(ptr[1].intValue()).getValue();
                b += inv;
                ++counter;
            }
            return t / b;
        }
        return -255.0;
    }

    private void draw(int LIMIT, double RESOLUTION) {
        int limit = LIMIT > this.points.size() ? this.points.size() : LIMIT + 1;
        double pixelSize = 2.0 * RESOLUTION;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        double y = 0.0;
        while (y < this.height) {
            double x = 0.0;
            while (x < this.width) {
                double value = this.getValueAt(limit, x, y);
                if (value != -255.0) {
                    Color color = this.getUseColorMapping() ? this.getColorForValue(value) : this.getColorForValue(value, this.isDiscreteColors());
                    RadialGradient gradient = new RadialGradient(0.0, 0.0, x, y, RESOLUTION, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)this.getHeatMapOpacity())), new Stop(1.0, Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)0.0))});
                    this.ctx.setFill((Paint)gradient);
                    this.ctx.fillOval(x - RESOLUTION, y - RESOLUTION, pixelSize, pixelSize);
                }
                x += RESOLUTION;
            }
            y += RESOLUTION;
        }
    }

    private void drawDataPoints() {
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(Fonts.opensansRegular(this.size * 0.0175));
        int i = 0;
        while (i < this.points.size()) {
            DataPoint point = this.points.get(i);
            this.ctx.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.5));
            this.ctx.fillOval(point.getX() - 8.0, point.getY() - 8.0, 16.0, 16.0);
            this.ctx.setStroke((Paint)Color.BLACK);
            this.ctx.strokeOval(point.getX() - 8.0, point.getY() - 8.0, 16.0, 16.0);
            this.ctx.setFill((Paint)Color.BLACK);
            this.ctx.fillText(Long.toString(Math.round(point.getValue())), point.getX(), point.getY(), 16.0);
            ++i;
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.draw(this.getNoOfCloserInfluentPoints(), this.getQuality());
        if (this.getShowDataPoints()) {
            this.drawDataPoints();
        }
    }

    public static enum Quality {
        FINE(2),
        BETTER(4),
        NORMAL(8),
        POOR(16),
        RAW(32);

        private final int FACTOR;

        private Quality(int FACTOR) {
            this.FACTOR = FACTOR;
        }

        public int getFactor() {
            return this.FACTOR;
        }
    }
}

