/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.data.PlotItem;
import eu.hansolo.fx.charts.event.ConnectionEvent;
import eu.hansolo.fx.charts.event.ConnectionEventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class Connection {
    private List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private PlotItem _incomingItem;
    private ObjectProperty<PlotItem> incomingItem;
    private PlotItem _outgoingItem;
    private ObjectProperty<PlotItem> outgoingItem;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private double _value;
    private DoubleProperty value;
    private String _tooltipText;
    private StringProperty tooltipText;

    public Connection(PlotItem INCOMING_ITEM, PlotItem OUTGOING_ITEM, double VALUE, Color FILL) {
        this(INCOMING_ITEM, OUTGOING_ITEM, VALUE, FILL, "");
    }

    public Connection(PlotItem INCOMING_ITEM, PlotItem OUTGOING_ITEM, double VALUE, Color FILL, String TOOLTIP_TEXT) {
        this._incomingItem = INCOMING_ITEM;
        this._outgoingItem = OUTGOING_ITEM;
        this._value = VALUE;
        this._fill = FILL;
        this._tooltipText = TOOLTIP_TEXT;
    }

    public PlotItem getIncomingItem() {
        return this.incomingItem == null ? this._incomingItem : (PlotItem)this.incomingItem.get();
    }

    public void setIncomingItem(PlotItem ITEM1) {
        if (this.incomingItem == null) {
            this._incomingItem = ITEM1;
        } else {
            this.incomingItem.set((Object)ITEM1);
        }
    }

    public ObjectProperty<PlotItem> incomingItemProperty() {
        if (this.incomingItem == null) {
            this.incomingItem = new ObjectPropertyBase<PlotItem>(this._incomingItem){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "item1";
                }
            };
            this._incomingItem = null;
        }
        return this.incomingItem;
    }

    public PlotItem getOutgoingItem() {
        return this.outgoingItem == null ? this._outgoingItem : (PlotItem)this.outgoingItem.get();
    }

    public void setOutgoingItem(PlotItem ITEM2) {
        if (this.outgoingItem == null) {
            this._outgoingItem = ITEM2;
        } else {
            this.outgoingItem.set((Object)ITEM2);
        }
    }

    public ObjectProperty<PlotItem> outgoingItemProperty() {
        if (this.outgoingItem == null) {
            this.outgoingItem = new ObjectPropertyBase<PlotItem>(this._outgoingItem){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "item2";
                }
            };
            this._outgoingItem = null;
        }
        return this.outgoingItem;
    }

    public double getValue() {
        return this.value == null ? this._value : this.value.get();
    }

    public ReadOnlyDoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(this._value){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Color getFill() {
        return this.fill == null ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (this.fill == null) {
            this._fill = FILL;
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public String getTooltipText() {
        return this.tooltipText == null ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String TOOLTIP_TEXT) {
        if (this.tooltipText == null) {
            this._tooltipText = TOOLTIP_TEXT;
        } else {
            this.tooltipText.set((Object)TOOLTIP_TEXT);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (this.tooltipText == null) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "tooltipText";
                }
            };
        }
        return this.tooltipText;
    }

    public void setOnConnectionEvent(ConnectionEventListener LISTENER) {
        this.addConnectionEventListener(LISTENER);
    }

    public void addConnectionEventListener(ConnectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireConnectionEvent(ConnectionEvent EVENT) {
        this.listeners.forEach(listener -> listener.onConnectionEvent(EVENT));
    }
}

