/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.event.EventType;
import eu.hansolo.fx.charts.event.MapConnectionEvent;
import eu.hansolo.fx.charts.event.MapConnectionEventListener;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.MapPoint;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class MapConnection {
    private final MapConnectionEvent SELECTED_EVENT = new MapConnectionEvent<MapConnection>(this, EventType.SELECTED);
    private final MapConnectionEvent UPDATED_EVENT = new MapConnectionEvent<MapConnection>(this, EventType.UPDATE);
    private List<MapConnectionEventListener> listeners = new CopyOnWriteArrayList<MapConnectionEventListener>();
    private MapPoint _incomingItem;
    private ObjectProperty<MapPoint> incomingItem;
    private MapPoint _outgoingItem;
    private ObjectProperty<MapPoint> outgoingItem;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _startColor;
    private ObjectProperty<Color> startColor;
    private Color _endColor;
    private ObjectProperty<Color> endColor;
    private boolean _gradientFill;
    private BooleanProperty gradientFill;
    private double _value;
    private DoubleProperty value;
    private double _lineWidth;
    private DoubleProperty lineWidth;
    private String _tooltipText;
    private StringProperty tooltipText;

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM) {
        this(OUTGOING_ITEM, INCOMING_ITEM, 0.0, Color.BLACK, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, Color STROKE) {
        this(OUTGOING_ITEM, INCOMING_ITEM, 0.0, STROKE, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, STROKE, Color.BLUE, Color.RED, false, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, Color.BLACK, START_COLOR, END_COLOR, GRADIENT_FILL, 1.0, "");
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL, String TOOLTIP_TEXT) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, Color.BLACK, START_COLOR, END_COLOR, GRADIENT_FILL, 1.0, TOOLTIP_TEXT);
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE, String TOOLTIP_TEXT) {
        this(OUTGOING_ITEM, INCOMING_ITEM, VALUE, STROKE, Color.BLUE, Color.RED, false, 1.0, TOOLTIP_TEXT);
    }

    public MapConnection(MapPoint OUTGOING_ITEM, MapPoint INCOMING_ITEM, double VALUE, Color STROKE, Color START_COLOR, Color END_COLOR, boolean GRADIENT_FILL, double LINE_WIDTH, String TOOLTIP_TEXT) {
        this._outgoingItem = OUTGOING_ITEM;
        this._incomingItem = INCOMING_ITEM;
        this._value = VALUE;
        this._stroke = STROKE;
        this._tooltipText = TOOLTIP_TEXT;
        this._startColor = START_COLOR;
        this._endColor = END_COLOR;
        this._gradientFill = GRADIENT_FILL;
        this._lineWidth = Helper.clamp(0.5, 10.0, LINE_WIDTH);
    }

    public MapPoint getIncomingItem() {
        return this.incomingItem == null ? this._incomingItem : (MapPoint)this.incomingItem.get();
    }

    public void setIncomingItem(MapPoint ITEM1) {
        if (this.incomingItem == null) {
            this._incomingItem = ITEM1;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.incomingItem.set((Object)ITEM1);
        }
    }

    public ObjectProperty<MapPoint> incomingItemProperty() {
        if (this.incomingItem == null) {
            this.incomingItem = new ObjectPropertyBase<MapPoint>(this._incomingItem){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "item1";
                }
            };
            this._incomingItem = null;
        }
        return this.incomingItem;
    }

    public MapPoint getOutgoingItem() {
        return this.outgoingItem == null ? this._outgoingItem : (MapPoint)this.outgoingItem.get();
    }

    public void setOutgoingItem(MapPoint ITEM2) {
        if (this.outgoingItem == null) {
            this._outgoingItem = ITEM2;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.outgoingItem.set((Object)ITEM2);
        }
    }

    public ObjectProperty<MapPoint> outgoingItemProperty() {
        if (this.outgoingItem == null) {
            this.outgoingItem = new ObjectPropertyBase<MapPoint>(this._outgoingItem){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "item2";
                }
            };
            this._outgoingItem = null;
        }
        return this.outgoingItem;
    }

    public double getValue() {
        return this.value == null ? this._value : this.value.get();
    }

    public ReadOnlyDoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(this._value){

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Color getStroke() {
        return this.stroke == null ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color FILL) {
        if (this.stroke == null) {
            this._stroke = FILL;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.stroke.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getStartColor() {
        return this.startColor == null ? this._startColor : (Color)this.startColor.get();
    }

    public void setStartColor(Color START_COLOR) {
        if (this.startColor == null) {
            this._startColor = START_COLOR;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.startColor.set((Object)START_COLOR);
        }
    }

    public ObjectProperty<Color> startColorProperty() {
        if (this.startColor == null) {
            this.startColor = new ObjectPropertyBase<Color>(this._startColor){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "startColor";
                }
            };
            this._startColor = null;
        }
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor == null ? this._endColor : (Color)this.endColor.get();
    }

    public void setEndColor(Color END_COLOR) {
        if (this.endColor == null) {
            this._endColor = END_COLOR;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.endColor.set((Object)END_COLOR);
        }
    }

    public ObjectProperty<Color> endColorProperty() {
        if (this.endColor == null) {
            this.endColor = new ObjectPropertyBase<Color>(this._endColor){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "endColor";
                }
            };
            this._endColor = null;
        }
        return this.endColor;
    }

    public boolean getGradientFill() {
        return this.gradientFill == null ? this._gradientFill : this.gradientFill.get();
    }

    public void setGradientFill(boolean GRADIENT_FILL) {
        if (this.gradientFill == null) {
            this._gradientFill = GRADIENT_FILL;
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.gradientFill.set(GRADIENT_FILL);
        }
    }

    public BooleanProperty gradientFillProperty() {
        if (this.gradientFill == null) {
            this.gradientFill = new BooleanPropertyBase(this._gradientFill){

                protected void invalidated() {
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "gradientFill";
                }
            };
        }
        return this.gradientFill;
    }

    public double getLineWidth() {
        return this.lineWidth == null ? this._lineWidth : this.lineWidth.get();
    }

    public void setLineWidth(double LINE_WIDTH) {
        if (this.lineWidth == null) {
            this._lineWidth = Helper.clamp(0.5, 10.0, LINE_WIDTH);
            this.fireMapConnectionEvent(this.UPDATED_EVENT);
        } else {
            this.lineWidth.set(LINE_WIDTH);
        }
    }

    public DoubleProperty lineWidthProperty() {
        if (this.lineWidth == null) {
            this.lineWidth = new DoublePropertyBase(this._lineWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(0.5, 10.0, this.get()));
                    MapConnection.this.fireMapConnectionEvent(MapConnection.this.UPDATED_EVENT);
                }

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "lineWidth";
                }
            };
        }
        return this.lineWidth;
    }

    public String getTooltipText() {
        return this.tooltipText == null ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String TOOLTIP_TEXT) {
        if (this.tooltipText == null) {
            this._tooltipText = TOOLTIP_TEXT;
        } else {
            this.tooltipText.set((Object)TOOLTIP_TEXT);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (this.tooltipText == null) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                public Object getBean() {
                    return MapConnection.this;
                }

                public String getName() {
                    return "tooltipText";
                }
            };
        }
        return this.tooltipText;
    }

    public void setOnMapConnectionEvent(MapConnectionEventListener LISTENER) {
        this.addMapConnectionEventListener(LISTENER);
    }

    public void addMapConnectionEventListener(MapConnectionEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeMapConnectionEventListener(MapConnectionEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireMapConnectionEvent(MapConnectionEvent EVENT) {
        this.listeners.forEach(listener -> listener.onMapConnectionEvent(EVENT));
    }
}

