/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.MatrixItem;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class MatrixChartItem
implements MatrixItem {
    private final ItemEvent ITEM_EVENT = new ItemEvent<MatrixChartItem>(this);
    private CopyOnWriteArrayList<ItemEventListener> listeners;
    private int _x;
    private IntegerProperty x;
    private int _y;
    private IntegerProperty y;
    private double _z;
    private DoubleProperty z;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;

    public MatrixChartItem() {
        this(0, 0, 0.0, "", Color.RED, false);
    }

    public MatrixChartItem(boolean IS_EMPTY) {
        this(0, 0, 0.0, "", Color.RED, IS_EMPTY);
    }

    public MatrixChartItem(int X, int Y, double Z) {
        this(X, Y, Z, "", Color.RED, false);
    }

    public MatrixChartItem(int X, int Y, double Z, boolean IS_EMPTY) {
        this(X, Y, Z, "", Color.RED, IS_EMPTY);
    }

    public MatrixChartItem(int X, int Y, double Z, String NAME) {
        this(X, Y, Z, NAME, Color.RED, false);
    }

    public MatrixChartItem(int X, int Y, double Z, String NAME, boolean IS_EMPTY) {
        this(X, Y, Z, NAME, Color.RED, IS_EMPTY);
    }

    public MatrixChartItem(int X, int Y, double Z, String NAME, Color FILL) {
        this(X, Y, Z, NAME, FILL, false);
    }

    public MatrixChartItem(int X, int Y, double Z, String NAME, Color FILL, boolean IS_EMPTY) {
        this._x = X;
        this._y = Y;
        this._z = Z;
        this._name = NAME;
        this._fill = FILL;
        this._stroke = Color.TRANSPARENT;
        this._symbol = Symbol.NONE;
        this._isEmpty = IS_EMPTY;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    public int getX() {
        return this.x == null ? this._x : this.x.get();
    }

    @Override
    public void setX(int X) {
        if (this.x == null) {
            this._x = X;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.x.set(X);
        }
    }

    @Override
    public IntegerProperty xProperty() {
        if (this.x == null) {
            this.x = new IntegerPropertyBase(this._x){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    @Override
    public int getY() {
        return this.y == null ? this._y : this.y.get();
    }

    @Override
    public void setY(int Y) {
        if (this.y == null) {
            this._y = Y;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.y.set(Y);
        }
    }

    @Override
    public IntegerProperty yProperty() {
        if (this.y == null) {
            this.y = new IntegerPropertyBase(this._y){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z == null ? this._z : this.z.get();
    }

    @Override
    public void setZ(double Z) {
        if (this.z == null) {
            this._z = Z;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.z.set(Z);
        }
    }

    @Override
    public DoubleProperty zProperty() {
        if (this.z == null) {
            this.z = new DoublePropertyBase(this._z){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "z";
                }
            };
        }
        return this.z;
    }

    @Override
    public String getName() {
        return this.name == null ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (this.name == null) {
            this._name = NAME;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (this.name == null) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return this.fill == null ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (this.fill == null) {
            this._fill = FILL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return this.stroke == null ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (this.stroke == null) {
            this._stroke = STROKE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return Symbol.NONE;
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (this.symbol == null) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public boolean isEmptyItem() {
        return this.isEmpty == null ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (this.isEmpty == null) {
            this._isEmpty = isEmpty;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (this.isEmpty == null) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    MatrixChartItem.this.fireItemEvent(MatrixChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return MatrixChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public void setOnItemEvent(ItemEventListener LISTENER) {
        this.addItemEventListener(LISTENER);
    }

    public void addItemEventListener(ItemEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeItemEventListener(ItemEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireItemEvent(ItemEvent EVENT) {
        for (ItemEventListener listener : this.listeners) {
            listener.onItemEvent(EVENT);
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"x\":" + this.getX() + ",\n" + "  \"y\":" + this.getY() + ",\n" + "  \"z\":" + this.getZ() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }
}

