/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.ValueItem;
import eu.hansolo.fx.charts.event.ItemEvent;
import eu.hansolo.fx.charts.event.ItemEventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class ValueChartItem
implements ValueItem,
Comparable<ValueChartItem> {
    private final ItemEvent ITEM_EVENT = new ItemEvent<ValueChartItem>(this);
    private CopyOnWriteArrayList<ItemEventListener> listeners;
    private double _value;
    private DoubleProperty value;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;

    public ValueChartItem() {
        this(0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(boolean IS_EMPTY) {
        this(0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME) {
        this(VALUE, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(double VALUE, String NAME, boolean IS_EMPTY) {
        this(VALUE, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL) {
        this(VALUE, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, boolean IS_EMPTY) {
        this(VALUE, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, Color STROKE, Symbol SYMBOL) {
        this(VALUE, NAME, FILL, STROKE, SYMBOL, false);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, Color STROKE, Symbol SYMBOL, boolean IS_EMPTY) {
        this._value = VALUE;
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._symbol = SYMBOL;
        this._isEmpty = IS_EMPTY;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    public double getValue() {
        return this.value == null ? this._value : this.value.get();
    }

    @Override
    public void setValue(double VALUE) {
        if (this.value == null) {
            this._value = VALUE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.value.set(VALUE);
        }
    }

    @Override
    public DoubleProperty valueProperty() {
        if (this.value == null) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    @Override
    public String getName() {
        return this.name == null ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (this.name == null) {
            this._name = NAME;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (this.name == null) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return this.fill == null ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (this.fill == null) {
            this._fill = FILL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return this.stroke == null ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (this.stroke == null) {
            this._stroke = STROKE;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol == null ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (this.symbol == null) {
            this._symbol = SYMBOL;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (this.symbol == null) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public boolean isEmptyItem() {
        return this.isEmpty == null ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (this.isEmpty == null) {
            this._isEmpty = isEmpty;
            this.fireItemEvent(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (this.isEmpty == null) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    ValueChartItem.this.fireItemEvent(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public void setOnItemEvent(ItemEventListener LISTENER) {
        this.addItemEventListener(LISTENER);
    }

    public void addItemEventListener(ItemEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeItemEventListener(ItemEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void fireItemEvent(ItemEvent EVENT) {
        for (ItemEventListener listener : this.listeners) {
            listener.onItemEvent(EVENT);
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"value\":" + this.getValue() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }

    @Override
    public int compareTo(ValueChartItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }
}

