/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.data.XYItem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Statistics {
    public static final double getXYItemMeanY(List<XYItem> DATA) {
        return Statistics.getMean(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getMean(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).sum() / (double)DATA.size();
    }

    public static final double getXYItemVarianceY(List<XYItem> DATA) {
        return Statistics.getVariance(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getVariance(List<Double> DATA) {
        double mean = Statistics.getMean(DATA);
        double temp = 0.0;
        for (double a : DATA) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)DATA.size();
    }

    public static final double getXYItemStdDevY(List<XYItem> DATA) {
        return Statistics.getStdDev(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getStdDev(List<Double> DATA) {
        return Math.sqrt(Statistics.getVariance(DATA));
    }

    public static final double getXYItemMedianY(List<XYItem> DATA) {
        return Statistics.getMedian(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getMedian(List<Double> DATA) {
        int size = DATA.size();
        Collections.sort(DATA);
        return size % 2 == 0 ? (DATA.get(size / 2 - 1) + DATA.get(size / 2)) / 2.0 : DATA.get(size / 2);
    }

    public static final double getXYItemMinY(List<XYItem> DATA) {
        return Statistics.getMin(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getMin(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).min().orElse(0.0);
    }

    public static final double getXYItemMaxY(List<XYItem> DATA) {
        return Statistics.getMax(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getMax(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).max().orElse(0.0);
    }

    public static final double getXYItemAverageY(List<XYItem> DATA) {
        return Statistics.getAverage(DATA.stream().map(XYItem::getY).collect(Collectors.toList()));
    }

    public static final double getAverage(List<Double> DATA) {
        return DATA.stream().mapToDouble(data -> data).average().orElse(-1.0);
    }

    public static final double percentile(List<Double> entries, double percentile) {
        Collections.sort(entries);
        int index = (int)Math.ceil(percentile / 100.0 * (double)entries.size());
        return entries.get(index - 1);
    }
}

