/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.font.Fonts;
import eu.hansolo.fx.charts.tools.Helper;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class TooltipPopup
extends Popup {
    public static long MAX_TIMEOUT = 10000L;
    public static Color DEFAULT_BACKGROUND_COLOR = Color.rgb((int)0, (int)0, (int)0, (double)0.75);
    public static Color DEFAULT_TEXT_COLOR = Color.WHITE;
    private static final String STYLE_CLASS = "charts-tooltip";
    private StackPane pane;
    private Label tooltipText;
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;
    private PauseTransition delay;
    private Color _backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private ObjectProperty<Color> backgroundColor;
    private long _timeout;
    private LongProperty timeout;

    public TooltipPopup() {
        this("", 4000L);
    }

    public TooltipPopup(String text) {
        this(text, 4000L);
    }

    public TooltipPopup(long timeout) {
        this("", timeout);
    }

    public TooltipPopup(String text, long timeout) {
        this._timeout = timeout;
        this.tooltipText = new Label(text);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        this.setAutoFix(true);
        this.fadeIn = new FadeTransition(Duration.millis((double)200.0), (Node)this.pane);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(0.75);
        this.fadeOut = new FadeTransition(Duration.millis((double)200.0), (Node)this.pane);
        this.fadeOut.setFromValue(0.75);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setOnFinished(e -> this.hide());
        this.delay = new PauseTransition(Duration.millis((double)this._timeout));
        this.delay.setOnFinished(e -> this.animatedHide());
    }

    private void initGraphics() {
        Fonts.opensansRegular(10.0);
        Font lightFont = Fonts.opensansLight(10.0);
        this.tooltipText.setTextFill((Paint)DEFAULT_TEXT_COLOR);
        this.tooltipText.setFont(lightFont);
        this.tooltipText.setMouseTransparent(true);
        this.pane = new StackPane(new Node[]{this.tooltipText});
        this.pane.setPadding(new Insets(5.0));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        this.pane.setMouseTransparent(true);
        this.pane.getStyleClass().add((Object)STYLE_CLASS);
        this.getContent().addAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
    }

    public void animatedShow(Window WINDOW) {
        this.show(WINDOW);
        this.fadeIn.play();
        this.delay.playFromStart();
    }

    public void animatedHide() {
        this.fadeOut.play();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor == null ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (this.backgroundColor == null) {
            this._backgroundColor = COLOR;
            this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (this.backgroundColor == null) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    TooltipPopup.this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.get(), new CornerRadii(3.0), Insets.EMPTY)}));
                }

                public Object getBean() {
                    return TooltipPopup.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Paint getTextFill() {
        return this.tooltipText.getTextFill();
    }

    public void setTextFill(Paint fill) {
        this.tooltipText.setTextFill(fill);
    }

    public ObjectProperty<Paint> textFillProperty() {
        return this.tooltipText.textFillProperty();
    }

    public long getTimeout() {
        return this.timeout == null ? this._timeout : this.timeout.get();
    }

    public void setTimeout(long TIMEOUT) {
        if (this.timeout == null) {
            this._timeout = Helper.clamp(0L, MAX_TIMEOUT, TIMEOUT);
        } else {
            this.timeout.set(TIMEOUT);
        }
    }

    public LongProperty timeoutProperty() {
        if (this.timeout == null) {
            this.timeout = new LongPropertyBase(this._timeout){

                protected void invalidated() {
                    Helper.clamp(0L, MAX_TIMEOUT, this.get());
                }

                public Object getBean() {
                    return TooltipPopup.this;
                }

                public String getName() {
                    return "timeout";
                }
            };
        }
        return this.timeout;
    }

    public String getText() {
        return this.tooltipText.getText();
    }

    public void setText(String text) {
        this.tooltipText.setText(text);
    }

    public StringProperty textProperty() {
        return this.tooltipText.textProperty();
    }
}

