/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry.tools;

import eu.hansolo.fx.geometry.FlatteningPathIterator;
import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.tools.Point;
import eu.hansolo.fx.geometry.transform.Affine;
import java.util.ArrayList;
import java.util.List;

public class PathTool {
    protected Shape path;
    protected List<PathSegment> segments;
    protected int[] segmentIndexes;
    protected double pathLength;
    protected boolean initialized;

    public PathTool(Shape path) {
        this.setPath(path);
    }

    public Shape getPath() {
        return this.path;
    }

    public void setPath(Shape SHAPE) {
        this.path = SHAPE;
        this.initialized = false;
    }

    private void init() {
        this.pathLength = 0.0;
        PathIterator pathIterator = this.path.getPathIterator(new Affine());
        SingleSegmentPathIterator singleSegmentPathIterator = new SingleSegmentPathIterator();
        this.segments = new ArrayList<PathSegment>(20);
        ArrayList<Integer> indexes = new ArrayList<Integer>(20);
        int index = 0;
        int origIndex = -1;
        double lastMoveX = 0.0;
        double lastMoveY = 0.0;
        double currentX = 0.0;
        double currentY = 0.0;
        double[] seg = new double[6];
        this.segments.add(new PathSegment(0, 0.0, 0.0, 0.0, origIndex));
        block5: while (!pathIterator.isDone()) {
            ++origIndex;
            indexes.add(index);
            int segType = pathIterator.currentSegment(seg);
            switch (segType) {
                case 0: {
                    this.segments.add(new PathSegment(segType, seg[0], seg[1], this.pathLength, origIndex));
                    currentX = seg[0];
                    currentY = seg[1];
                    lastMoveX = currentX;
                    lastMoveY = currentY;
                    ++index;
                    pathIterator.next();
                    break;
                }
                case 1: {
                    this.pathLength += Point.distance(currentX, currentY, seg[0], seg[1]);
                    this.segments.add(new PathSegment(segType, seg[0], seg[1], this.pathLength, origIndex));
                    currentX = seg[0];
                    currentY = seg[1];
                    ++index;
                    pathIterator.next();
                    break;
                }
                case 4: {
                    this.pathLength += Point.distance(currentX, currentY, lastMoveX, lastMoveY);
                    this.segments.add(new PathSegment(1, lastMoveX, lastMoveY, this.pathLength, origIndex));
                    currentX = lastMoveX;
                    currentY = lastMoveY;
                    ++index;
                    pathIterator.next();
                    break;
                }
                default: {
                    singleSegmentPathIterator.setPathIterator(pathIterator, currentX, currentY);
                    FlatteningPathIterator fpi = new FlatteningPathIterator(singleSegmentPathIterator, 0.01);
                    while (!fpi.isDone()) {
                        segType = fpi.currentSegment(seg);
                        if (segType == 1) {
                            this.pathLength += Point.distance(currentX, currentY, seg[0], seg[1]);
                            this.segments.add(new PathSegment(segType, seg[0], seg[1], this.pathLength, origIndex));
                            currentX = seg[0];
                            currentY = seg[1];
                            ++index;
                        }
                        fpi.next();
                    }
                    continue block5;
                }
            }
        }
        this.segmentIndexes = new int[indexes.size()];
        int i = 0;
        while (i < this.segmentIndexes.length) {
            this.segmentIndexes[i] = (Integer)indexes.get(i);
            ++i;
        }
        this.initialized = true;
    }

    private int findUpperIndex(double LENGTH) {
        PathSegment pathSegment;
        if (!this.initialized) {
            this.init();
        }
        if (LENGTH < 0.0 || LENGTH > this.pathLength) {
            return -1;
        }
        int lowerBound = 0;
        int upperBound = this.segments.size() - 1;
        while (lowerBound != upperBound) {
            int curr = lowerBound + upperBound >> 1;
            PathSegment pathSegment2 = this.segments.get(curr);
            if (pathSegment2.getLength() >= LENGTH) {
                upperBound = curr;
                continue;
            }
            lowerBound = curr + 1;
        }
        while ((pathSegment = this.segments.get(upperBound)).getSegmentType() == 0 && upperBound != this.segments.size() - 1) {
            ++upperBound;
        }
        int upperIndex = -1;
        int currentIndex = 0;
        int numSegments = this.segments.size();
        while (upperIndex <= 0 && currentIndex < numSegments) {
            PathSegment ps = this.segments.get(currentIndex);
            if (ps.getLength() >= LENGTH && ps.getSegmentType() != 0) {
                upperIndex = currentIndex;
            }
            ++currentIndex;
        }
        return upperIndex;
    }

    public double getLengthOfPath() {
        if (!this.initialized) {
            this.init();
        }
        return this.pathLength;
    }

    public Point getSegmentPointAtLength(double LENGTH) {
        int upperIndex = this.findUpperIndex(LENGTH);
        if (upperIndex == -1) {
            return null;
        }
        PathSegment upper = this.segments.get(upperIndex);
        if (upperIndex == 0) {
            return new Point(upper.getX(), upper.getY());
        }
        PathSegment lower = this.segments.get(upperIndex - 1);
        double offset = LENGTH - lower.getLength();
        double theta = Math.atan2(upper.getY() - lower.getY(), upper.getX() - lower.getX());
        double xPoint = lower.getX() + offset * Math.cos(theta);
        double yPoint = lower.getY() + offset * Math.sin(theta);
        return new Point(xPoint, yPoint);
    }

    public Point getPointAtLength(double LENGTH) {
        PathIterator pathIterator = this.path.getPathIterator(new Affine());
        SingleSegmentPathIterator singleSegmentPathIterator = new SingleSegmentPathIterator();
        double pathLength = 0.0;
        double lastMoveX = 0.0;
        double lastMoveY = 0.0;
        double currentX = 0.0;
        double currentY = 0.0;
        double[] seg = new double[6];
        block5: while (!pathIterator.isDone()) {
            int segType = pathIterator.currentSegment(seg);
            switch (segType) {
                case 0: {
                    double lastX = currentX;
                    double lastY = currentY;
                    currentX = seg[0];
                    currentY = seg[1];
                    lastMoveX = currentX;
                    lastMoveY = currentY;
                    pathIterator.next();
                    if (!(pathLength > LENGTH)) continue block5;
                    return new Point(lastX, lastY);
                }
                case 1: {
                    double lastY;
                    double lastX;
                    double segmentLength = Point.distance(currentX, currentY, seg[0], seg[1]);
                    double angle = Math.atan2(seg[1] - currentY, seg[0] - currentX);
                    double step = segmentLength * 0.001;
                    double i = 0.0;
                    while (i < segmentLength) {
                        lastX = currentX;
                        lastY = currentY;
                        currentX += step * Math.cos(angle);
                        currentY += step * Math.sin(angle);
                        if (Double.compare(pathLength += step, LENGTH) >= 0) {
                            return new Point(lastX, lastY);
                        }
                        i += step;
                    }
                    pathIterator.next();
                    break;
                }
                case 4: {
                    pathLength += Point.distance(currentX, currentY, lastMoveX, lastMoveY);
                    double lastX = currentX;
                    double lastY = currentY;
                    currentX = lastMoveX;
                    currentY = lastMoveY;
                    pathIterator.next();
                    if (!(pathLength > LENGTH)) continue block5;
                    return new Point(lastX, lastY);
                }
                default: {
                    double lastY;
                    double lastX;
                    singleSegmentPathIterator.setPathIterator(pathIterator, currentX, currentY);
                    FlatteningPathIterator fpi = new FlatteningPathIterator(singleSegmentPathIterator, 0.001);
                    while (!fpi.isDone()) {
                        segType = fpi.currentSegment(seg);
                        if (segType == 1) {
                            pathLength += Point.distance(currentX, currentY, seg[0], seg[1]);
                            lastX = currentX;
                            lastY = currentY;
                            currentX = seg[0];
                            currentY = seg[1];
                            if (pathLength > LENGTH) {
                                return new Point(lastX, lastY);
                            }
                        }
                        fpi.next();
                    }
                    continue block5;
                }
            }
        }
        return null;
    }

    protected static class PathSegment {
        protected final int segmentType;
        protected double x;
        protected double y;
        protected double length;
        protected int index;

        PathSegment(int SEGMENT_TYPE, double X, double Y, double LENGTH, int INDEX) {
            this.segmentType = SEGMENT_TYPE;
            this.x = X;
            this.y = Y;
            this.length = LENGTH;
            this.index = INDEX;
        }

        public int getSegmentType() {
            return this.segmentType;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double X) {
            this.x = X;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double Y) {
            this.y = Y;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double LENGTH) {
            this.length = LENGTH;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int INDEX) {
            this.index = INDEX;
        }
    }

    protected static class SingleSegmentPathIterator
    implements PathIterator {
        protected PathIterator pathIterator;
        protected boolean done;
        protected boolean moveDone;
        protected double x;
        protected double y;

        protected SingleSegmentPathIterator() {
        }

        public void setPathIterator(PathIterator PATH_ITERATOR, double X, double Y) {
            this.pathIterator = PATH_ITERATOR;
            this.x = X;
            this.y = Y;
            this.done = false;
            this.moveDone = false;
        }

        @Override
        public int currentSegment(double[] COORDINATES) {
            int type = this.pathIterator.currentSegment(COORDINATES);
            if (!this.moveDone) {
                COORDINATES[0] = this.x;
                COORDINATES[1] = this.y;
                return 0;
            }
            return type;
        }

        @Override
        public Path.WindingRule getWindingRule() {
            return this.pathIterator.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.done || this.pathIterator.isDone();
        }

        @Override
        public void next() {
            if (!this.done) {
                if (!this.moveDone) {
                    this.moveDone = true;
                } else {
                    this.pathIterator.next();
                    this.done = true;
                }
            }
        }
    }
}

