/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum HashAlgorithm implements Api
{
    MD5("MSD5", "md5"),
    SHA1("SHA1", "sha1"),
    SHA256("SHA256", "sha256"),
    SHA224("SHA224", "sha224"),
    SHA384("SHA384", "sha384"),
    SHA512("SHA512", "sha512"),
    SHA3_256("SHA-3 256", "sha3_256"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private HashAlgorithm(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public HashAlgorithm getDefault() {
        return NONE;
    }

    @Override
    public HashAlgorithm getNotFound() {
        return NOT_FOUND;
    }

    public HashAlgorithm[] getAll() {
        return HashAlgorithm.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static HashAlgorithm fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "MD5": 
            case "md5": 
            case "MD-5": 
            case "MD_5": 
            case "md-5": 
            case "md_5": {
                return MD5;
            }
            case "SHA1": 
            case "sha1": 
            case "SHA-1": 
            case "SHA_1": 
            case "sha-1": 
            case "sha_1": {
                return SHA1;
            }
            case "SHA256": 
            case "SHA-256": 
            case "SHA_256": 
            case "sha256": 
            case "sha-256": 
            case "sha_256": {
                return SHA256;
            }
            case "SHA224": 
            case "SHA-224": 
            case "SHA_224": 
            case "sha224": 
            case "sha-224": 
            case "sha_224": {
                return SHA224;
            }
            case "SHA384": 
            case "SHA-384": 
            case "SHA_384": 
            case "sha384": 
            case "sha-384": 
            case "sha_384": {
                return SHA384;
            }
            case "SHA512": 
            case "SHA-512": 
            case "SHA_512": 
            case "sha512": 
            case "sha-512": 
            case "sha_512": {
                return SHA512;
            }
            case "sha3_256": 
            case "SHA3_256": 
            case "SHA-3-256": 
            case "sha-3-256": 
            case "SHA_3_256": 
            case "sha_3_256": {
                return SHA3_256;
            }
        }
        return NOT_FOUND;
    }

    public static List<HashAlgorithm> getAsList() {
        return Arrays.asList(HashAlgorithm.values());
    }
}

