/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum SignatureType implements Api
{
    RSA("RSA", "rsa"),
    DSA("DSA", "dsa"),
    ECDSA("ECDSA", "ecdsa"),
    EDDSA("EdDSA", "eddsa"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private SignatureType(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public SignatureType getDefault() {
        return NONE;
    }

    @Override
    public SignatureType getNotFound() {
        return NOT_FOUND;
    }

    public SignatureType[] getAll() {
        return SignatureType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static SignatureType fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "RSA": 
            case "rsa": {
                return RSA;
            }
            case "DSA": 
            case "dsa": {
                return DSA;
            }
            case "ECDSA": 
            case "ecdsa": {
                return ECDSA;
            }
            case "EDDSA": 
            case "EdDSA": 
            case "eddsa": {
                return EDDSA;
            }
        }
        return NOT_FOUND;
    }

    public static List<SignatureType> getAsList() {
        return Arrays.asList(SignatureType.values());
    }
}

