/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.scopes;

import eu.hansolo.jdktools.scopes.Scope;
import java.util.Arrays;
import java.util.List;

public enum SignatureScope implements Scope
{
    SIGNATURE_AVAILABLE("Signature available", "signature_available"),
    SIGNATURE_NOT_AVAILABLE("Signature not available", "signature_not_available");

    private final String uiString;
    private final String apiString;

    private SignatureScope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    public static Scope fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "SIGNATURE_AVAILABLE": 
            case "signatureAvailable": 
            case "signature_available": {
                return SIGNATURE_AVAILABLE;
            }
            case "signatureNotAvailable": 
            case "SIGNATURE_NOT_AVAILABLE": 
            case "signature_not_available": {
                return SIGNATURE_NOT_AVAILABLE;
            }
        }
        return NOT_FOUND;
    }

    public static List<SignatureScope> getAsList() {
        return Arrays.asList(SignatureScope.values());
    }
}

