/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.scopes;

import eu.hansolo.jdktools.scopes.Scope;
import java.util.Arrays;
import java.util.List;

public enum UsageScope implements Scope
{
    FREE_TO_USE_IN_PRODUCTION("Free to use in production", "free_to_use_in_production"),
    LICENSE_NEEDED_FOR_PRODUCTION("License needed for production", "license_needed_for_production");

    private final String uiString;
    private final String apiString;

    private UsageScope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    public static Scope fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "free": 
            case "free_to_use": 
            case "free_to_use_in_production": {
                return FREE_TO_USE_IN_PRODUCTION;
            }
            case "license_needed": 
            case "license_needed_for_production": 
            case "license": {
                return LICENSE_NEEDED_FOR_PRODUCTION;
            }
        }
        return NOT_FOUND;
    }

    public static List<UsageScope> getAsList() {
        return Arrays.asList(UsageScope.values());
    }
}

